package io.adbrix.sdk.component;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;

import io.adbrix.sdk.data.ABXBooleanState;
import io.adbrix.sdk.domain.ABXConstants;

public class AbxLog {

    private AbxLog(){}

    public static void checkDebugAppInstalled(Context context){
        //개발시엔 디버깅 앱 설치
        ABXBooleanState.getInstance().isDebugAppInstalled.getAndSet(checkPkgInstall(context));

        if (ABXBooleanState.getInstance().isDebugAppInstalled())
            AbxLog.d("QA MODE!", true);
    }

    public static void v(String msg, boolean QaModeOnly){
        if (!ABXBooleanState.getInstance().isDebugAppInstalled()) {
            return;
        }
        Log.v(ABXConstants.LOGTAG, msg);
    }

    public static void d(String msg, boolean QaModeOnly){
        if (!ABXBooleanState.getInstance().isDebugAppInstalled()) {
            return;
        }
        if (msg.length() > 4000) largeLog(ABXConstants.LOGTAG, msg);
        else Log.d(ABXConstants.LOGTAG, msg);
    }

    public static void i(String msg, boolean QaModeOnly){
        if (!ABXBooleanState.getInstance().isDebugAppInstalled()) {
            return;
        }
        Log.i(ABXConstants.LOGTAG, msg);
    }

    public static void w(String msg, boolean QaModeOnly){
        if (!ABXBooleanState.getInstance().isDebugAppInstalled()) {
            return;
        }
        Log.w(ABXConstants.LOGTAG, msg);
    }

    public static void e(String msg, boolean QaModeOnly){
        if (!ABXBooleanState.getInstance().isDebugAppInstalled()) {
            return;
        }
        Log.e(ABXConstants.LOGTAG, msg);
    }

    private static boolean checkPkgInstall(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            String ADBRIX_RM_DEBUG_APP = "com.igaworks.adbrixrm.debug";
            pm.getApplicationInfo(ADBRIX_RM_DEBUG_APP, 0);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    private static void largeLog(String tag, String content) {
        if (content.length() > 4000) {
            Log.d(tag, content.substring(0, 4000));
            largeLog(tag, content.substring(4000));
        } else {
            Log.d(tag, content);
        }
    }
}
