package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.CommonUtils;

public class SelfServeInAppMessage {
    @Nullable private final String campaignId;
    @Nullable private final String extAttrString;

    public SelfServeInAppMessage(@Nullable String campaignId, @Nullable String extAttrString) {
        this.campaignId = campaignId;
        this.extAttrString = extAttrString;
    }

    @Nullable
    public String getCampaignId() {
        return campaignId;
    }

    @Nullable
    public JSONObject getExtAttr() {
        JSONObject jsonObject = new JSONObject();
        if(CommonUtils.isNullOrEmpty(extAttrString)){
            return jsonObject;
        }
        try {
            jsonObject = new JSONObject(extAttrString);
        } catch (JSONException e) {
            AbxLog.w(e, true);
        }
        return jsonObject;
    }

    @Override
    public String toString() {
        return "{" +
                "campaignId='" + campaignId + '\'' +
                ", extAttrString='" + extAttrString + '\'' +
                '}';
    }
}
