package io.adbrix.sdk.domain.model;

import org.json.JSONObject;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class ActionHistory {
    @Nullable
    public final String historyId;
    @Nullable
    public final String actionType;
    public final ActionContent content;
    public final long timeStamp;
    @Nullable
    public final String group;
    public final boolean isServerSynced;
    public final boolean isRead;

    public ActionHistory(
            @Nullable
            String historyId,
            @Nullable
            String actionType,
            String actionContentString,
            long timeStamp,
            @Nullable
            String group,
            boolean isServerSynced,
            boolean isRead
    ) {
        this.historyId = historyId;
        this.actionType = actionType;
        this.content = ActionContent.fromJSONString(actionContentString);
        this.timeStamp = timeStamp;
        this.group = group;
        this.isServerSynced = isServerSynced;
        this.isRead = isRead;
    }

    public static ActionHistory fromJSONObject(JSONObject jsonObject, boolean isServerSynced) {
        return new ActionHistory(
                CommonUtils.convertNullStringToNull(jsonObject.optString(CoreConstants.ACTION_HISTORY_RESPONSE_HISTORY_ID)),
                CommonUtils.convertNullStringToNull(jsonObject.optString(CoreConstants.ACTION_HISTORY_RESPONSE_ACTION_TYPE)),
                CommonUtils.convertNullStringToNull(jsonObject.optString(CoreConstants.ACTION_HISTORY_RESPONSE_CONTENTS)),
                jsonObject.optLong(CoreConstants.ACTION_HISTORY_RESPONSE_TIMESTAMP),
                CommonUtils.convertNullStringToNull(jsonObject.optString(CoreConstants.ACTION_HISTORY_RESPONSE_GROUP)),
                isServerSynced,
                jsonObject.optBoolean(CoreConstants.ACTION_HISTORY_RESPONSE_IS_READ)
        );
    }

    @Override
    public String toString() {
        return "ActionHistory{" +
                "historyId='" + historyId + '\'' +
                ", actionType='" + actionType + '\'' +
                ", content=" + content +
                ", timeStamp=" + timeStamp +
                ", group='" + group + '\'' +
                ", isServerSynced=" + isServerSynced +
                ", isRead=" + isRead +
                '}';
    }
}
