package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.domain.model.DeferredDeeplinkModel;
import io.adbrix.sdk.domain.model.LogEventParameter;

public class DeferredDeeplinkModelProvider implements IApiModelProvider<DeferredDeeplinkModel> {
    private IABXComponentsFactory componentsFactory;
    private LogEventParameter logEventParameter;

    public DeferredDeeplinkModelProvider(IABXComponentsFactory componentsFactory, LogEventParameter logEventParameter) {
        this.componentsFactory = componentsFactory;
        this.logEventParameter = logEventParameter;
    }

    @Override
    public DeferredDeeplinkModel provide() {
        //and : google referrer 정보 추가
        //firstopen의 logid 정보 추가
        return new DeferredDeeplinkModel(
                componentsFactory,
                logEventParameter
        );
    }
}
