package io.adbrix.sdk.domain.model;

import org.json.JSONObject;

import io.adbrix.sdk.utils.CommonUtils;

public class EventSamplingModel {
    public EventSamplingType type;
    private JSONObject eventWithProbability;

    public EventSamplingModel(JSONObject jsonObject) {
        this.type = EventSamplingType.fromInteger(jsonObject.optInt("type", -1));
        this.eventWithProbability = jsonObject.optJSONObject("eventProbabilities");
        if(CommonUtils.isNullOrEmpty(eventWithProbability)){
            this.eventWithProbability = new JSONObject();
        }
    }
    public void set(JSONObject jsonObject){
        this.type = EventSamplingType.fromInteger(jsonObject.optInt("type", -1));
        this.eventWithProbability = jsonObject.optJSONObject("eventProbabilities");
        if(CommonUtils.isNullOrEmpty(eventWithProbability)){
            this.eventWithProbability = new JSONObject();
        }
    }

    public int getProbability(String eventName) {
        return eventWithProbability.optInt(eventName, -1);
    }

    public boolean contains(String eventName) {
        return eventWithProbability.has(eventName);
    }
}
