package io.adbrix.sdk.utils;

import android.database.Cursor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

import io.adbrix.sdk.component.AbxLog;

public final class IoUtils {
    public static final int DEFAULT_BUFFER_SIZE = 32 * 1024; // 32 KB
    private IoUtils() {
    }
    public static void readAndCloseStream(InputStream is) {
        final byte[] bytes = new byte[DEFAULT_BUFFER_SIZE];
        try {
            while (is.read(bytes, 0, DEFAULT_BUFFER_SIZE) != -1);
        } catch (IOException ignored) {
        } finally {
            closeSilently(is);
        }
    }
    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (Exception ignored) {
            }
        }
    }
    public static void close(Cursor cursor){
        if(cursor == null){
            return;
        }
        if(cursor.isClosed()){
            return;
        }
        cursor.close();
    }
    public static void close(Closeable closeable){
        if(closeable == null){
            return;
        }
        try {
            closeable.close();
        }catch (Exception e){
            AbxLog.e(e, true);
        }
    }
    public static void close(AutoCloseable closeable){
        if(closeable == null){
            return;
        }
        try {
            closeable.close();
        }catch (Exception e){
            AbxLog.e(e, true);
        }
    }
}
