package io.adbrix.sdk.utils;

import android.content.Context;

import io.adbrix.sdk.component.AbxLog;

public class DisplayUtils {
    public static float dpToPx(Context context, float dp) {
        if (context == null) {
            AbxLog.w("DisplayUtils$dpToPx context is null", true);
            return -1;
        }
        return dp * context.getResources().getDisplayMetrics().density;
    }


    public static float pxToDp(Context context, float px) {
        if (context == null) {
            return -1;
        }
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static int countLines(String value){
        String line = System.getProperty("line.separator");
        return countChar(value, line);
    }

    public static int countChar(String value, String target){
        int count = 0;
        int index = value.indexOf(target);

        while (index != -1) {
            count++;
            index = value.indexOf(target, index + 1);
        }

        return count;
    }
}
