package io.adbrix.sdk.ui.push.utils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.igaworks.v2.core.push.notification.AbxPushReceiver;

import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.ui.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.ui.push.models.BigPicturePushProperties;
import io.adbrix.sdk.ui.push.models.BigTextPushProperties;

public class PushLocalBridgeUtil {

    public static final int PUSH_SECOND_OFFSET = 1000;

    private PushLocalBridgeUtil() {
    }

    public static void setBigTextClientPushEvent(
            Context ctx,
            BigTextPushProperties bigTextPushProperties,
            boolean alwaysIsShown,
            AbxPushCommonDAO abxPushCommonDAO
    ) {
        if (bigTextPushProperties.getSecond() < 0) {
            AbxLog.e("Wrong input parameters! Second parmeter must be a positive integer.", false);
        } else {
            long notificationTime;
            String propObjToString;
            Bundle bundle;
            AlarmManager alarmManager;
            Intent alarmIntent;
            PendingIntent pendingIntent;

            AbxLog.d("PushBridge :: Big Text Client Push ! ", true);
            notificationTime = System.currentTimeMillis() + (bigTextPushProperties.getSecond() * PUSH_SECOND_OFFSET);
            alarmIntent = new Intent(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE);
            alarmIntent.setClass(ctx, AbxPushReceiver.class);

            bundle = new Bundle();
            bundle.putBoolean(CompatConstants.PUSH_USER_INPUT_ALWAYS_IS_SHOWN, alwaysIsShown);
            bundle.putString(CompatConstants.PUSH_PROP_STYLE, CompatConstants.PUSH_STYLE_BIG_TEXT);

            JSONObject bigTextJson = bigTextPushProperties.toJSONObject();
            propObjToString = bigTextJson.toString();
            if (propObjToString != null) {
                bundle.putString(CompatConstants.PUSH_TEXT_PROPERTIES, propObjToString);
            }

            alarmIntent.putExtras(bundle);
            pendingIntent = PendingIntent.getBroadcast(ctx, bigTextPushProperties.getEventId(), alarmIntent, PushUtils.getPendingIntentFlags(ctx));
            PushUtils.setAlarm(ctx, AlarmManager.RTC_WAKEUP, notificationTime, pendingIntent);
            abxPushCommonDAO.insertOrReplacePushEvent(
                    bigTextPushProperties.getBigContentTitle(),
                    bigTextPushProperties.getContentText(),
                    bigTextPushProperties.getEventId(),
                    notificationTime,
                    1);
        }
    }

    public static void setBigPictureClientPushEvent(
            Context ctx,
            BigPicturePushProperties bigPicturePushProperties,
            boolean alwaysIsShown,
            AbxPushCommonDAO abxPushCommonDAO
    ) {
        if (bigPicturePushProperties.getSecond() < 0) {
            AbxLog.e("Wrong input parameters! Second parmeter must be a positive integer.", false);
        } else {
            AbxLog.d("PushBridge :: Big Picture Client Push ! ", true);
            long notificationTime;
            String propObjToString;
            Bundle bundle;
            AlarmManager alarmManager;
            Intent alarmIntent;
            PendingIntent pendingIntent;

            notificationTime = System.currentTimeMillis() + (bigPicturePushProperties.getSecond() * PUSH_SECOND_OFFSET);

            bundle = new Bundle();
            bundle.putBoolean(CompatConstants.PUSH_USER_INPUT_ALWAYS_IS_SHOWN, alwaysIsShown);
            bundle.putString(CompatConstants.PUSH_PROP_STYLE, CompatConstants.PUSH_STYLE_BIG_PICTURE);

            JSONObject bigPictureJson = bigPicturePushProperties.toJSONObject();
            propObjToString = bigPictureJson.toString();
            if (propObjToString != null) {
                bundle.putString(CompatConstants.PUSH_PICTURE_PROPERTIES, propObjToString);
            }

            alarmIntent = new Intent(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE);
            alarmIntent.setClass(ctx, AbxPushReceiver.class);
            alarmIntent.putExtras(bundle);

            pendingIntent = PendingIntent.getBroadcast(ctx, bigPicturePushProperties.getEventId(), alarmIntent, PushUtils.getPendingIntentFlags(ctx));
            PushUtils.setAlarm(ctx, AlarmManager.RTC_WAKEUP, notificationTime, pendingIntent);
            abxPushCommonDAO.insertOrReplacePushEvent(bigPicturePushProperties.getBigContentTitle(), bigPicturePushProperties.getContentText(), bigPicturePushProperties.getEventId(), notificationTime, 1);
        }
    }

    public static void cancelClientPushEvent(
            Context ctx,
            int eventId,
            AbxPushCommonDAO abxPushCommonDAO) {
        try {
            AbxLog.d("Cancel reserved push :: event Id = " + eventId, false);
            Intent alarmIntent = new Intent(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE);
            alarmIntent.setClass(ctx, AbxPushReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(ctx, eventId, alarmIntent, PushUtils.getPendingIntentFlags(ctx));
            AlarmManager alarmManager = (AlarmManager) ctx.getSystemService(Context.ALARM_SERVICE);
            alarmManager.cancel(pendingIntent);
            long result = abxPushCommonDAO.deletePushEvent(eventId);
            if (result == -1)
                AbxLog.e("Failed to delete record form push evt table", true);
        } catch (Exception e) {
            AbxLog.e(e, true);
        }

    }
}

