package io.adbrix.sdk.ui.push.utils;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;

import com.igaworks.v2.core.AdBrixRm;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.ui.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.ui.push.components.PushController;
import io.adbrix.sdk.ui.push.models.BigPicturePushProperties;
import io.adbrix.sdk.ui.push.style.BasePushStyle;
import io.adbrix.sdk.ui.push.style.BigPicturePushStyle;
import io.adbrix.sdk.ui.push.style.BigTextPushStyle;
import io.adbrix.sdk.ui.push.style.IPushStyle;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.image.ImageLoader;

public class AbxPushReceiverUtil {
    private AbxPushReceiverUtil(){}
    public static void callbackPushOpen(Context context, Intent intent){
        Bundle bundle = intent.getExtras();
        if (intent.getAction().equals(CompatConstants.REMOTE_PUSH_OPEN_CLICKED)) {
            remotePushOpenTracking(context, bundle);
            return;
        }
        if (intent.getAction().equals(CompatConstants.LOCAL_PUSH_OPEN_CLCKED)) {
            localPushOpenTracking(context, bundle);
            return;
        }
        AbxLog.d("Doesn't match with adbrix push open action", true);
    }

    public static void showNotification(Context context, Intent intent, AbxPushCommonDAO abxPushCommonDAO){
        IPushStyle pushStyle = getNotification(context, intent, abxPushCommonDAO);
        if(pushStyle == null){
            AbxLog.d("pushStyle is null", false);
            return;
        }
        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        int notificationId = pushStyle.getNotificationId();
        notificationManager.notify(notificationId, pushStyle.getNotification());
        AbxLog.d("showNotification id: "+notificationId, false);
    }

    private static IPushStyle getNotification(Context context, Intent intent, AbxPushCommonDAO abxPushCommonDAO){
        String action = intent.getAction();
        if(CompatConstants.PUSH_REMOTE_MESSAGE_RECEIVE.equals(action) ||
                CompatConstants.PUSH_REMOTE_MESSAGE_RECEIVE_FROM_FIREBASE_MESSAGING_SERVICE.equals(action)){
            String receivedJSONString = intent.getExtras().getString(ABXConstants.PUSH_REMOTE_FCM_KEY);
            try {
                JSONObject objFromServer = new JSONObject(receivedJSONString);
                JSONObject alertJSON = objFromServer.optJSONObject(ABXConstants.PUSH_REMOTE_KEY_ALERT);
                JSONObject customAlertJSON = objFromServer.optJSONObject(ABXConstants.PUSH_REMOTE_KEY_CUSTOM_ALERT);
                String language = CommonUtils.getLanguage(context);
                AbxLog.d("Notification setting default language : " + language, false);
                JSONObject languageJson = PushUtils.getLanguageJson(language, customAlertJSON, objFromServer);
                Bitmap imageForExpended = getImageForExpendedFromRemotePush(context, alertJSON, languageJson);
                if(imageForExpended != null){
                    return new BigPicturePushStyle(context, intent, abxPushCommonDAO, imageForExpended);
                }
                String bigTextBody = "";
                if (languageJson.has(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY)) {
                    if (PushUtils.checkHasVaildKey(languageJson, ABXConstants.PUSH_REMOTE_KEY_BIG_BODY) && !CommonUtils.isNullOrEmpty(languageJson.optString(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY))){
                        bigTextBody = languageJson.optString(ABXConstants.PUSH_REMOTE_KEY_BIG_BODY);
                    }
                }
                if(!CommonUtils.isNullOrEmpty(bigTextBody)){
                    return new BigTextPushStyle(context, intent, abxPushCommonDAO);
                }
                return new BasePushStyle(context, intent, abxPushCommonDAO);
            } catch (Exception e) {
                AbxLog.w("ERROR::Can't create JSON Object from received data",e, false);
            }
            return null;
        }
        if(CompatConstants.PUSH_LOCAL_MESSAGE_RECEIVE.equals(action)){
            String style = intent.getExtras().getString(CompatConstants.PUSH_PROP_STYLE);
            if(CommonUtils.isNullOrEmpty(style)){
                AbxLog.d("style is empty", false);
                return null;
            }
            Bitmap imageForExpended = getImageForExpendedFromLocalPush(style, intent, context);
            if(imageForExpended == null){
                return new BigTextPushStyle(context, intent, abxPushCommonDAO);
            }
            if(CompatConstants.PUSH_STYLE_BIG_TEXT.equals(style)){
                return new BigTextPushStyle(context, intent, abxPushCommonDAO);
            } else if(CompatConstants.PUSH_STYLE_BIG_PICTURE.equals(style)){
                return new BigPicturePushStyle(context, intent, abxPushCommonDAO, imageForExpended);
            } else{
                AbxLog.d("Doesn't match with local notification style", false);
                return null;
            }
        }
        return null;
    }

    private static Bitmap getImageForExpendedFromLocalPush(String style, Intent intent, Context context){
        Bitmap image = null;
        if(!CompatConstants.PUSH_STYLE_BIG_PICTURE.equals(style)){
            return image;
        }
        String properties = intent.getExtras().getString(CompatConstants.PUSH_PICTURE_PROPERTIES);
        BigPicturePushProperties bigPicturePushProperties = new BigPicturePushProperties();
        try {
            JSONObject jsonObject = new JSONObject(properties);
            bigPicturePushProperties = bigPicturePushProperties.setFromJSONObject(jsonObject);
            String imageUrl = bigPicturePushProperties.getBigPictureUrl();
            if(CommonUtils.isNullOrEmpty(imageUrl)){
                int resId = bigPicturePushProperties.getResourceId();
                if(resId != 0){
                    ImageLoader imageLoader = new ImageLoader(context);
                    image = imageLoader.getImageFromDrawable(resId);
                }
                if(CommonUtils.notNull(image)){
                    return image;
                }
            }
            ImageLoader imageLoader = new ImageLoader(context);
            image = imageLoader.getImageFromUrl(imageUrl);
            return image;
        } catch (JSONException e) {
            AbxLog.e("ERROR :: bigPicturePushProperties parsing is failed", false);
            return image;
        }
    }

    private static Bitmap getImageForExpendedFromRemotePush(Context context, JSONObject alertJson, JSONObject customAlertJson){
        Bitmap image = null;
        String imageUrl = "";
        if(!CommonUtils.isNullOrEmpty(alertJson)){
            if(alertJson.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE)){
                imageUrl = alertJson.optString(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE);
            }
        }
        if(!CommonUtils.isNullOrEmpty(customAlertJson)){
            if(customAlertJson.has(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE)){
                imageUrl = customAlertJson.optString(ABXConstants.PUSH_REMOTE_KEY_PUSH_IMAGE);
            }
        }
        if(CommonUtils.isNullOrEmpty(imageUrl)){
            AbxLog.d("image url is null", false);
            return image;
        }
        ImageLoader imageLoader = new ImageLoader(context);
        image = imageLoader.getImageFromUrl(imageUrl);
        return image;
    }

    private static void localPushOpenTracking(Context context, Bundle bundle) {
        if (bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES) != null) {
            String properties = bundle.getString(CompatConstants.PUSH_TEXT_PROPERTIES);
            PushController.getInstance().callBackLocalPushMsg(properties);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject = new JSONObject(properties);
            } catch (JSONException e) {
                AbxLog.w(e, true);
            }
            PushController.getInstance().callBackLocalPushMsg(context, jsonObject);
        } else if (bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES) != null) {
            String properties = bundle.getString(CompatConstants.PUSH_PICTURE_PROPERTIES);
            PushController.getInstance().callBackLocalPushMsg(properties);
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject = new JSONObject(properties);
            } catch (JSONException e) {
                AbxLog.w(e, true);
            }
            PushController.getInstance().callBackLocalPushMsg(context, jsonObject);
        } else {
            AbxLog.d("ERROR :: can't call back local push msg ", true);
        }
    }

    private static void startPushButtonClickTracking(Context context, Bundle bundle) {
//        AbxPushCommonDAO.flushStackedPushList();
        AbxLog.d("Push Button Clicked", true);
        String deeplinkUrl = bundle.getString("buttonDeepLinkUrl");
        if (deeplinkUrl != null) {
            NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
            notificationManager.cancel(0);
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(deeplinkUrl));
            try {
                context.startActivity(intent);
            } catch (Exception e) {
                AbxLog.d("DeepLinking failed.. please check your host and shceme", true);
            }
        }
    }

    private static void remotePushOpenTracking(Context context, Bundle bundle) {
        AbxLog.d("Start open-push tracking", true);
        AdBrixRm.AbxRemotePushModel abxRemotePushModel = new AdBrixRm.AbxRemotePushModel(context, bundle);
        JSONObject callBackJson = new JSONObject();
        try {
            if(!CommonUtils.isNullOrEmpty(abxRemotePushModel.deeplinkUrl)){
                callBackJson.put(ABXConstants.PUSH_REMOTE_KEY_DEEPLINKURL, abxRemotePushModel.deeplinkUrl);
            }
            if(!CommonUtils.isNullOrEmpty(abxRemotePushModel.deeplinkJson)){
                callBackJson.put(ABXConstants.PUSH_REMOTE_KEY_DEEPLINKJSON, abxRemotePushModel.deeplinkJson);
            }
        } catch (JSONException e) {
            AbxLog.w("parsing error", false);
        }
        if(!abxRemotePushModel.isOpenPushEventParamAvailable()){
            AbxLog.w("Adbrix push tracking parameters don't exist!", false);
            return;
        }
        PushController.getInstance().callBackRemotePushMsg(callBackJson.toString());
        PushController.getInstance().callBackRemotePushMsg(context, abxRemotePushModel);
        PushController.getInstance().pushEventTracking(abxRemotePushModel.toOpenPushEventParamJson());
    }
}
