package io.adbrix.sdk.ui.inappmessage.webview;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.JavascriptInterface;

import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.InAppMessageClickPostingObservable;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.ui.inappmessage.InAppMessageDAO;
import io.adbrix.sdk.ui.inappmessage.InAppMessageManager;
import io.adbrix.sdk.ui.inappmessage.InAppMessageViewFactory;
import io.adbrix.sdk.utils.CommonUtils;

public class InAppMessageWebViewInterface {
   public static final String WEB_VIEW_BRIDGE = "adbrixBridge";
   public static final String METHOD_NAME = "method_name";
   public static final String ACTION_TYPE = "action_type";
   public static final String ACTION_ID = "action_id";
   public static final String ACTION_ARGS = "action_arg";
   private Context context;

   private WebViewViewFactory webViewFactory;
   private InAppMessageDAO inAppMessageDAO;
   private DfnInAppMessage inAppMessage;

   public InAppMessageWebViewInterface(Context context, InAppMessageDAO inAppMessageDAO, WebViewViewFactory webViewFactory, DfnInAppMessage inAppMessage) {
      this.context = context;
      this.inAppMessageDAO = inAppMessageDAO;
      this.webViewFactory = webViewFactory;
      this.inAppMessage = inAppMessage;
   }

   @JavascriptInterface
   public void invoke(String json){
      AbxLog.d(WEB_VIEW_BRIDGE+":invoke:" + json , true);
      if(CommonUtils.isNull(webViewFactory)){
         AbxLog.e("webViewFactory is null", true);
         return;
      }
      try {
         if (json != null) {
            JSONObject invokeJson = new JSONObject(json);
            if(invokeJson.has(METHOD_NAME)){
               String methodName = invokeJson.getString("method_name");
               if(methodName.equals("loadComplete")){
                  loadComplete(webViewFactory);
               } else if(methodName.equals("loadFail")){
                  loadFail();
               }
               else if(methodName.equals("onClick")){
                  String actionType = invokeJson.getString(ACTION_TYPE);
                  String actionId = invokeJson.has(ACTION_ID) ? invokeJson.getString(ACTION_ID) : "";
                  String actionArg = invokeJson.has(ACTION_ARGS) ? invokeJson.getString(ACTION_ARGS) : "";
                  if(actionType.equals("close")){
                     close(actionId, actionArg);
                  }
                  else if(actionType.equals("dont_show_me_today_and_close")){
                     dont_show_me_today_and_close(actionId, actionArg);
                  }
                  else if(actionType.equals("deeplink_and_close")){
                     deeplink_and_close(actionId, actionArg);
                  }
                  else if(actionType.equals("weblink")){
                     weblink(actionId, actionArg);
                  }
                  else if(actionType.equals("weblink_and_close")){
                     weblink_and_close(actionId, actionArg);
                  }
               }
            }
         }
      }catch (Exception e){}
   }
   public void loadComplete(WebViewViewFactory webViewFactory){
      AbxLog.d(WEB_VIEW_BRIDGE+":loadComplete", true);
      webViewFactory.loadComplete();
   }
   public void loadFail(){
      AbxLog.d(WEB_VIEW_BRIDGE+":loadFail", true);
      InAppMessageManager.getInstance().close(IAMEnums.CloseType.LOAD_FAIL);
   }
   public void close(String action_id, String action_arg){
      AbxLog.d(WEB_VIEW_BRIDGE+":close/"+ action_id+"/"+action_arg, true);
      InAppMessageManager.getInstance().close(IAMEnums.CloseType.ON_CLICK_FROM_CLOSE_BUTTON);
      if(!CommonUtils.isNullOrEmpty(action_id))
         sendClickEvent(action_id, IAMEnums.ActionType.CLOSE, action_arg);
   }

   public void deeplink_and_close(String action_id, String action_arg){
      AbxLog.d(WEB_VIEW_BRIDGE+":deeplink_and_close/"+ action_id+"/"+action_arg, true);
      InAppMessageManager.getInstance().close(IAMEnums.CloseType.OPEN_DEEPLINK_AND_CLOSE);
      Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(action_arg));
      intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
      try {
         context.startActivity(intent);
      } catch (ActivityNotFoundException exception) {
         AbxLog.d("adbrixBridge: ActivityNotFoundException, button action url was " + action_arg, true);
      }
      sendClickEvent(action_id, IAMEnums.ActionType.DEEPLINK_AND_CLOSE, action_arg);
   }

   public void weblink_and_close(String action_id, String action_arg){
      AbxLog.d(WEB_VIEW_BRIDGE+":weblink_and_close/"+ action_id+"/"+action_arg, true);
      InAppMessageManager.getInstance().close(IAMEnums.CloseType.OPEN_DEEPLINK_AND_CLOSE);
      Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(action_arg));
      intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
      try {
         context.startActivity(intent);
      } catch (ActivityNotFoundException exception) {
         AbxLog.d("adbrixBridge: ActivityNotFoundException, button action url was " + action_arg, true);
      }
      sendClickEvent(action_id, IAMEnums.ActionType.DEEPLINK_AND_CLOSE, action_arg);
   }

   public void weblink(String action_id, String action_arg){
      AbxLog.d(WEB_VIEW_BRIDGE+":weblink/"+ action_id+"/"+action_arg, true);
      InAppMessageManager.getInstance().close(IAMEnums.CloseType.OPEN_DEEPLINK);
      Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(action_arg));
      intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
      try {
         context.startActivity(intent);
      } catch (ActivityNotFoundException exception) {
         AbxLog.d("adbrixBridge: ActivityNotFoundException, button action url was " + action_arg, true);
      }
      sendClickEvent(action_id, IAMEnums.ActionType.WEBLINK, action_arg);
   }

   public void dont_show_me_today_and_close(String action_id, String action_arg){
      AbxLog.d(WEB_VIEW_BRIDGE+":dont_show_me_today_and_close/"+ action_id+"/"+action_arg, true);
      SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("EE", Locale.ENGLISH);

      long currentTimeMillis = System.currentTimeMillis() + TimeZone.getDefault().getRawOffset();
      String currentDay = localSimpleDateFormat.format(System.currentTimeMillis());

      inAppMessageDAO.updateOneDayCloseInAppMessageTable(inAppMessage.getCampaignId(), currentDay, currentTimeMillis);
      InAppMessageManager.getInstance().close(IAMEnums.CloseType.ON_CLICK_FROM_CLOSE_BUTTON);
      sendClickEvent(action_id, IAMEnums.ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE, action_arg);
   }
   private void sendClickEvent(String actionId, IAMEnums.ActionType actionType, String actionArg){
      Map<String, Object> eventParam = new HashMap<>();
      try {
         eventParam = CommonUtils.getMapFromJSONObject(inAppMessage.growthEventParam.getJson());
      } catch (Exception e) {
//         AbxLog.w(e, true);
      }

      if (!eventParam.containsKey(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_ID)) {
         eventParam.put(CoreConstants.IN_APP_MESSAGE_CAMPAIGN_ID_KEY, inAppMessage.getCampaignId());
      }

      eventParam.put(CoreConstants.IN_APP_MESSAGE_ACTION_ID_ABX_KEY, actionId);
      eventParam.put(CoreConstants.IN_APP_MESSAGE_EVENT_TYPE_ABX_KEY, IAMEnums.EventType.CLICK.getValue());

      webViewFactory.getAbxContextController().logEvent(new LogEventParameter(
              CoreConstants.GROUP_ABX,
              CoreConstants.EVENT_IN_APP_MESSAGE,
              CommonUtils.parseValueWithDataType(eventParam, CommonUtils.FixType.PREFIX),
              0,
              0
      ));
      InAppMessageClickPostingObservable.getInstance().postInAppMessageClickToMainThread(
              actionId,
              actionType.getValue(),
              actionArg,
              IAMEnums.ActionType.CLOSE.equals(actionType)
                      || IAMEnums.ActionType.DEEPLINK_AND_CLOSE.equals(actionType)
                      || IAMEnums.ActionType.WEBLINK_AND_CLOSE.equals(actionType)
                      || IAMEnums.ActionType.DONT_SHOW_ME_TODAY_AND_CLOSE.equals(actionType)
      );
   }
}