package io.adbrix.sdk.domain.model;

import static io.adbrix.sdk.domain.model.SubscriptionStatus.Type.UNDEFINED;

import io.adbrix.sdk.component.AbxLog;

public class SubscriptionStatus {
    public enum Type{
        SUBSCRIBED,
        UNSUBSCRIBED,
        UNDEFINED
    }
    public static final String RESPONSE_RESULT_CODE = "result_code";
    public static final String RESPONSE_RESULT_MSG = "result_msg";
    public static final String RESPONSE_RESULT_DATA = "result_data";
    public static final String RESPONSE_PROPERTIES = "properties";
    public static final String INFORMATIVE_NOTIFICATION_FLAG = "abx:info_flag";
    public static final String MARKETING_NOTIFICATION_FLAG = "abx:mkt_flag";
    public static final String MARKETING_NOTIFICATION_FLAG_FOR_PUSH_CHANNEL = "abx:mkt_push_flag";
    public static final String MARKETING_NOTIFICATION_FLAG_FOR_SMS_CHANNEL = "abx:mkt_sms_flag";
    public static final String MARKETING_NOTIFICATION_FLAG_FOR_KAKAO_CHANNEL = "abx:mkt_kakao_flag";
    public static final String MARKETING_NOTIFICATION_AT_NIGHT_FLAG = "abx:night_flag";
    public static final String MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_PUSH_CHANNEL = "abx:night_push_flag";
    public static final String MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_SMS_CHANNEL = "abx:night_sms_flag";
    public static final String MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_KAKAO_CHANNEL = "abx:night_kakao_flag";

    private Type informativeNotificationFlag;
    private Type marketingNotificationFlag;
    private Type marketingNotificationFlagForPushChannel;
    private Type marketingNotificationFlagForSmsChannel;
    private Type marketingNotificationFlagForKakaoChannel;
    private Type marketingNotificationAtNightFlag;
    private Type marketingNotificationAtNightFlagForPushChannel;
    private Type marketingNotificationAtNightFlagForSmsChannel;
    private Type marketingNotificationAtNightFlagForKakaoChannel;

    public SubscriptionStatus() {
        this.informativeNotificationFlag = Type.UNDEFINED;
        this.marketingNotificationFlag = Type.UNDEFINED;
        this.marketingNotificationFlagForPushChannel = Type.UNDEFINED;
        this.marketingNotificationFlagForSmsChannel = Type.UNDEFINED;
        this.marketingNotificationFlagForKakaoChannel = Type.UNDEFINED;
        this.marketingNotificationAtNightFlag = Type.UNDEFINED;
        this.marketingNotificationAtNightFlagForPushChannel = Type.UNDEFINED;
        this.marketingNotificationAtNightFlagForSmsChannel = Type.UNDEFINED;
        this.marketingNotificationAtNightFlagForKakaoChannel = Type.UNDEFINED;
    }
    public static class Builder{
        private SubscriptionStatus subscriptionStatus;
        public Builder() {
            subscriptionStatus = new SubscriptionStatus();
        }

        public Builder setInformativeNotificationFlag(Type informativeNotificationFlag) {
            if(UNDEFINED.equals(informativeNotificationFlag)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.informativeNotificationFlag = informativeNotificationFlag;
            return this;
        }

        public Builder setMarketingNotificationFlag(Type marketingNotificationFlag) {
            if(UNDEFINED.equals(marketingNotificationFlag)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationFlag = marketingNotificationFlag;
            return this;
        }

        public Builder setMarketingNotificationFlagForPushChannel(Type marketingNotificationFlagForPushChannel) {
            if(UNDEFINED.equals(marketingNotificationFlagForPushChannel)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationFlagForPushChannel = marketingNotificationFlagForPushChannel;
            return this;
        }

        public Builder setMarketingNotificationFlagForSmsChannel(Type marketingNotificationFlagForSmsChannel) {
            if(UNDEFINED.equals(marketingNotificationFlagForSmsChannel)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationFlagForSmsChannel = marketingNotificationFlagForSmsChannel;
            return this;
        }

        public Builder setMarketingNotificationFlagForKakaoChannel(Type marketingNotificationFlagForKakaoChannel) {
            if(UNDEFINED.equals(marketingNotificationFlagForKakaoChannel)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationFlagForKakaoChannel = marketingNotificationFlagForKakaoChannel;
            return this;
        }

        public Builder setMarketingNotificationAtNightFlag(Type marketingNotificationAtNightFlag) {
            if(UNDEFINED.equals(marketingNotificationAtNightFlag)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationAtNightFlag = marketingNotificationAtNightFlag;
            return this;
        }

        public Builder setMarketingNotificationAtNightFlagForPushChannel(Type marketingNotificationAtNightFlagForPushChannel) {
            if(UNDEFINED.equals(marketingNotificationAtNightFlagForPushChannel)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationAtNightFlagForPushChannel = marketingNotificationAtNightFlagForPushChannel;
            return this;
        }

        public Builder setMarketingNotificationAtNightFlagForSmsChannel(Type marketingNotificationAtNightFlagForSmsChannel) {
            if(UNDEFINED.equals(marketingNotificationAtNightFlagForSmsChannel)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationAtNightFlagForSmsChannel = marketingNotificationAtNightFlagForSmsChannel;
            return this;
        }

        public Builder setMarketingNotificationAtNightFlagForKakaoChannel(Type marketingNotificationAtNightFlagForKakaoChannel) {
            if(UNDEFINED.equals(marketingNotificationAtNightFlagForKakaoChannel)){
                AbxLog.e("invalid format: UNDEFINED is not allowed", false);
                return this;
            }
            this.subscriptionStatus.marketingNotificationAtNightFlagForKakaoChannel = marketingNotificationAtNightFlagForKakaoChannel;
            return this;
        }
        public SubscriptionStatus build(){
            return this.subscriptionStatus;
        }
    }

    public Type getInformativeNotificationFlag() {
        return informativeNotificationFlag;
    }

    public Type getMarketingNotificationFlag() {
        return marketingNotificationFlag;
    }

    public Type getMarketingNotificationFlagForPushChannel() {
        return marketingNotificationFlagForPushChannel;
    }

    public Type getMarketingNotificationFlagForSmsChannel() {
        return marketingNotificationFlagForSmsChannel;
    }

    public Type getMarketingNotificationFlagForKakaoChannel() {
        return marketingNotificationFlagForKakaoChannel;
    }

    public Type getMarketingNotificationAtNightFlag() {
        return marketingNotificationAtNightFlag;
    }

    public Type getMarketingNotificationAtNightFlagForPushChannel() {
        return marketingNotificationAtNightFlagForPushChannel;
    }

    public Type getMarketingNotificationAtNightFlagForSmsChannel() {
        return marketingNotificationAtNightFlagForSmsChannel;
    }

    public Type getMarketingNotificationAtNightFlagForKakaoChannel() {
        return marketingNotificationAtNightFlagForKakaoChannel;
    }

    public String getStringBySubscriptionStatus(Type subscriptionType){
        switch (subscriptionType){
            case SUBSCRIBED: return "Subscribed";
            case UNSUBSCRIBED: return "Unsubscribed";
            default: return "Undefined";
        }
    }
    public boolean isSetAvailableSubscriptionType(Type subscriptionType){
        if(subscriptionType.equals(UNDEFINED)){
            return false;
        } else{
            return true;
        }
    }
}
