package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;

public class SetCiPropertyModel implements IApiModel{
    public static final String REQUEST_APP_KEY = "appkey";
    public static final String REQUEST_USER_ID = "user_id";
    public static final String REQUEST_ADID = "adid";
    public static final String REQUEST_USER_CI_PROPERTIES = "user_ci_properties";

    private final String key;
    private final String value;
    private final DataRegistry dataRegistry;

    public SetCiPropertyModel(String key, String value, DataRegistry dataRegistry) {
        this.key = key;
        this.value = value;
        this.dataRegistry = dataRegistry;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.setCiProfileUrl;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        String appKey = dataRegistry.safeGetString(DataRegistryKey.STRING_APPKEY, null);
        String userId = dataRegistry.safeGetString(DataRegistryKey.STRING_USER_ID, null);
        String adid = dataRegistry.safeGetString(DataRegistryKey.STRING_ADID, null);
        JSONObject requestProperties = new JSONObject();
        requestProperties.put(key, value);
        NullableJSONObject jsonObject = new NullableJSONObject();
        jsonObject.put(REQUEST_APP_KEY, appKey);
        jsonObject.put(REQUEST_USER_ID, userId);
        jsonObject.put(REQUEST_ADID, adid);
        jsonObject.put(REQUEST_USER_CI_PROPERTIES, requestProperties);
        return jsonObject;
    }
}
