package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.CoreConstants;

public class EventBundleModel implements IApiModel {
    private JSONObject common;
    private JSONArray evts;
    private String appKey;

    public EventBundleModel(JSONObject common, JSONArray evts, String appKey) {
        this.common = common;
        this.evts = evts;
        this.appKey = appKey;
    }

    @Override
    public String getUrlString() {
        return String.format(CoreConstants.bulkEventTrackingUrlTemplate, appKey);
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject root = new NullableJSONObject();
        root.put("common", common);
        root.put("evts", evts);

        return root;
    }
}
