package io.adbrix.sdk.domain.model;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.function.Completion;

public final class Error<T> implements Result<T> {
    private final Throwable error;

    private Error(Throwable error) {
        this.error = error;
    }

    public static <T> Error<T> of(Throwable error) {
        return new Error<>(error);
    }

    public static <T> Error<T> of(String errorMessage) {
        return new Error<>(new Exception(errorMessage));
    }

    @Override
    public String toString() {
        return "Error[exception=" + this.error.getMessage() + "]";
    }

    @Override
    public boolean isSucceeded() {
        return false;
    }

    @Override
    public T getOrDefault(T other) {
        return other;
    }

    @Nullable
    @Override
    public T getOrNull() {
        return null;
    }

    @Override
    public Result<T> onSuccess(Completion<T> completion) {
        return this;
    }

    @Override
    public Result<T> onFailure(Completion<Throwable> completion) {
        completion.handle(error);

        return this;
    }

    @Override
    public void onComplete(Runnable action) {
        action.run();
    }
}
