package io.adbrix.sdk.domain.interactor;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.SubscriptionStatus;

public class SetSubscriptionStatusUseCase implements UseCase<Void>{
    private final SubscriptionStatus subscriptionStatus;
    private final AdBrixRm.SetSubscriptionStatusCallback callback;
    private final DataRegistry dataRegistry;
    private final Repository repository;

    public SetSubscriptionStatusUseCase(SubscriptionStatus subscriptionStatus, AdBrixRm.SetSubscriptionStatusCallback callback, DataRegistry dataRegistry, Repository repository) {
        this.subscriptionStatus = subscriptionStatus;
        this.callback = callback;
        this.dataRegistry = dataRegistry;
        this.repository = repository;
    }

    @Override
    public Void execute() {
        repository.setSubscriptionStatus(subscriptionStatus, callback, dataRegistry);
        return null;
    }
}
