package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class FlushAllNowUseCase implements UseCase<Void> {
    private Repository repository;
    private Completion<Result<Empty>> completion;

    public FlushAllNowUseCase(Repository repository) {
        this.repository = repository;
        this.completion = result -> {};
    }

    public FlushAllNowUseCase(Repository repository, Completion<Result<Empty>> completion) {
        this.repository = repository;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.flushAllNow(completion);
        return null;
    }
}
