package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class FetchInAppMessageUseCase implements UseCase<Empty> {
    private final Repository repository;
    private final Completion<Result<Empty>> completion;
    private final boolean isDirectCall;

    public FetchInAppMessageUseCase(boolean isDirectCall, Repository repository, Completion<Result<Empty>> completion) {
        this.isDirectCall = isDirectCall;
        this.repository = repository;
        this.completion = completion;
    }

    @Override
    public Empty execute() {
        repository.fetchInAppMessage(isDirectCall, completion);
        return Empty.INSTANCE;
    }
}
