package io.adbrix.sdk.domain.interactor;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.Result;

public class FetchActionHistoryFromServerUseCase implements UseCase<Void> {
    private final Repository repository;
    @Nullable
    private final String token;
    private final ActionHistoryIdType idType;
    private final List<String> actionType;
    private final Completion<Result<List<ActionHistory>>> completion;

    public FetchActionHistoryFromServerUseCase(
            Repository repository,
            @Nullable String token,
            ActionHistoryIdType idType,
            List<String> actionType,
            Completion<Result<List<ActionHistory>>> completion
    ) {
        this.repository = repository;
        this.token = token;
        this.idType = idType;
        this.actionType = actionType;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.fetchActionHistoryFromServer(token, idType, actionType, completion);
        return null;
    }
}
