package io.adbrix.sdk.domain.interactor;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class DeleteAllActionHistoryUseCase implements UseCase<Void> {
    private final Repository repository;
    @Nullable
    private final String token;
    private final ActionHistoryIdType idType;
    private final Completion<Result<Empty>> completion;

    public DeleteAllActionHistoryUseCase(
            Repository repository,
            @Nullable String token,
            ActionHistoryIdType idType,
            Completion<Result<Empty>> completion
    ) {
        this.repository = repository;
        this.token = token;
        this.idType = idType;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.deleteAllActionHistory(token, idType, completion);
        return null;
    }
}
