package io.adbrix.sdk.domain.interactor;

import javax.annotation.Nullable;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class DeleteActionHistoryUseCase implements UseCase<Void> {
    private final Repository repository;
    @Nullable
    private final String token;
    private final String historyId;
    private final long timestamp;
    private final Completion<Result<Empty>> completion;

    public DeleteActionHistoryUseCase(
            Repository repository,
            @Nullable String token,
            String historyId,
            long timestamp,
            Completion<Result<Empty>> completion
    ) {
        this.repository = repository;
        this.token = token;
        this.historyId = historyId;
        this.timestamp = timestamp;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.deleteActionHistory(token, historyId, timestamp, completion);
        return null;
    }
}
