package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;

public class ClearSyncedActionHistoryInLocalDBUseCase implements UseCase<Void> {
    private final Repository repository;
    private final Completion<Result<Empty>> completion;

    public ClearSyncedActionHistoryInLocalDBUseCase(Repository repository, Completion<Result<Empty>> completion) {
        this.repository = repository;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.clearSyncedActionHistoryInLocalDB(completion);
        return null;
    }
}
