package io.adbrix.sdk.data.repository.datasource;

import android.content.Context;
import android.content.SharedPreferences;

import java.io.File;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.CoreConstants;

public class DefaultDataContext implements IDataContext {
    private Context context;
    private SharedPreferences data;
    private static final String SHARED_PREF_NAME = "shared_prefs:io.adbrix";

    public DefaultDataContext(Context context) {
        this.context = context;
        this.data = this.context.getSharedPreferences(getFileName(), Context.MODE_PRIVATE);
    }

    // Commit Method는 Main thread에서 작동하면 안된다. (Blocking)
    // Apply Method는 Background에서 동작하므로 Non-blocking이지만 그 Operation의 성패 여부를 반환하지 않는다.
    @Override
    public void setValue(String key, String value) {
        data.edit()
                .putString(key, value)
                .apply();
    }

    @Override
    public String getValueOrNull(String key) {
        return data.getString(key, null);
    }

    // key가 있을 시 remove하고 true를 반환한다. key가 없을 시 false를 반환한다.
    public boolean remove(String key) {
        if (data.contains(key)) {
            data.edit()
                    .remove(key)
                    .apply();
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void clear() {
        data.edit()
                .clear()
                .apply();
    }

    private String getFileName() {
        String fileName = SHARED_PREF_NAME;

        String path = context.getApplicationInfo().dataDir + "/shared_prefs/";
        AbxLog.d("SharedPreference Path: " + path, true);

        File directory = new File(path);
        File[] files = directory.listFiles();

        if (files != null && files.length > 0) {
            AbxLog.d("SharedPreference Size: " + files.length, true);

            for (File file : files) {
                if (file.getName().equals("shared_prefs:io.adbrix.xml")) {
                    AbxLog.d("Selected fileName: " + file.getName(), true);
                    return fileName;
                }
            }

            for (File file : files) {
                if (file.getName().contains("shared_prefs:")) {
                    AbxLog.d("FileName: " + file.getName(), true);
                    String tempFileName = file.getName().replace(".xml", "");
                    SharedPreferences tempData = context.getSharedPreferences(tempFileName, Context.MODE_PRIVATE);
                    if (tempData != null) {
                        String archivingJson = tempData.getString(CoreConstants.DATA_REGISTRY_ARCHIVING_KEY, null);
                        if (archivingJson != null) {
                            fileName = tempFileName;
                            AbxLog.d("Selected fileName: " + fileName, true);
                            break;
                        }
                    }
                }
            }
            return fileName;
        }

        return fileName;
    }
}
