package io.adbrix.sdk.data.net;

import org.json.JSONObject;

import java.util.Map;

import io.adbrix.sdk.domain.model.IApiModel;

public interface IApiConnection {
    /**
     * 2023.01.05 bobos
     * 에러코드 참조 @see("https://docs.oracle.com/cd/E25294_01/doc.920/e15484/oltappxa.htm")
     */
    public static final int RESPONSE_CODE_OK = 200;
    public static final int RESPONSE_CODE_DISCONNECTED = 12163;
    public static final int RESPONSE_CODE_CONNECTION_ABORTED = 12030;
    public static final int RESPONSE_CODE_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int RESPONSE_CODE_ERROR = -1;

    int getResponseCode();

    String getResponseString();

    IApiConnection header(Map<String, String> header);

    IApiConnection get(String urlString);

    IApiConnection get(IApiModel apiModel);

    IApiConnection post(IApiModel apiModel);

    IApiConnection delete(IApiModel apiModel);

    String request() throws Exception;

    boolean isHttpOK();

    boolean isWrongAppkey();

    boolean isInvalidAppkey();

    String getUrl();
    JSONObject getBody();
    RequestMethod getRequestMethod();

    public static enum RequestMethod {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE"),
        NONE("");

        private final String methodString;

        RequestMethod(String methodString) {
            this.methodString = methodString;
        }

        public String getMethodString() {
            return methodString;
        }
    }
}
