package io.adbrix.sdk.data.modelprovider;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.GetSubscriptionStatusModel;
import io.adbrix.sdk.domain.model.SetSubscriptionStatusModel;
import io.adbrix.sdk.domain.model.SubscriptionStatus;

public class SetSubscriptionStatusModelProvider implements IApiModelProvider<SetSubscriptionStatusModel> {
    private SubscriptionStatus subscriptionStatus;
    private DataRegistry dataRegistry;

    public SetSubscriptionStatusModelProvider(SubscriptionStatus subscriptionStatus, DataRegistry dataRegistry) {
        this.subscriptionStatus = subscriptionStatus;
        this.dataRegistry = dataRegistry;
    }

    @Override
    public SetSubscriptionStatusModel provide() {
        return new SetSubscriptionStatusModel(this.subscriptionStatus, this.dataRegistry);
    }
}
