package io.adbrix.sdk.data.modelprovider;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;
import java.util.Iterator;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.domain.model.CommonModel;
import io.adbrix.sdk.domain.model.EventBundleModel;
import io.adbrix.sdk.domain.model.EventModel;
import io.adbrix.sdk.domain.model.EventPackage;

public class EventBundleModelProvider implements IApiModelProvider<EventBundleModel> {
    private CommonModel commonModel;
    private EventPackage eventPackage;

    public EventBundleModelProvider(CommonModel commonModel, EventPackage eventPackage) {
        this.commonModel = commonModel;
        this.eventPackage = eventPackage;
    }

    @Override
    public EventBundleModel provide() {
        Iterator<EventModel> iterator = eventPackage.eventModels.iterator();
        JSONArray evts = new JSONArray();
        while (iterator.hasNext()) {
            EventModel eventModel = iterator.next();
            try {
                if (eventModel != null) {
                    evts.put(eventModel.getJson());
                }
            } catch (JSONException e) {
                AbxLog.e(e, true);
            }
        }

        JSONObject common = null;
        try {
            common = commonModel.getJson();
        } catch (JSONException e) {
            AbxLog.e(e, true);
        }

        return new EventBundleModel(common, evts, commonModel.appkey);
    }
}
