package io.adbrix.sdk.data.entity;

public enum DataType {
    /**
     * enum 값을 추가해야할 상황이 생긴다면 기존값은 건들지 말고 신규로 추가하자.
     */
    STRING(1),
    INT(2),
    BOOLEAN(3),
    FLOAT(4),
    LONG(5),
    DOUBLE(6);

    //region enum을 쉽게 파싱하기 위한 생성자 코드
    private final int id;

    DataType(int id) {
        this.id = id;
    }

    public static DataType parseEnum(int id) {
        DataType[] as = DataType.values();
        for (int i = 0; i < as.length; i++) {
            if (as[i].compare(id))
                return as[i];
        }
        return DataType.STRING; //문자열을 디폴트값으로 하자.
    }

    public int getId() {
        return this.id;
    }

    public boolean compare(int i) {
        return id == i;
    }
    //endregion
}
