package io.adbrix.sdk.data;

import androidx.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class NullableJSONObject extends JSONObject {
    public NullableJSONObject() {
        super();
    }

    public NullableJSONObject(String json) throws JSONException {
        super(json);
    }

    @Override
    public JSONObject put(String name, Object value) throws JSONException {
        value = CoreUtils.convertNullableToJSONNullable(value);
        return super.put(name, value);
    }

    @Override
    public String optString(String name) {
        String value = super.optString(name);
        if("null".equals(value)){
            return "";
        }
        return value;
    }

    @Override
    public String getString(String name) throws JSONException {
        String value = super.getString(name);
        if(CommonUtils.isNull(value)){
            return value;
        }
        if("null".equals(value)){
            return null;
        }
        return value;
    }

    @Nullable
    @Override
    public JSONObject optJSONObject(@Nullable String name) {
        JSONObject value = super.optJSONObject(name);
        if(value == null){
            value = new JSONObject();
        }
        return value;
    }
}
