package io.adbrix.sdk.configuration;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;

import com.google.firebase.messaging.RemoteMessage;
import com.igaworks.v2.core.AdBrixRm;
import com.igaworks.v2.core.result.CiPropertyResult;
import com.igaworks.v2.core.result.GetSubscriptionStatusResult;
import com.igaworks.v2.core.result.SetCiProfileResult;
import com.igaworks.v2.core.result.SetSubscriptionStatusResult;
import com.igaworks.v2.core.result.SubscriptionStatusResult;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.DeeplinkPostingObservable;
import io.adbrix.sdk.component.DefaultComponentsFactory;
import io.adbrix.sdk.component.DeferredDeeplinkPostingObservable;
import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.InAppMessageAutoFetchObservable;
import io.adbrix.sdk.component.InAppMessageClickPostingObservable;
import io.adbrix.sdk.component.OsPushEnableObservable;
import io.adbrix.sdk.data.SdkVersion;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.net.IApiConnection;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.exception.BeforeInitializeException;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.DeferredDeeplinkObserverModel;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.DfnInAppMessageFetchMode;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.domain.model.SelfServeInAppMessage;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.Response;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.SubscriptionStatus;
import io.adbrix.sdk.domain.model.UserPropertyCommand;
import io.adbrix.sdk.domain.model.UserPropertyModel;
import io.adbrix.sdk.ui.inappmessage.InAppMessageManager;
import io.adbrix.sdk.ui.push.components.AbxPushCommonDAO;
import io.adbrix.sdk.ui.push.components.PushController;
import io.adbrix.sdk.ui.push.models.PushEvent;
import io.adbrix.sdk.ui.push.utils.AbxPushReceiverUtil;
import io.adbrix.sdk.ui.push.utils.PushLocalBridgeUtil;
import io.adbrix.sdk.ui.push.utils.PushUtils;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

//TODO 이건 있을 이유가 없는 클래스인듯.. Controller 기능과 겹친다..
public class AbxFacade {
    private Context context;

    private static final String ADBRIXRM_CLASS_NAME = "com.igaworks.v2.core.AdBrixRm";
    private static final String ABX_PUSH_COMMON_DAO_CLASS_NAME = "com.igaworks.v2.core.push.notification.AbxPushCommonDAO";
    private static final String ABX_POP_UP_COMMON_DAO_CLASS_NAME = "com.igaworks.v2.core.push.popup.AbxPopUpCommonDAO";
    private static final String PUSH_CONTROLLER_CLASS_NAME = "com.igaworks.v2.core.push.PushController";
    private IABXContextController abxController = new DefaultABXContextController();
    private IABXComponentsFactory componentsFactory = null;
    private PushController pushController = null;
    private AbxPushCommonDAO abxPushCommonDAO = null;
    private long onResumeInvokeTimestamp;
    private long onPauseInvokeTimestamp;

    public AbxFacade(Context appContext, String appKey, String secretKey,IABXComponentsFactory customComponentFactory, boolean enableAdIdTracking) throws IABXComponentsFactory.ComponentsCanNotCreateException {
        this.context = appContext;
        setServerMode(appContext);
        if(customComponentFactory == null)
            this.componentsFactory = new DefaultComponentsFactory();
        else
            this.componentsFactory = customComponentFactory;
        this.componentsFactory.init(appContext,this, this.abxController);
        this.componentsFactory.createOrGetDataRegistry().putDataRegistry(
                new DataUnit(
                        DataRegistryKey.BOOLEAN_ENABLE_ADID_TRACKING,
                        enableAdIdTracking,
                        5,
                        this.getClass().getName(),
                        false
                )
        );

        startController(this.componentsFactory);
        this.pushController = PushController.getInstance();
        this.abxPushCommonDAO = new AbxPushCommonDAO(this, componentsFactory.createOrGetPushEventStore());
        this.pushController.init(this);
        abxController.initialize(appContext, appKey, secretKey);
    }

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private void startController(IABXComponentsFactory componentsFactory) {
        abxController.startController(componentsFactory);
    }

    public void stopController() {
        abxController.stopController();
    }

    public String getAppKey(){
        String result = "";
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry().safeGetString(DataRegistryKey.STRING_APPKEY, null);
        } catch (Exception e) {
            AbxLog.w("getDataRegistry is called before controller.startcontroller.",e, true);
        }
        return result;
    }

    public void gdprForgetMe() {
        abxController.gdprForgetMe();
    }

    public void postAbxEvent(String eventName) {
        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                eventName,
                null,
                0,
                0
        );
        abxController.logEvent(eventParameter);
    }

    public void postAbxEvent(String eventName, JSONObject eventParam) {
        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                eventName,
                CommonUtils.getMapFromJSONObject(eventParam),
                0,
                0
        );
        abxController.logEvent(eventParameter);
    }

    public void postSameAbxEvent(String eventName, String group, List<JSONObject> eventParamList) {
        abxController.logSameEventWithPaging(eventName, group, eventParamList);
    }

    public void flushAllEvents(Completion<Result<Empty>> completion) {
        abxController.flushAllEvents(completion);
    }

    public void saveUserProperty(JSONObject userPropertiesJson) {
        /*if(userPropertiesJson.has("user_id")){
            String userId = userPropertiesJson.optString("user_id");
            getDataRegistry().putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_USER_ID,
                    userId,
                    5,
                    ADBRIXRM_CLASS_NAME,
                    true
            ));
        }*/
        abxController.saveUserProperty(makeUserPropertyCommand(userPropertiesJson));
    }

    public void saveUserPropertyWithoutEvent(JSONObject userPropertiesJson) {
        abxController.saveUserPropertyWithoutEvent(makeUserPropertyCommand(userPropertiesJson));
    }

    public void clearUserProperties() {
        abxController.clearUserProperty();
    }

    public void saveCi(JSONObject ciPropertiesJson) {
        abxController.saveUserProperty(makeCiCommand(ciPropertiesJson));
    }

    public void setCiProperty(String key, String value, AdBrixRm.SetCiProfileCallback callback){
        if(CommonUtils.isNullOrEmpty(value)){
            AbxLog.e("setCiProperty() value is null or empty", false);
            if(!CommonUtils.isNull(callback)){
                callback.onCallback(new SetCiProfileResult(IApiConnection.RESPONSE_CODE_ERROR, CiPropertyResult.RESULT_CODE_PROPERTY_REQUIRED));
            }
            return;
        }
        String userId = this.getUserId();
        if(CommonUtils.isNullOrEmpty(userId)){
            AbxLog.e("setCiProperty() userId is null or empty", false);
            if(!CommonUtils.isNull(callback)){
                callback.onCallback(new SetCiProfileResult(IApiConnection.RESPONSE_CODE_ERROR, CiPropertyResult.RESULT_CODE_USER_ID_REQUIRED));
            }
            return;
        }
        abxController.setCiProperty(key, value, callback);
    }

    private UserPropertyCommand makeUserPropertyCommand(JSONObject userPropertiesJson) {
        UserPropertyCommand command = new UserPropertyCommand();
        UserPropertyModel userPropertyModel = getCurrentUserPropertyModel();

        JSONObject truncatedUserPropertiesJson = CommonUtils.truncate(userPropertiesJson, this.getPropertyMaxSize());
        JSONObject parsedUserPropertiesJson = CommonUtils
                .parseValueWithDataType(truncatedUserPropertiesJson, CommonUtils.FixType.PREFIX);

        Iterator<?> keys = parsedUserPropertiesJson.keys();
        int currentSizeOfUserPropertyModel = userPropertyModel.properties.size();

        while (keys.hasNext()) {
            String key = (String) keys.next();

            try {
                if (currentSizeOfUserPropertyModel < this.componentsFactory.createOrGetRemoteConfigProvider().getConfigPropertyMaxSize()) {
                    command.set(key, parsedUserPropertiesJson.get(key));
                    currentSizeOfUserPropertyModel++;
                } else {
                    AbxLog.d("UserProperties reaches MAX_PROPERTY_KEYS: "
                            + this.componentsFactory.createOrGetRemoteConfigProvider().getConfigPropertyMaxSize(), true);
                    break;
                }
            } catch (JSONException e) {
                AbxLog.e("updateLocalUserProperties Error: ", e, true);
            }
        }

        return command;
    }

    private UserPropertyCommand makeCiCommand(JSONObject ciPropertiesJson) {
        UserPropertyCommand command = new UserPropertyCommand();
        UserPropertyModel userPropertyModel = getCurrentUserPropertyModel();

        JSONObject truncatedUserCiJson = CommonUtils.truncate(ciPropertiesJson,this.getPropertyMaxSize());
        JSONObject parsedUserPropertiesJson = CommonUtils
                .parseValueWithDataType(truncatedUserCiJson, CommonUtils.FixType.PREFIX);

        Iterator<?> keys = parsedUserPropertiesJson.keys();
        int currentSizeOfUserPropertyModel = userPropertyModel.properties.size();

        while (keys.hasNext()) {
            String key = (String) keys.next();

            try {
                if (currentSizeOfUserPropertyModel < this.componentsFactory.createOrGetRemoteConfigProvider().getConfigPropertyMaxSize()) {
                    command.set(CoreConstants.CI_KEY + key, parsedUserPropertiesJson.get(key));
                    currentSizeOfUserPropertyModel++;
                } else {
                    AbxLog.d("UserProperties reaches MAX_PROPERTY_KEYS: "
                            + this.componentsFactory.createOrGetRemoteConfigProvider().getConfigPropertyMaxSize(), true);
                    break;
                }
            } catch (JSONException e) {
                AbxLog.e("updateLocalUserProperties Error: ", e, true);
            }
        }

        return command;
    }

    public UserPropertyModel getCurrentUserPropertyModel() {
        return abxController.getCurrentUserPropertyModel();
    }

    public void onPause() {
        onPause(null);
    }

    public void onPause(Activity activity) {
        if(activity!=null){
            setContext(activity.getApplicationContext());
        }
        if(isDuplicateCall(onPauseInvokeTimestamp)){
            AbxLog.w("duplicate call prevented: onPause", true);
            return;
        }
        onPauseInvokeTimestamp = System.currentTimeMillis();
        InAppMessageManager.getInstance().close(IAMEnums.CloseType.ON_PAUSE);
        InAppMessageManager.getInstance().setCurrentActivity(null);
        abxController.onPause(activity);
    }

    public void onDestroy(Activity activity) {
        setContext(activity.getApplicationContext());
        abxController.onDestroy(activity);
    }

    public void onResume(Activity activity) {
        setContext(activity.getApplicationContext());
        if(isDuplicateCall(onResumeInvokeTimestamp)){
            AbxLog.w("duplicate call prevented: onResume", true);
            return;
        }
        onResumeInvokeTimestamp = System.currentTimeMillis();
        InAppMessageManager.getInstance().setCurrentActivity(activity);
        DfnInAppMessage inAppMessage = InAppMessageManager.getInstance().getCarriedInAppMessage();
        if(CommonUtils.notNull(inAppMessage)){
            InAppMessageManager.getInstance().show(inAppMessage, null, true);
            InAppMessageManager.getInstance().flushCarriedInAppMessage();
        }
        abxController.onResume(activity);
    }

    public void onMessageReceived(Context context, RemoteMessage remoteMessage){
        setContext(context);
        abxController.onMessageReceived(context, remoteMessage);
    }

    public void deeplink(Activity deeplinkActivity) {
        setContext(deeplinkActivity.getApplicationContext());
        if (!isFirstOpenTriggered()) {
            abxController.deeplink(deeplinkActivity);
        }
    }

    public void deeplinkWithIntent(Intent deeplinkIntent) {
        if (!isFirstOpenTriggered()) {
            abxController.deeplinkWithIntent(deeplinkIntent);
        }
    }

    public boolean isFirstOpenTriggered() {
       boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }

        try {
            result = abxController.getDataRegistry().safeGetString(DataRegistryKey.STRING_LAST_FIRSTOPEN_ID, null) == null;
        } catch (Exception e) {
            AbxLog.w("getDataRegistry is called before controller.startcontroller.",e, true);
        }
        return result;
    }

    public void setEnableLocationListening(Boolean isEnable) {
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.BOOLEAN_LOCATION_PERMISSION_GRANTED,
                isEnable,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
    }

    public void setLocation(double latitude, double longitude) {

        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_LOCATION_LWID,
                UUID.randomUUID().toString(),
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));

        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.DOUBLE_LOCATION_LAT,
                latitude,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));

        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.DOUBLE_LOCATION_LNG,
                longitude,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
    }

    public void login(String userId, Completion<Result<Response>> completion){
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_USER_ID,
                userId,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
        abxController.login(userId, completion);
    }

    public void logout(Completion<Result<Response>> completion){
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_USER_ID,
                null,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
        abxController.logout(completion);
    }

    public void event(String eventName) {
        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_CUSTOM,
                eventName,
                null,
                0,
                0
        );
        abxController.logEvent(eventParameter);
    }

    public void event(String eventName, JSONObject eventParam) {
        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_CUSTOM,
                eventName,
                CommonUtils.getMapFromJSONObject(eventParam),
                0,
                0
        );
        abxController.logEvent(eventParameter);
    }

    public void setCountInterval(int countInterval) {
        componentsFactory.getEventUploadIntervalManager().setCountInterval(countInterval);
        AbxLog.v("set EventUploadCountInterval : " + countInterval, true);
    }

    public void setTimeInterval(int timeInterval) {
        componentsFactory.getEventUploadIntervalManager().setTimeInterval(timeInterval);
        AbxLog.v("set EventUploadTimeInterval : " + timeInterval, true);
    }

    public void setAppScanEnable(boolean enable) {
        AbxLog.d("AbxApplicationScan:: DEPRECATED!!!", true);
//        if (enable){
//            controller.putDataRegistry(new DataUnit(
//                    DataRegistryKey.LONG_APP_SCAN_ON_OFF_USER,
//                    1L,
//                    5,
//                    ADBRIXRM_CLASS_NAME,
//                    true
//            ));
//            Log.d(ABXConstants.LOGTAG, "Application Scanning set to true ( CLIENT )");
//        }
//        else {
//            controller.putDataRegistry(new DataUnit(
//                    DataRegistryKey.LONG_APP_SCAN_ON_OFF_USER,
//                    0L,
//                    5,
//                    ADBRIXRM_CLASS_NAME,
//                    true
//            ));
//            Log.d(ABXConstants.LOGTAG, "Application Scanning set to false ( CLIENT )");
//        }
    }

    //PUSH 관련 기능

    public PushController getPushController() throws BeforeInitializeException {
        //if(this.pushController == null || !this.pushController.isPushControllerInitialized)
        if (this.pushController == null)
            throw new BeforeInitializeException();
        else
            return this.pushController;
    }

    public boolean isPushAvailable(){
        boolean result = false;
        if (isAdbrixDisabled()) {
            AbxLog.w("Push service is not available : due to SDK status (pause / stop / gdpr)", true);
            return result;
        }
        if(isDoNotDisturb()){
            AbxLog.w("it's DoNotDisturb time. push won't be shown.", true);
            return result;
        }
        result = true;
        return result;
    }

    public void processPushOpen(Intent intent){
        AbxPushReceiverUtil.callbackPushOpen(getContext(), intent);
    }

    public void showNotification(Context context, Intent intent){
        setContext(context);
        /**
         * 2023.01.02 bobos
         * 이미지 다운로드 다운로드 동작 때문에 Executor에 넣어야함
         */
        runInBackGroundWithoutOrder(new Runnable() {
            @Override
            public void run() {
                AbxPushReceiverUtil.showNotification(context, intent, abxPushCommonDAO);
            }
        });
    }

    public boolean isDoNotDisturb(){
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        boolean isDoNotDisturbEnabled = abxController.getDataRegistry()
                .safeGetBoolean(DataRegistryKey.BOOLEAN_IS_DO_NOT_DISTURB_ENABLE, false);
        if(!isDoNotDisturbEnabled){
            return result;
        }
        String doNotDisturbTime = abxController.getDataRegistry()
                .safeGetString(DataRegistryKey.STRING_DO_NOT_DISTURB_TIME_RANGE, null);
        if(CommonUtils.isNullOrEmpty(doNotDisturbTime)){
            return result;
        }
        try {
            int fromHour = Integer.parseInt(doNotDisturbTime.substring(0, 2));
            int fromMinute = Integer.parseInt(doNotDisturbTime.substring(2, 4));
            Date fromDate = new Date();
            fromDate.setHours(fromHour);
            fromDate.setMinutes(fromMinute);
            int toHour = Integer.parseInt(doNotDisturbTime.substring(4, 6));
            int toMinute = Integer.parseInt(doNotDisturbTime.substring(6, 8));
            Date toDate = new Date();
            toDate.setHours(toHour);
            toDate.setMinutes(toMinute);
            Date currentDate = new Date();
            result = isDoNotDisturb(currentDate, fromDate, toDate);
            return result;
        }
        catch (Exception e) {
            AbxLog.w(e, true);
            return result;
        }
    }

    public boolean isDoNotDisturb(Date currentDate, Date fromDate, Date toDate){
        boolean result = false;
        if(toDate.before(fromDate)) {
            toDate.setDate(toDate.getDate()+1);
        }
        if(currentDate.before(fromDate) && toDate.getDate() >= fromDate.getDate()+1) {
            currentDate.setDate(currentDate.getDate()+1);
        }
        if(currentDate.after(fromDate) && currentDate.before(toDate)) {
            result = true;
        }
        return result;
    }

    public boolean getPushEnable() {
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetBoolean(DataRegistryKey.BOOLEAN_IS_PUSH_ENABLE, false);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public boolean getOsPushEnable() {
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetBoolean(DataRegistryKey.BOOLEAN_IS_PUSH_ENABLE_OS, false);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public void updatePushEnable(boolean userPushEnable) {
        boolean pushEnable = getPushEnable();
        if(pushEnable == userPushEnable){
            return;
        }
        try {
            getDataRegistry().putDataRegistry(new DataUnit(
                    DataRegistryKey.BOOLEAN_IS_PUSH_ENABLE,
                    userPushEnable,
                    5,
                    PUSH_CONTROLLER_CLASS_NAME,
                    true
            ));
        }catch (Exception e){
            AbxLog.w("getDataRegistry is called before controller.startcontroller", e, true);
            return;
        }

        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                CoreConstants.EVENT_SET_PUSH,
                null,
                0,
                0
        );

        abxController.logEvent(eventParameter);
    }

    public void updateOsPushEnable(boolean userOsPushEnable) {
        boolean osPushEnable = getOsPushEnable();
        if(osPushEnable == userOsPushEnable){
            return;
        }
        try {
            getDataRegistry().putDataRegistry(new DataUnit(
                    DataRegistryKey.BOOLEAN_IS_PUSH_ENABLE_OS,
                    userOsPushEnable,
                    5,
                    PUSH_CONTROLLER_CLASS_NAME,
                    true
            ));
        } catch (Exception e) {
            AbxLog.w("getDataRegistry is called before controller.startcontroller", e, true);
            return;
        }

        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                CoreConstants.EVENT_SET_PUSH,
                null,
                0,
                0
        );

        abxController.logEvent(eventParameter);
        AbxLog.d("CoreWrapper.updateOsPushEnable is called", true);
    }

    public String getRegistrationID() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_REGISTRATION_ID, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public void setRegistrationID(String userRegistrationId) {
        if (isAdbrixDisabled()) return;
        if(CommonUtils.isNullOrEmpty(userRegistrationId)){
            AbxLog.w("RegistrationId is null", true);
            return;
        }
        String registrationId = getRegistrationID();
        if(!CommonUtils.isNullOrEmpty(registrationId)){
            if(registrationId.equals(userRegistrationId)){
                return;
            }
        }
        try {
            getDataRegistry().putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_REGISTRATION_ID,
                    userRegistrationId,
                    5,
                    PUSH_CONTROLLER_CLASS_NAME,
                    true
            ));
        }catch (Exception e){
            AbxLog.w("getDataRegistry is called before controller.startcontroller", e, true);
            return;
        }

        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                CoreConstants.EVENT_SET_PUSH,
                null,
                0,
                0
        );

        abxController.logEvent(eventParameter);
    }

    public boolean checkDuplicatedNotification(int notificationId) {
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        JSONArray storedIds = new JSONArray();
        String ids = "";
        try {
            ids = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_ABX_NOTIFICATION_ID, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        if (CommonUtils.isNullOrEmpty(ids)){
            saveNotificationIdToDataRegistry(new JSONArray(), notificationId);
            return result;
        }

        try {
            storedIds = new JSONArray(ids);
            for (int i = 0; i < storedIds.length(); i++) {
                int id = storedIds.getInt(i);
                if (id != 0 && id == notificationId) {
                    AbxLog.w("duplicate notification: "+notificationId, true);
                    result = true;
                }
            }
        } catch (JSONException e) {
            AbxLog.w("Invalid json array", e, true);
            return result;
        }
        saveNotificationIdToDataRegistry(storedIds, notificationId);
        return result;
    }

    private void saveNotificationIdToDataRegistry(JSONArray storedIds, int notificationId){
        storedIds.put(notificationId);
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_ABX_NOTIFICATION_ID,
                storedIds.toString(),
                5,
                PUSH_CONTROLLER_CLASS_NAME,
                true
        ));
    }


    public void setRemotePushMessageListener(AdBrixRm.onTouchRemotePushListener remotePushMessageListener) {
        getPushController().setRemotePushMessageListener(remotePushMessageListener::onTouchRemotePush);
    }

    public void setLocalPushMessageListener(AdBrixRm.onTouchLocalPushListener localPushMessageListener) {
        getPushController().setLocalPushMessageListener(localPushMessageListener::onTouchLocalPush);
    }

    public void setNotificationDoNotDisturbEnable(Boolean enable){
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.BOOLEAN_IS_DO_NOT_DISTURB_ENABLE,
                enable,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
    }

    public void setNotificationDoNotDisturb(String doNotDisturbStartTimeRange, String doNotDisturbEndTimeRange){
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(doNotDisturbStartTimeRange);
        stringBuilder.append(doNotDisturbEndTimeRange);
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_DO_NOT_DISTURB_TIME_RANGE,
                stringBuilder.toString(),
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
    }

    public void setPushEnable(boolean enable) {
        if (isAdbrixDisabled()) return;
        updatePushEnable(enable);
    }

    public void notifyLocalPushNotification(String title, String body, String deeplink, String imageUrl){
        if (isAdbrixDisabled()) return;
        if(CommonUtils.isNull(this.context)){
            AbxLog.e("context is null", false);
            return;
        }
        boolean isBigTextStyle = false;
        if(CommonUtils.isNullOrEmpty(imageUrl)){
            isBigTextStyle =true;
        }
        int eventId = (int) (System.currentTimeMillis() % Integer.MAX_VALUE);
        if(isBigTextStyle){
            AdBrixRm.BigTextPushProperties bigTextPushProperties = new AdBrixRm.BigTextPushProperties()
                .setTitle(title)
                .setContentText(body)
                .setBigText(title)
                .setBigText(body)
                .setDeepLinkUri(deeplink)
                .setSecond(0)
                .setEventId(eventId);
            setBigTextClientPushEvent(this.context, bigTextPushProperties, true);
            return;
        }
        AdBrixRm.BigPicturePushProperties bigPicturePushProperties = new AdBrixRm.BigPicturePushProperties()
                .setTitle(title)
                .setContentText(body)
                .setBigContentTitle(title)
                .setSummaryText(body)
                .setDeepLinkUri(deeplink)
                .setBigPictureUrl(imageUrl)
                .setSecond(0)
                .setEventId(eventId);
        setBigPictureClientPushEvent(this.context, bigPicturePushProperties, true);
    }

    public void setBigTextClientPushEvent(Context ctx, AdBrixRm.BigTextPushProperties bigTextPushProperties, boolean alwaysIsShown) {
        if (isAdbrixDisabled()) return;
        if (bigTextPushProperties == null) {
            AbxLog.d("bigTextPushProperties are null!", false);
            return;
        }
        PushLocalBridgeUtil.setBigTextClientPushEvent(ctx, bigTextPushProperties, alwaysIsShown, abxPushCommonDAO);
    }

    public void setBigPictureClientPushEvent(Context ctx, AdBrixRm.BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        if (isAdbrixDisabled()) return;

        if (bigPicturePushProperties == null) {
            AbxLog.d("bigPicturePushProperties are null!", false);
            return;
        }
        PushLocalBridgeUtil.setBigPictureClientPushEvent(ctx, bigPicturePushProperties, alwaysIsShown, abxPushCommonDAO);
    }

    public void cancelClientPushEvent(Context ctx, int eventId) {
        if (isAdbrixDisabled()) return;
        PushLocalBridgeUtil.cancelClientPushEvent(ctx, eventId,abxPushCommonDAO);
    }

    public void cancelClientPushEvent(Context ctx, int[] eventId) {
        if (isAdbrixDisabled()) return;
        for(int i=0; i<eventId.length; i++){
            PushLocalBridgeUtil.cancelClientPushEvent(ctx, eventId[i] ,abxPushCommonDAO);
        }
    }

    public void cancelClientPushEventAll(Context ctx) {
        if (isAdbrixDisabled()) return;
        List<PushEvent> list = getRegisteredLocalPushNotification();
        for(PushEvent index: list){
            cancelClientPushEvent(ctx, index.getEventId());
        }
    }

    public JSONArray getPushEventList() {
        try {
            if (isAdbrixDisabled()) return new JSONArray();

            return this.componentsFactory.createOrGetPushCommonDAO().getPushEventList();
        }catch (Exception e)
        {
            AbxLog.e(e, true);
            return new JSONArray();
        }
    }

    public List<PushEvent> getRegisteredLocalPushNotification(){
        List<PushEvent> list = new ArrayList<>();
        JSONArray array = getPushEventList();
        for(int i=0; i<array.length(); i++){
            try {
                JSONObject object = array.getJSONObject(i);
                int eventId = object.getInt("eventId");
                long notificationTime = object.getLong("notification_time");
                PushEvent pushEvent = new PushEvent(eventId, notificationTime);
                list.add(pushEvent);
            } catch (JSONException e) {
                continue;
            }
        }
        return list;
    }

    public void setPushIconStyle(Context context, String smallIconName, String largeIconName, int argb) {
        try {
            if (isAdbrixDisabled()) return;
            this.componentsFactory.createOrGetPushCommonDAO().setPushIconStyle(smallIconName, largeIconName, argb);
        }catch (Exception e)
        {
            AbxLog.e(e, true);
        }
    }

    public void setPushIconStyle(Context context, String smallIconName, String largeIconName, AdBrixRm.PushColor color) {
        try {
            int rgb = -1;
            switch (color) {
                case RED:
                    rgb = Color.rgb(255, 0, 0);
                    break;
                case BLACK:
                    rgb = Color.rgb(0, 0, 0);
                    break;
                case BLUE:
                    rgb = Color.rgb(0, 0, 255);
                    break;
                case WHITE:
                    rgb = Color.rgb(255, 255, 255);
                    break;
                case GREEN:
                    rgb = Color.rgb(0, 255, 0);
                    break;
                case YELLOW:
                    rgb = Color.rgb(255, 255, 0);
                    break;
                default:
            }
            this.componentsFactory.createOrGetPushCommonDAO().setPushIconStyle(smallIconName, largeIconName, rgb);
        }catch (Exception e){
            AbxLog.e(e, true);
        }
    }

    public void setPushIconStyle(Context context, String smallIconName, String largeIconname) {
        setPushIconStyle(context, smallIconName, largeIconname, -1);
    }

    /**
     * For under the oreo.
     *
     * @param context
     * @param priority   See e.g. {@link android.app.Notification#PRIORITY_DEFAULT}
     * @param visibility See e.g. {@link android.app.Notification#VISIBILITY_PUBLIC}
     */
    public void setNotificationOption(Context context, int priority, int visibility) {
        try {
            if (isAdbrixDisabled()) return;
            this.componentsFactory.createOrGetPushCommonDAO().setNotificationOption(priority, visibility);
        }catch (Exception e){
            AbxLog.e(e, true);
        }
    }

    /**
     * To use notification channel, use this API.<br>
     * You must call {@code AdBrixRm.setPushEnable(true)} before use this API.<br>
     * You can change channelName and channelDescription whenever you want.<br>
     * But you cannot change channel importance and vibration once you create channel.
     *
     * @param channelName
     * @param channelDescription
     * @param importance         See e.g. {@link android.app.NotificationManager#IMPORTANCE_DEFAULT}
     * @param vibrateEnable      You can enable or disable vibration
     *                           when you have channel with an {@code importance} of at
     *                           least {@link android.app.NotificationManager#IMPORTANCE_DEFAULT}
     */
    public void setNotificationChannel(Context context, String channelName, String channelDescription, int importance, boolean vibrateEnable) {
        PushUtils.createNotificationChannel(context, channelName, channelDescription, importance, vibrateEnable);
    }

    public void setPushIconStyle(String smallIconName, String largeIconName, int argb) {
        try {
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.STRING_PUSH_DB_SMALL_ICON_NAME,
                            smallIconName,
                            5,
                            ABX_PUSH_COMMON_DAO_CLASS_NAME,
                            true
                    ));
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.STRING_PUSH_DB_LARGE_ICON_NAME,
                            largeIconName,
                            5,
                            ABX_PUSH_COMMON_DAO_CLASS_NAME,
                            true
                    ));
            if (argb != -1) {
                getDataRegistry().putDataRegistry(
                        new DataUnit(
                                DataRegistryKey.LONG_PUSH_DB_ARGB,
                                (long) argb,
                                5,
                                ABX_PUSH_COMMON_DAO_CLASS_NAME,
                                true
                        ));
            }
        } catch (Exception e) {
            AbxLog.d("ERROR :: can't set push properties", true);
        }
    }

    public void setNotificationOption(int priority, int visibility) {
        try {
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.LONG_PUSH_DB_PRIORITY,
                            (long) priority,
                            5,
                            ABX_PUSH_COMMON_DAO_CLASS_NAME,
                            true
                    ));
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.LONG_PUSH_DB_VISIBILITY,
                            (long) visibility,
                            5,
                            ABX_PUSH_COMMON_DAO_CLASS_NAME,
                            true
                    ));
        } catch (Exception e) {
            AbxLog.d("ERROR :: can't set push properties", true);
        }
    }

    public void createDefaultNotificationChannel(String name, String description){
        PushUtils.createNotificationChannel(context, name, description, NotificationManager.IMPORTANCE_HIGH, true);
    }

    public String getSmallIconName() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_SMALL_ICON_NAME, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
            return result;
        }

        if(result == null){
            AbxLog.d("ERROR :: can't get small_icon_value", true);
            return result;
        }

        return result;
    }

    public String getLargeiconName() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_LARGE_ICON_NAME, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        if(result == null){
            AbxLog.d("ERROR :: can't get large_icon_value", true);
        }
        return result;
    }

    public int getARGB() {
        int result = -1;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = (int) abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_PUSH_DB_ARGB, -1);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public int getPriority() {
        int result = 0;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }

        try {
            result = (int) abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_PUSH_DB_PRIORITY, 0);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public int getVisibility() {
        int result = 0;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }

        try {
            result = (int) abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_PUSH_DB_VISIBILITY, 0);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public int getImportance() {
        int result = 0;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = (int) abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_PUSH_DB_IMPORTANCE, 0);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public void setStackingNotificationOption(boolean useStacking, boolean useTitleForStacking,
                                                     String contentTitle, String contentText, String bigContentTitle,
                                                     String bigContentSummaryText) {
        try {
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.LONG_PUSH_DB_USE_STACKING,
                            (long) (useStacking ? 1 : 0),
                            5,
                            ABX_PUSH_COMMON_DAO_CLASS_NAME,
                            true
                    ));
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.LONG_PUSH_DB_USE_TITLE_FOR_STACKING,
                            (long) (useTitleForStacking ? 1 : 0),
                            5,
                            ABX_PUSH_COMMON_DAO_CLASS_NAME,
                            true
                    ));
        } catch (Exception e) {
            AbxLog.d("ERROR :: can't set stacking option properties", true);
        }
    }

    public boolean getUseStacking() {
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry().safeGetLong(DataRegistryKey.LONG_PUSH_DB_USE_STACKING, 0) == 1;
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public boolean getUseTitleforStacking() {
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry().safeGetLong(DataRegistryKey.LONG_PUSH_DB_USE_TITLE_FOR_STACKING, 0) == 1;
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public String getStackingContentTitle() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_STACKING_CONTENT_TITLE, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public String getStackingContentText() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_STACKING_CONTENT_TEXT, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public String getStackingBigContentTitle() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_STACKING_CONTENT_TEXT, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public String getStackingBigContentSummaryText() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_STACKING_BIG_CONTENT_SUMMARY_TEXT, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }

        return result;
    }

    public void setNotificationChannel(String channelName, String channelDescription,
                                              int importance, boolean vibrateEnable) {
        long tempBoolean;

        getDataRegistry().putDataRegistry(
                new DataUnit(
                        DataRegistryKey.STRING_PUSH_DB_NOTIFICATION_CHANNEL_NAME,
                        channelName,
                        5,
                        ABX_PUSH_COMMON_DAO_CLASS_NAME,
                        true
                ));
        getDataRegistry().putDataRegistry(
                new DataUnit(
                        DataRegistryKey.STRING_PUSH_DB_NOTIFICATION_CHANNEL_DESCRIPTION,
                        channelDescription,
                        5,
                        ABX_PUSH_COMMON_DAO_CLASS_NAME,
                        true
                ));

        getDataRegistry().putDataRegistry(
                new DataUnit(
                        DataRegistryKey.LONG_PUSH_DB_IMPORTANCE,
                        (long) importance,
                        5,
                        ABX_PUSH_COMMON_DAO_CLASS_NAME,
                        true
                ));

        tempBoolean = vibrateEnable ? 1 : 0;
        getDataRegistry().putDataRegistry(
                new DataUnit(
                        DataRegistryKey.LONG_PUSH_DB_NOTIFICATION_CHANNEL_VIBRATE,
                        tempBoolean,
                        5,
                        ABX_PUSH_COMMON_DAO_CLASS_NAME,
                        true
                ));
    }

    public String getNotificationChannelName() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result =  abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_NOTIFICATION_CHANNEL_NAME, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public String getNotificationChannelDescription() {
        String result = "";
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = abxController.getDataRegistry()
                    .safeGetString(DataRegistryKey.STRING_PUSH_DB_NOTIFICATION_CHANNEL_DESCRIPTION, null);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public int getNotificationChannelLight() {
        int result = 1;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = (int) abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_PUSH_DB_NOTIFICATION_CHANNEL_LIGHT, 1);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public int getNotificationChannelVibrate() {
        int result = 1;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        try {
            result = (int) abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_PUSH_DB_NOTIFICATION_CHANNEL_VIBRATE, 1);
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public void pushEventTracking(JSONObject pushOpenParam) {
        if (this.componentsFactory.createOrGetDFNSessionState().isSessionStarted()) {
            LogEventParameter eventParameter = new LogEventParameter(
                    CoreConstants.GROUP_ABX,
                    CoreConstants.EVENT_OPEN_PUSH,
                    CommonUtils.getMapFromJSONObject(
                            CommonUtils.parseValueWithDataType(pushOpenParam, CommonUtils.FixType.PREFIX)),
                    0,
                    0
            );

            abxController.logEvent(eventParameter);
        }
    }

    public void customPushEventTracking(JSONObject pushOpenParam) {
        LogEventParameter eventParameter = new LogEventParameter(
                CoreConstants.GROUP_ABX,
                CoreConstants.EVENT_OPEN_PUSH,
                CommonUtils.getMapFromJSONObject(
                        CommonUtils.parseValueWithDataType(pushOpenParam, CommonUtils.FixType.PREFIX)),
                0,
                0
        );

        abxController.logEvent(eventParameter);
    }

    public void runInBackGroundInOrder(Runnable runnable) {
        abxController.runInBackGroundInOrder(runnable);
    }

    public void runInBackGroundWithoutOrder(Runnable runnable) {
        abxController.runInBackGroundWithoutOrder(runnable);
    }

    public boolean getStopPopUpFlag() {
        boolean result = false;
        if(abxController == null){
            return result;
        }
        if(abxController.getDataRegistry() == null){
            return result;
        }
        long stopPopUpFlag;
        try {
            stopPopUpFlag = abxController.getDataRegistry()
                    .safeGetLong(DataRegistryKey.LONG_POP_UP_STOP_FLAG, -1);
            result = stopPopUpFlag == 1;
        } catch (Exception e) {
            AbxLog.d("getDataRegistry is called before controller.startcontroller. Error: "+e.toString(), true);
        }
        return result;
    }

    public void setStopPopUpFlag(boolean stop) {
        if (stop) {
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.LONG_POP_UP_STOP_FLAG,
                            (long) 1,
                            5,
                            ABX_POP_UP_COMMON_DAO_CLASS_NAME,
                            true
                    ));
        } else {
            getDataRegistry().putDataRegistry(
                    new DataUnit(
                            DataRegistryKey.LONG_POP_UP_STOP_FLAG,
                            (long) 0,
                            5,
                            ABX_POP_UP_COMMON_DAO_CLASS_NAME,
                            true
                    ));
        }
    }


    public void addObserverToDeferredDeeplinkPostingObservable(IObserver<DeferredDeeplinkObserverModel> observer) {
        DeferredDeeplinkPostingObservable.getInstance().clear();
        DeferredDeeplinkPostingObservable.getInstance().add(observer);
    }

    public void addObserverToInAppMessageClickPostingObservable(
            IObserver<HashMap<String, Object>> observer) {
        InAppMessageClickPostingObservable.getInstance().clear();
        InAppMessageClickPostingObservable.getInstance().add(observer);
    }

    public void addObserverToDeeplinkPostingObservable(IObserver<String> observer) {
        DeeplinkPostingObservable.getInstance().clear();
        DeeplinkPostingObservable.getInstance().add(observer);
    }

    public void addObserverToOsPushEnableObservable(IObserver<Boolean> observer) {
        OsPushEnableObservable.getInstance().clear();
        OsPushEnableObservable.getInstance().add(observer);
    }

    public void addObserverToInAppMessageAutoFetchObservable(IObserver<Result<Empty>> observer) {
        InAppMessageAutoFetchObservable.getInstance().clear();
        InAppMessageAutoFetchObservable.getInstance().add(observer);
    }


    public boolean isAdbrixDisabled() {
        try {
            return CoreUtils.isAdbrixDisabled(abxController.getDataRegistry(), ()->{});
        } catch (Exception e) {
            AbxLog.e(e, true);
            return false;
        }
    }

    public boolean isForeground() {
        return this.componentsFactory.createOrGetDFNSessionState().inForeground();
    }

    public int getServerMode(Context context) {
        try {
            ApplicationInfo appInfo;
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            return bundle.getInt(CoreConstants.SERVER_MODE_KEY);
        } catch (Exception e) {
            AbxLog.e(e, true);
            return 0;
        }
    }

    public String getRegion(Context context) {
        try {
            ApplicationInfo appInfo;
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;

            return bundle.getString(CoreConstants.SERVER_REGION_KEY);
        } catch (Exception e) {
            AbxLog.e(e, true);
            return "";
        }
    }

    public void setServerMode(Context context) {
        CoreConstants.setServerMode(getServerMode(context), getRegion(context));
    }

    public int getPropertyMaxSize() {
        return this.componentsFactory.createOrGetRemoteConfigProvider().getConfigPropertyMaxSize();
    }

    public void deleteUserDataAndStopSDK(String userId, Runnable onSuccess, Runnable onFail) {
        abxController.deleteUserDataAndStopSDK(userId, onSuccess, onFail);
    }

    public void restartSDK(String userId, Runnable onSuccess, Runnable onFail) {
        abxController.restartSDK(userId, onSuccess, onFail);
    }

    public String getSDKVersion() {
        return SdkVersion.SDK_VERSION;
    }

    public void getUserId(Completion<Result<String>> completion){
        abxController.getUserId(completion);
    }
    public String getUserId(){
        String userId = getDataRegistry().safeGetString(DataRegistryKey.STRING_USER_ID, "");
        if(!CommonUtils.isNullOrEmpty(userId)){
            userId = this.componentsFactory.createOrGetRepository().getLoginId();
        }
        return userId;
    }

    public void fetchActionHistoryFromServer(String token, ActionHistoryIdType idType, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        abxController.fetchActionHistoryFromServer(token, idType, actionType, completion);
    }

    public void insertPushData(String pushDataString) {
        abxController.insertPushData(pushDataString);
    }

    public void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        abxController.getActionHistory(skip, limit, actionType, completion);
    }

    public void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        abxController.getAllActionHistory(actionType, completion);
    }

    public void deleteActionHistory(
            String token,
            String historyId,
            long timestamp,
            Completion<Result<Empty>> completion
    ) {
        abxController.deleteActionHistory(token, historyId, timestamp, completion);
    }

    public void deleteAllActionHistory(String token, ActionHistoryIdType idType, Completion<Result<Empty>> completion) {
        abxController.deleteAllActionHistory(token, idType, completion);
    }

    public void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion) {
        abxController.clearSyncedActionHistoryInLocalDB(completion);
    }

    public void clearAllActionHistoryInLocalDB() {
        abxController.clearAllActionHistoryInLocalDB();
    }

    public void setInAppMessageFetchMode(DfnInAppMessageFetchMode mode) {
        int inAppMessageFetchModeValue = getDataRegistry().safeGetInt(DataRegistryKey.INT_IN_APP_MESSAGE_FETCH_MODE_VALUE, -1);
        DfnInAppMessageFetchMode inAppMessageFetchMode = DfnInAppMessageFetchMode.fromInteger(inAppMessageFetchModeValue);
        if(inAppMessageFetchMode == mode){
            return;
        }
        getDataRegistry().putDataRegistry(new DataUnit(
                DataRegistryKey.INT_IN_APP_MESSAGE_FETCH_MODE_VALUE,
                mode.getValue(),
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
        fetchInAppMessage(true, new Completion<Result<Empty>>() {
            @Override
            public void handle(Result<Empty> result) {
                AbxLog.d("setInAppMessageFetchMode fetchInAppMessage completed: " + result, true);
                InAppMessageAutoFetchObservable.getInstance().notifyObserver(result);
            }
        });
    }

    public void setInAppMessageToken(String token) {
        DataRegistry dataRegistry = abxController.getDataRegistry();
        if(CommonUtils.isNull(dataRegistry)){
            return;
        }
        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_IN_APP_MESSAGE_TOKEN,
                token,
                5,
                ADBRIXRM_CLASS_NAME,
                true
        ));
    }

    public void fetchInAppMessage(boolean isDirectCall, Completion<Result<Empty>> completion) {
        abxController.fetchInAppMessage(isDirectCall, completion);
    }

    public void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion) {
        abxController.getAllInAppMessage(completion);
    }
    public void getSelfServeInAppMessages(AdBrixRm.GetSelfServeInAppMessagesCallback callback) {
        abxController.getSelfServeInAppMessages(callback);
    }

    public void openInAppMessage(String campaignId, Completion<Result<Empty>> completion) {
        abxController.openInAppMessage(campaignId, completion);
    }

    public void deleteAllInAppMessageDBContents() {
        abxController.deleteAllInAppMessageDBContents();
    }

    public void disableSDK(String reason) {
        this.abxController.disableSDK(reason);
    }

    public void printSdkState(){
        if(CommonUtils.isNull(this.componentsFactory)){
            AbxLog.e("componentsFactory is null", false);
            return;
        }
        CoreUtils.printDRState(this.componentsFactory.createOrGetDataRegistry());
    }

    public void requestGetAttributionData(String logId, AdBrixRm.GetAttributionDataCallback callback){
        abxController.requestGetAttributionData(logId, callback);
    }
    public void getSubscriptionStatus(AdBrixRm.GetSubscriptionStatusCallback callback){
        String userId = this.getUserId();
        if(CommonUtils.isNullOrEmpty(userId)){
            AbxLog.e("getSubscriptionStatus() userId is null or empty", false);
            if(!CommonUtils.isNull(callback)){
                callback.onCallback(new GetSubscriptionStatusResult(IApiConnection.RESPONSE_CODE_ERROR, SubscriptionStatusResult.RESULT_CODE_USER_ID_REQUIRED));
            }
            return;
        }
        abxController.getSubscriptionStatus(callback);
    }
    public void setSubscriptionStatus(SubscriptionStatus subscriptionStatus, AdBrixRm.SetSubscriptionStatusCallback callback){
        if(CommonUtils.isNull(subscriptionStatus)){
            AbxLog.e("setSubscriptionStatus() subscriptionStatus is null", false);
            if(!CommonUtils.isNull(callback)){
                callback.onCallback(new SetSubscriptionStatusResult(IApiConnection.RESPONSE_CODE_ERROR, SubscriptionStatusResult.RESULT_CODE_PROPERTY_REQUIRED));
            }
            return;
        }
        String userId = this.getUserId();
        if(CommonUtils.isNullOrEmpty(userId)){
            AbxLog.e("setSubscriptionStatus() userId is null or empty", false);
            if(!CommonUtils.isNull(callback)){
                callback.onCallback(new SetSubscriptionStatusResult(IApiConnection.RESPONSE_CODE_ERROR, SubscriptionStatusResult.RESULT_CODE_USER_ID_REQUIRED));
            }
            return;
        }
        abxController.setSubscriptionStatus(subscriptionStatus, callback);
    }

    private boolean isDuplicateCall(long invokeTimestamp){
        boolean result = false;
        long nowTime = System.currentTimeMillis();
        long diff = nowTime - invokeTimestamp;
        if(diff < 10){
            result = true;
            return result;
        }
        return result;
    }
    private DataRegistry getDataRegistry(){
        DataRegistry dataRegistry = componentsFactory.createOrGetDataRegistry();
        return dataRegistry;
    }
}
