package io.adbrix.sdk.component.executer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum DFNCommandPriority {
        PLUS_5(25),
        PLUS_4(24),
        PLUS_3(23),
        PLUS_2(22),
        PLUS_1(21),
        DEFAULT(20),
        MINUS_1(19),
        MINUS_2(18),
        MINUS_3(17),
        MINUS_4(16),
        MINUS_5(15);

        private int value;

        public int getValue() {
            return this.value;
        }

        DFNCommandPriority(int value) {
            this.value = value;
        }

        private static List<DFNCommandPriority> cachedSortedEnumValues;
        static{
                cachedSortedEnumValues = new ArrayList<>();
                DFNCommandPriority[] arr = DFNCommandPriority.values();
                Arrays.sort(arr, (a,b)->b.getValue() - a.getValue());
                cachedSortedEnumValues.addAll(Arrays.asList(arr));
        }
        public static List<DFNCommandPriority> SortedEnumValues(){
                return cachedSortedEnumValues;
        }
}
