package io.adbrix.sdk.component.autoEvent;

import com.igaworks.v2.core.AdBrixRm;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObservable;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.ITimerManager;
import io.adbrix.sdk.component.InAppMessageAutoFetchObservable;
import io.adbrix.sdk.data.DFNSessionState;
import io.adbrix.sdk.data.RemoteConfigProvider;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.ResultCallback;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class DailyFirstOpenAutoEventGenerator implements ITimerManager, IObservable<LogEventParameter> {
    private String abxDailyFirstOpenDateTime = null;
    private Boolean sendDailyFirstOpenEvent;
    private DataRegistry dataRegistry;
    private Repository repository;
    private Timer timer;
    private WeakReference<Timer> timerReference;
    private TimerTask timerTask;
    private WeakReference<TimerTask> timerTaskReference;
    private List<IObserver<LogEventParameter>> observers;
    private DFNSessionState dfnSessionState;
    private RemoteConfigProvider remoteConfigProvider;

    public DailyFirstOpenAutoEventGenerator(DataRegistry dataRegistry, Repository repository, DFNSessionState dfnSessionState, RemoteConfigProvider remoteConfigProvider) {
        this.dataRegistry = dataRegistry;
        this.repository = repository;
        this.dfnSessionState = dfnSessionState;
        this.remoteConfigProvider = remoteConfigProvider;
        observers = new ArrayList<>();
    }

    @Override
    public void add(IObserver<LogEventParameter> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<LogEventParameter> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(LogEventParameter logEventParameter) {
        for (IObserver<LogEventParameter> observer : observers) {
            observer.update(logEventParameter);
        }
    }

    @Override
    public void clear() {
        observers.clear();
    }

    public void process() {
        if(timerReference!=null && timerReference.get()!=null){
//            AbxLog.w("DailyFirstOpenTimer is working!", true);
            return;
        }
        timerReference = new WeakReference<>(new Timer());
        timer = timerReference.get();
        synchronized (timer){
            timerTaskReference = new WeakReference<>(new TimerTask() {
                @Override
                public void run() {
                    doTask();
                }
            });
            timerTask = timerTaskReference.get();
            if(timer != null){
                try {
                    timer.schedule(timerTask, 60_000);
                }catch (Exception e){
                    AbxLog.w(e, true);
                    setTimerToNull();
                }
            }

        }
    }

    private void doTask() {

        if (CoreUtils.isAdbrixAllStop(dataRegistry) || this.dfnSessionState.isAdbrixError()) {
            return;
        }
        try {

            abxDailyFirstOpenDateTime = dataRegistry.safeGetString(DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE, null);

            String tempNowDate = CoreUtils.getDateViaGMTDateFormat(CoreConstants.ABX_DATE_FORMAT_SIMPLE);
            String tempPrevDate = abxDailyFirstOpenDateTime;
            if (sendDailyFirstOpenEvent == null) {
                if (dataRegistry.safeGetString(DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT, null) == null) {
                    sendDailyFirstOpenEvent = false;
                } else {
                    sendDailyFirstOpenEvent = Boolean.valueOf(dataRegistry.safeGetString(DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT, null));
                }
            }
            // at the first time ( i.e. First Open )
            if (CommonUtils.isNullOrEmpty(tempPrevDate)) {
                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,
                        tempNowDate,
                        5,
                        this.getClass().getName(),
                        true));

                abxDailyFirstOpenDateTime = tempNowDate;
                tempPrevDate = tempNowDate;
            }

            AbxLog.i("Daily First Open... " + "NOW : " + tempNowDate + " , PREV : " + tempPrevDate, true);

            if (!tempPrevDate.equals(tempNowDate)) {

                clearNotificationStore();

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_DAILY_FIRST_OPEN_PREV_DATE,
                        tempNowDate,
                        5,
                        this.getClass().getName(),
                        true));

                sendDailyFirstOpenEvent = true;

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,
                        sendDailyFirstOpenEvent.toString(),
                        5,
                        this.getClass().getName(),
                        true));

                //new SyncApplicationConfigureUseCase(repository).execute();
                remoteConfigProvider.syncApplicationConfigure(new ResultCallback<String>() {
                    @Override
                    public void callback(Status result, String data) {
                        AbxLog.d(result.toString()+": "+data, true);
                    }
                });
            }
            if (this.dfnSessionState.inForeground() && sendDailyFirstOpenEvent) {
                sendDailyFirstOpenEvent = false;

                dataRegistry.putDataRegistry(new DataUnit(
                        DataRegistryKey.STRING_SEND_DAILY_FIRST_OPEN_EVT,
                        sendDailyFirstOpenEvent.toString(),
                        5,
                        this.getClass().getName(),
                        true));

                if (!CoreUtils.isAdbrixPause(dataRegistry)) {
                    LogEventParameter eventParameter = new LogEventParameter(
                            CoreConstants.GROUP_ABX,
                            CoreConstants.EVENT_DAILY_FIRSTOPEN,
                            null,
                            0,
                            0);

                    notifyObserver(eventParameter);
                }
            }
            abxDailyFirstOpenDateTime = tempNowDate;

            //InAppMessage
            AdBrixRm.fetchInAppMessage(new Completion<Result<Empty>>() {
                @Override
                public void handle(Result<Empty> result) {
                    AbxLog.d("DailyFirstOpenAutoEventGenerator fetchInAppMessage completed: " + result, true);
                    InAppMessageAutoFetchObservable.getInstance().notifyObserver(result);
                }
            });
            //InAppMessage end

        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    private void clearNotificationStore() {
        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_ABX_NOTIFICATION_ID,
                "",
                5,
                this.getClass().getName(),
                true));
    }

    @Override
    public void setTimerToNull() {
        AbxLog.w("DailyFirstOpenTimer is cancelled", true);
        try {
            if(timerTask == null){
                if(timerTaskReference!=null){
                    timerTask = timerTaskReference.get();
                }
            }
            if(timerTask!=null){
                timerTask.cancel();
                timerTask = null;
                timerTaskReference = null;
            }
            if(timer==null){
                if(timerReference!=null){
                    timer = timerReference.get();
                }
            }
            if(timer!=null){
                synchronized (timer){
                    if(timer!=null){
                        timer.cancel();
                        timer.purge();
                        timer = null;
                        timerReference = null;
                    }
                }
            }
        }catch (Exception e){
            AbxLog.w(e, true);
        }
    }
    public void deactivate(){
        clear();
        setTimerToNull();
    }
}
