package io.adbrix.sdk.component;


import io.adbrix.sdk.domain.model.CommonModel;
import io.adbrix.sdk.domain.model.EventPackage;
import io.adbrix.sdk.domain.model.Response;

public interface IEventSender {
    /**
     * 2023.01.05 bobos
     * 에러코드 참조 @see("https://docs.oracle.com/cd/E25294_01/doc.920/e15484/oltappxa.htm")
     */
    public static final int RESPONSE_CODE_OK = 200;
    public static final int RESPONSE_CODE_DISCONNECTED = 12163;
    public static final int RESPONSE_CODE_CONNECTION_ABORTED = 12030;
    public static final int RESPONSE_CODE_ERROR = -1;
    void sendEvent(EventPackage eventPackage, IEventSendActionListener sendActionListener);

    interface IEventSendActionListener {
        void onSuccess(Response response, EventPackage eventPackage);

        void onFail(Response response, EventPackage eventPackage);
    }

    CommonModel getCommonModel();
}
