package io.adbrix.sdk.component;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.Arrays;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.utils.CommonUtils;

public class AbxLog {
    private static IPairObserver<Integer, String> logObserver;
    public static final int MAX_LOG_LENGTH = 20000;
    private static boolean qaLogEnable = false;

    private AbxLog() {
    }

    public static void setQAMode(boolean qaMode){
        AbxLog.qaLogEnable = qaMode;
    }

    public static void checkDebugAppInstalled(Context context) {
        //개발시엔 디버깅 앱 설치
        AbxLog.qaLogEnable = checkPkgInstall(context);

        if (AbxLog.qaLogEnable)
            AbxLog.d("QA MODE!", true);
    }

    public static void v(String msg, boolean qaModeOnly) {
        notifyObserver(Log.VERBOSE, msg);

        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, msg, Log.VERBOSE);
    }

    public static void d(String msg, boolean qaModeOnly) {
        notifyObserver(Log.DEBUG, msg);

        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, msg, Log.DEBUG);
    }

    public static void i(String msg, boolean qaModeOnly) {
        notifyObserver(Log.INFO, msg);

        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, msg, Log.INFO);
    }

    public static void w(String msg, boolean qaModeOnly) {
        notifyObserver(Log.WARN, msg);

        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, msg, Log.WARN);
    }

    public static void w(Exception e, boolean qaModeOnly) {
        String result = getMessageWithThrowable(null, e);
        notifyObserver(Log.WARN, result);
        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, result, Log.WARN);
    }

    public static void w(String msg, Exception e, boolean qaModeOnly) {
        String result = getMessageWithThrowable(msg, e);
        notifyObserver(Log.WARN, result);
        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, result, Log.WARN);
    }

    public static void e(String msg, boolean qaModeOnly) {
        notifyObserver(Log.ERROR, msg);

        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, msg, Log.ERROR);
    }

    public static void e(Exception e, boolean qaModeOnly) {
        String result = getMessageWithThrowable(null, e);
        notifyObserver(Log.ERROR, result);
        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, result, Log.ERROR);
    }

    public static void e(String msg, Exception e, boolean qaModeOnly) {
        String result = getMessageWithThrowable(msg, e);
        notifyObserver(Log.ERROR, result);
        if (!AbxLog.qaLogEnable) {
            return;
        }
        largeLog(ABXConstants.LOGTAG, result, Log.ERROR);
    }
    private static boolean checkPkgInstall(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            String adbrixRmDebugApp = "com.igaworks.adbrixrm.debug";
            pm.getApplicationInfo(adbrixRmDebugApp, 0);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    private static void largeLog(String tag, String content, int type) {
        if (content.length() > 4000) {
            log(tag, content.substring(0, 4000), type);
            largeLog(tag, content.substring(4000), type);
        } else {
            log(tag, content, type);
        }
    }
    private static void log(String tag, String content, int type){
        switch (type){
            case Log.VERBOSE:
                Log.v(tag, content);
                break;
            case Log.DEBUG:
                Log.d(tag, content);
                break;
            case Log.INFO:
                Log.i(tag, content);
                break;
            case Log.WARN:
                Log.w(tag, content);
                break;
            case Log.ERROR:
                Log.e(tag, content);
                break;
            case Log.ASSERT:
                Log.wtf(tag, content);
                break;
        }
    }

    public static void setLogObserver(IPairObserver<Integer, String> observer) {
        logObserver = observer;
    }

    private static void notifyObserver(Integer level, String message) {
        if (logObserver != null)
            logObserver.update(level, message);
    }
    public static String getStackTraceString(Throwable tr){
        Throwable t = tr;
        while (t != null) {
            if (t instanceof UnknownHostException) {
                return "";
            }
            t = t.getCause();
        }

        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
    public static String getMessageWithThrowable(String msg, Throwable throwable){
        StringBuilder builder = new StringBuilder();
        if(CommonUtils.isNull(throwable)){
            return msg;
        }
        if(!CommonUtils.isNullOrEmpty(msg)){
            builder.append("\"");
            builder.append(msg);
            builder.append("\" ");
        }
        String threadName = Thread.currentThread().getName();
        if(!CommonUtils.isNullOrEmpty(threadName)){
            builder.append("on ");
            builder.append(threadName);
        }
        String stackTraceString = getStackTraceString(throwable);
        if(!CommonUtils.isNullOrEmpty(stackTraceString)){
            builder.append("\n");
            builder.append(stackTraceString);
        }
        String result = builder.toString();
        return result;
    }
}
