package com.igaworks.v2.core.result;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.utils.CommonUtils;

public class ResultWithDeeplink extends Result{
    protected Context context;
    protected String deeplink;
    public void openViewByDeeplink(){
        if(CommonUtils.isNullOrEmpty(deeplink)){
            AbxLog.d("deeplink is empty", false);
            return;
        }
        Uri uri = null;
        try {
            uri = Uri.parse(deeplink);
        }catch (Exception e){
            AbxLog.d("deeplink parsing error", false);
            return;
        }
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public Uri getDeeplinkUri(){
        if(CommonUtils.isNullOrEmpty(deeplink)){
            return null;
        }
        try {
            Uri uri = Uri.parse(deeplink);
            return uri;
        }catch (Exception e){
            AbxLog.e(e, false);
            return null;
        }
    }
    public String getDeeplink() {
        return deeplink;
    }
    public Uri getUrlDecodedDeeplinkUri(){
        if(CommonUtils.isNullOrEmpty(deeplink)){
            return null;
        }
        try {
            Uri uri = Uri.parse(Uri.decode(deeplink));
            return uri;
        }catch (Exception e){
            AbxLog.e(e, false);
            return null;
        }
    };
    public String getUrlDecodedDeeplink(){
        Uri uri = getUrlDecodedDeeplinkUri();
        if(CommonUtils.isNull(uri)){
            return deeplink;
        } else{
            return uri.toString();
        }
    };

    @Override
    public String toString() {
        return "Result{" +
                "deeplink='" + deeplink + '\'' +
                '}';
    }
}
