package com.igaworks.v2.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;

import com.google.firebase.messaging.RemoteMessage;
import com.igaworks.v2.core.application.AbxActivityLifecycleCallbacks;
import com.igaworks.v2.core.result.GetSubscriptionStatusResult;
import com.igaworks.v2.core.result.OnDeeplinkResult;
import com.igaworks.v2.core.result.OnDeferredDeeplinkResult;
import com.igaworks.v2.core.result.OnLocalPushClickResult;
import com.igaworks.v2.core.result.OnRemotePushClickResult;
import com.igaworks.v2.core.result.GetAttributionDataResult;
import com.igaworks.v2.core.result.SetCiProfileResult;
import com.igaworks.v2.core.result.SetSubscriptionStatusResult;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.component.IPairObserver;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CompatConstants;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.ActionHistory;
import io.adbrix.sdk.domain.model.ActionHistoryError;
import io.adbrix.sdk.domain.model.ActionHistoryIdType;
import io.adbrix.sdk.domain.model.DeferredDeeplinkObserverModel;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Error;
import io.adbrix.sdk.domain.model.SelfServeInAppMessage;
import io.adbrix.sdk.domain.model.Response;
import io.adbrix.sdk.domain.model.EventData;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.SubscriptionStatus;
import io.adbrix.sdk.ui.inappmessage.InAppMessageManager;
import io.adbrix.sdk.ui.push.components.PushController;
import io.adbrix.sdk.ui.push.models.PushEvent;
import io.adbrix.sdk.ui.push.utils.PushUtils;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.ExtraUtils;

//import com.igaworks.v2.core.push.popup.Model.InAppBar;
//import com.igaworks.v2.core.push.popup.Model.InAppCarousel;
//import com.igaworks.v2.core.push.popup.Model.InAppFullImage;
//import com.igaworks.v2.core.push.popup.Model.InAppFullWebView;
//import com.igaworks.v2.core.push.popup.Model.InAppModal;
//import com.igaworks.v2.core.push.popup.PopUpHandler;
//import com.igaworks.v2.core.push.popup.PopUpUtils;

//TODO AdbrixRm은 v1 api를 맞춰주기위한 기능만 해야한다. 하지만 지금은 너무 많은 역할을 하고 있다. 이를 사용하는 클래스로 넘겨야 한다.
public class AdBrixRm {
    public static Boolean isInitialized = false;
    private static DeferredDeeplinkListener deferredDeeplinkListener;
    private static onDeferredDeeplinkListener onDeferredDeeplinkListener;
    private static DeeplinkListener deeplinkListener;
    private static onDeeplinkListener onDeeplinkListener;
    private static InAppMessageClickListener inAppMessageClickListener;
    private static DfnInAppMessageAutoFetchListener dfnInAppMessageAutoFetchListener;
    private static LogListener logListener;
    private static EventListener eventListener;

    static IABXComponentsFactory customComponentFactory = null;
    static boolean qaLogEnable = false;
    static boolean enableAdIdTracking = true;
    static AbxFacade abxFacade = null;

    public static class Game extends AbxGame{}
    public static class Common extends AbxCommon{}
    public static class Commerce extends AbxCommerce{}

    private AdBrixRm() {
    }
    public static String getAppKey(){
        String result = "";
        if (isAdbrixDisabled()){
            return result;
        }
        result = abxFacade.getAppKey();
        return result;
    }
    public static void init(Application application, String appKey, String secretKey){
        init(application, application.getApplicationContext(), appKey, secretKey);
    }

    @Deprecated
    public static void init(Context appContext, String appKey, String secretKey) {
        init(null, appContext, appKey, secretKey);
    }

    private static void init(Application application, Context appContext, String appKey, String secretKey) {
        try {
            AbxLog.checkDebugAppInstalled(appContext);
            if(CommonUtils.notNull(abxFacade)){
                abxFacade.setContext(appContext);
            }
            if(AdBrixRm.isInitialized){
                Log.d("abxrm", "AdBrixRm is already initialized");
                return;
            }
            if(CommonUtils.notNull(application)){
                application.registerActivityLifecycleCallbacks(new AbxActivityLifecycleCallbacks());
            }
            AdBrixRm.isInitialized = true;

            abxFacade = new AbxFacade(
                    appContext,
                    appKey,
                    secretKey,
                    customComponentFactory,
                    enableAdIdTracking
            );
            abxFacade.addObserverToDeferredDeeplinkPostingObservable(new DeferredDeeplinkObserver());
            abxFacade.addObserverToDeeplinkPostingObservable(new DeeplinkObserver());
            abxFacade.addObserverToInAppMessageClickPostingObservable(new InAppMessageClickObserver());
            abxFacade.addObserverToInAppMessageAutoFetchObservable(new InAppMessageFetchObserver());
            abxFacade.addObserverToOsPushEnableObservable(new OsPushEnableObserver());
        }catch (Exception e)
        {
            AbxLog.e("init fail >> Error: ",e, false);
        }
    }

    public static void login(final String userId) {
        login(userId, null);
    }

    public static void login(final String userId, Completion<Result<Response>> completion) {
        try {
            if (isAdbrixDisabled()){
                if(CommonUtils.notNull(completion)){
                    completion.handle(Error.of("Adbrix is Disabled"));
                }
                return;
            }
            if(userId == null){
                AbxLog.e("userId is null", false);
                if(CommonUtils.notNull(completion)){
                    completion.handle(Error.of("userId is null"));
                }
                return;
            }
            if (CommonUtils.isNullOrEmpty(userId.trim())){
                AbxLog.e("userId is empty", false);
                if(CommonUtils.notNull(completion)){
                    completion.handle(Error.of("userId is empty"));
                }
                return;
            }
            abxFacade.login(userId, completion);
        } catch (Exception e) {
            AbxLog.e("login >> Error: ",e, false);
            if(CommonUtils.notNull(completion)){
                completion.handle(Error.of(e));
            }
        }
    }

    public static void logout() {
        logout(null);
    }

    public static void logout(Completion<Result<Response>> completion) {
        try {
            if (isAdbrixDisabled()){
                if(CommonUtils.notNull(completion)){
                    completion.handle(Error.of("Adbrix is Disabled"));
                }
                return;
            }
            abxFacade.logout(completion);
        } catch (Exception e){
            AbxLog.e(e, false);
            if(CommonUtils.notNull(completion)){
                completion.handle(Error.of(e));
            }
        }
    }

    public static void gdprForgetMe(Context appContext) {
        try {
            abxFacade.gdprForgetMe();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setAge(int age) {
        try {
            if (isAdbrixDisabled()) return;

            UserProperties userProperties = new UserProperties();
            userProperties.setAttrs("abx:age", age);

            saveUserProperties(userProperties);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setGender(AbxGender gender) {
        try {
            if (isAdbrixDisabled()) return;

            if (gender == null) {
                AbxLog.i("setGender: null value for gender >> Auto change null to AbxGender.UNKNOWN", true);
                gender = AbxGender.UNKNOWN;
            }

            UserProperties userProperties = new UserProperties();
            userProperties.setAttrs("abx:gender", gender.getIntValue());

            saveUserProperties(userProperties);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    //With Event
    public static void saveUserProperties(UserProperties userProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (userProperties == null) {
                AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
                return;
            }

            abxFacade.saveUserProperty(userProperties.propertiesJson);

        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    //Without Event
    private static void saveUserPropertiesWithoutEvent(UserProperties userProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (userProperties == null) {
                AbxLog.w("Ignore saveUserProperties function :: null value for userProperties", true);
                return;
            }

            abxFacade.saveUserPropertyWithoutEvent(userProperties.propertiesJson);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void event(String eventName) {
        try {
            if (isAdbrixDisabled()) return;
            if (eventName == null) {
                AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
                return;
            }
            abxFacade.event(eventName);

        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void event(String eventName, final AttrModel attrModel) {
        try {
            if (isAdbrixDisabled()) return;

            if (eventName == null) {
                AbxLog.e("event:: null value for eventName. Cancel event logging.", true);
                return;
            }
            AttrModel tempAttrModel = attrModel;
            if (tempAttrModel == null) {
                AbxLog.e("event:: null value for attrModel. Auto change null to Empty AttrModel.", false);
                tempAttrModel = new AttrModel();
            }

            abxFacade.event(eventName, CommonUtils.parseValueWithDataType(tempAttrModel.toJSONObject("custom event"), CommonUtils.FixType.PREFIX));
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void flushAllEvents(Completion<Result<Empty>> completion) {
        try {
            abxFacade.flushAllEvents(completion);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    private static void postAbxEvent(String eventName) {
        try {
            abxFacade.postAbxEvent(eventName);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    static void postAbxEvent(String eventName, JSONObject eventParam) {
        try {
            abxFacade.postAbxEvent(eventName, eventParam);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    static void postSameAbxEvent(List<CommerceProductModel> products, String eventName, JSONObject attributes) {
        try {
            List<List<CommerceProductModel>> listOfList = CommonUtils.split(products, CompatConstants.MAX_PRODUCT_LIST_LENGTH);
            List<JSONArray> jsonArrayList = new ArrayList<>();
            List<JSONObject> jsonObjectList = new ArrayList<>();
            for (List<CommerceProductModel> commerceProductModelList : listOfList) {
                JSONArray array = new JSONArray();
                try {
                    array = ExtraUtils.getProductJsonArrayForPurchase(commerceProductModelList);
                    jsonArrayList.add(array);
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
            }

            for (JSONArray productJsonArray : jsonArrayList) {
                jsonObjectList.add(
                        ExtraUtils.getCommerceEventParams(productJsonArray, CommonUtils.parseValueWithDataType(attributes, CommonUtils.FixType.PREFIX)));
            }

            abxFacade.postSameAbxEvent(eventName, CoreConstants.GROUP_ABX, jsonObjectList);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void onPause() {
        try {
            abxFacade.onPause(null);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void onPause(Activity activity) {
        try {
            abxFacade.onPause(activity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void onDestroy(Activity activity) {
        try {
            abxFacade.onDestroy(activity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void onResume(Activity activity) {
        try {
            abxFacade.onResume(activity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void onMessageReceived(Context context, RemoteMessage remoteMessage) {
        try {
            abxFacade.onMessageReceived(context, remoteMessage);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static boolean isAdbrixDisabled() {
        boolean result = false;
        if(CommonUtils.isNull(abxFacade)){
            return result;
        }
        try {
            result = abxFacade.isAdbrixDisabled();
        } catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    @Deprecated
    public static void setDeferredDeeplinkListener(DeferredDeeplinkListener deferredDeeplinkListener) {
        try {
            AdBrixRm.deferredDeeplinkListener = deferredDeeplinkListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setOnDeferredDeeplinkListener(onDeferredDeeplinkListener listener) {
        try {
            AdBrixRm.onDeferredDeeplinkListener = listener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void setDeeplinkListener(DeeplinkListener deeplinkListener) {
        try {
            AdBrixRm.deeplinkListener = deeplinkListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setOnDeeplinkListener(onDeeplinkListener listener) {
        try {
            AdBrixRm.onDeeplinkListener = listener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setInAppMessageClickListener(InAppMessageClickListener inAppMessageClickListener) {
        try {
            AdBrixRm.inAppMessageClickListener = inAppMessageClickListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setDfnInAppMessageAutoFetchListener(DfnInAppMessageAutoFetchListener dfnInAppMessageAutoFetchListener) {
        try {
            AdBrixRm.dfnInAppMessageAutoFetchListener = dfnInAppMessageAutoFetchListener;
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deeplinkEvent(Activity deeplinkActivity) {
        try {
            if (isAdbrixDisabled()) return;

            abxFacade.deeplink(deeplinkActivity);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deeplinkEventWithIntent(Intent deeplinkIntent) {
        try {
            if (isAdbrixDisabled()) return;

            abxFacade.deeplinkWithIntent(deeplinkIntent);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setEventUploadCountInterval(AdBrixEventUploadCountInterval eventUploadCountInterval) {
        try {
            if (isAdbrixDisabled()) return;

            int minValue = AdBrixEventUploadCountInterval.MIN.getIntValue();
            int defValue = AdBrixEventUploadCountInterval.NORMAL.getIntValue();
            int maxValue = AdBrixEventUploadCountInterval.MAX.getIntValue();

            int countIntervalValue = eventUploadCountInterval.getIntValue();

            if (countIntervalValue != minValue && countIntervalValue != defValue && countIntervalValue != maxValue) {
                countIntervalValue = defValue;
            }

            abxFacade.setCountInterval(countIntervalValue);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setEventUploadTimeInterval(AdBrixEventUploadTimeInterval eventUploadTimeInterval) {
        try {
            if (isAdbrixDisabled()) return;

            int minValue = AdBrixEventUploadTimeInterval.MIN.getIntValue();
            int defValue = AdBrixEventUploadTimeInterval.NORMAL.getIntValue();
            int maxValue = AdBrixEventUploadTimeInterval.MAX.getIntValue();

            int timeIntervalValue = eventUploadTimeInterval.getIntValue();

            if (timeIntervalValue != minValue && timeIntervalValue != defValue && timeIntervalValue != maxValue) {
                timeIntervalValue = defValue;
            }

            abxFacade.setTimeInterval(timeIntervalValue);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void setLocalPushMessageListener(onTouchLocalPushListener localPushMessageListener) {
        PushController.getInstance().setLocalPushMessageListener(localPushMessageListener::onTouchLocalPush);
    }
    @Deprecated
    public static void setRemotePushMessageListener(onTouchRemotePushListener remotePushMessageListener) {
        PushController.getInstance().setRemotePushMessageListener(remotePushMessageListener::onTouchRemotePush);
    }
    public static void setOnLocalPushClickListener(onLocalPushClickListener listener){
        PushController.getInstance().setLocalPushClickListener(listener);
    }
    public static void setOnRemotePushClickListener(onRemotePushClickListener listener){
        PushController.getInstance().setRemotePushClickListener(listener);
    }

    public static void setNotificationDoNotDisturbEnable(boolean enable){
        try {
            abxFacade.setNotificationDoNotDisturbEnable(enable);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setNotificationDoNotDisturb(int startHour, int startMinutes, int endHour, int endMinutes){
        if(startHour >= 24 || startHour < 0){
            AbxLog.e("invalid time format : startHour must be 0~23", false);
            return;
        }
        if(startMinutes >= 60 || startMinutes < 0){
            AbxLog.e("invalid time format : startMinutes must be 0~59", false);
            return;
        }
        if(endHour >= 24 || endHour < 0){
            AbxLog.e("invalid time format : endHour must be 0~23", false);
            return;
        }
        if(endMinutes >= 60 || endMinutes < 0){
            AbxLog.e("invalid time format : endMinutes must be 0~59", false);
            return;
        }
        String doNotDisturbStartTimeRange = String.format("%02d%02d", startHour, startMinutes);
        String doNotDisturbEndTimeRange = String.format("%02d%02d", endHour, endMinutes);
        try {
            abxFacade.setNotificationDoNotDisturb(doNotDisturbStartTimeRange, doNotDisturbEndTimeRange);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static boolean getPushEnable(){
        boolean result = false;
        try {
            result = abxFacade.getPushEnable();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    public static boolean getOsPushEnable(){
        boolean result = false;
        try {
            result = abxFacade.getOsPushEnable();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;
    }

    public static void setPushEnable(boolean enable) {
        try {
            abxFacade.setPushEnable(enable);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setRegistrationId(String token) {
        try {
            abxFacade.setRegistrationID(token);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void notifyLocalPushNotification(String title, String body, String deeplink){
        notifyLocalPushNotification(title, body, deeplink, null);
    }

    public static void notifyLocalPushNotification(String title, String body, String deeplink, String imageUrl){
        abxFacade.notifyLocalPushNotification(title, body, deeplink, imageUrl);
    }

    @Deprecated
    public static void setBigTextClientPushEvent(Context ctx, BigTextPushProperties bigTextPushProp, boolean alwaysIsShown) {
        try {
            abxFacade.setBigTextClientPushEvent(ctx, bigTextPushProp, alwaysIsShown);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void setBigPictureClientPushEvent(Context ctx, BigPicturePushProperties bigPicturePushProperties, boolean alwaysIsShown) {
        try {
            abxFacade.setBigPictureClientPushEvent(ctx, bigPicturePushProperties, alwaysIsShown);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void cancelClientPushEvent(Context ctx, int eventId) {
        try {
            abxFacade.cancelClientPushEvent(ctx, eventId);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void cancelLocalPushNotification(Context ctx, int[] eventId) {
        try {
            abxFacade.cancelClientPushEvent(ctx, eventId);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void cancelLocalPushNotificationAll(Context ctx) {
        try {
            abxFacade.cancelClientPushEventAll(ctx);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static JSONArray getPushEventList() {
        JSONArray jsonArray = new JSONArray();
        try {
            jsonArray = abxFacade.getPushEventList();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return jsonArray;
    }

    public static List<PushEvent> getRegisteredLocalPushNotification(){
        List<PushEvent> list = new ArrayList<>();
        try {
            list = abxFacade.getRegisteredLocalPushNotification();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return list;
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, int argb) {
        try {
            abxFacade.setPushIconStyle(context,smallIconName, largeIconName, argb);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconName, PushColor color) {
        try {
            abxFacade.setPushIconStyle(context,smallIconName, largeIconName, color);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setPushIconStyle(Context context, String smallIconName, String largeIconname) {
        try {
            setPushIconStyle(context, smallIconName, largeIconname, -1);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setNotificationOption(Context context, int priority, int visibility) {
        try {
            abxFacade.setNotificationOption(priority, visibility);
        }catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void setNotificationChannel(Context context, String channelName, String channelDescription, int importance, boolean vibrateEnable) {
        PushUtils.createNotificationChannel(context, channelName, channelDescription, importance, vibrateEnable);
    }
    public static void createDefaultNotificationChannel(String name){
        abxFacade.createDefaultNotificationChannel(name, null);
    }
    public static void createDefaultNotificationChannel(String name, String description){
        abxFacade.createDefaultNotificationChannel(name, description);
    }

    @Deprecated
    public static void setKakaoId(String kakaoId) {
        try {
            if (isAdbrixDisabled()) return;

            if (kakaoId == null) {
                AbxLog.w("Ignore setKakaoId function :: null value for kakaoId", true);
                return;
            }

            /*CiProperties ciProperties = new CiProperties();
            ciProperties.setAttrs("kakao_id", kakaoId);

            abxFacade.saveCi(ciProperties.propertiesJson);*/
            setKakaoId(kakaoId, null);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setKakaoId(String kakaoId, SetCiProfileCallback callback){
        try {
            abxFacade.setCiProperty(CoreConstants.ABX_CI_KEY_KAKAO_ID, kakaoId, callback);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void setPhoneNumber(String phoneNumber, SetCiProfileCallback callback){
        try {
            abxFacade.setCiProperty(CoreConstants.ABX_CI_KEY_PHONE_NUMBER, phoneNumber, callback);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void saveCiProperties(String key, Object value) {
        try {
            if (isAdbrixDisabled()) return;

            if (key == null || value == null) {
                AbxLog.w("Ignore setCustomci function :: null value for key or value", true);
                return;
            }

            CiProperties ciProperties = new CiProperties();
            ciProperties.setAttrs(key, value);

            abxFacade.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void saveCiProperties(CiProperties ciProperties) {
        try {
            if (isAdbrixDisabled()) return;

            if (ciProperties == null) {
                AbxLog.d("ciProperties are null!", false);
                return;
            }

            abxFacade.saveCi(ciProperties.propertiesJson);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static AbxRemotePushModel parsePushData(Map<String, String> pushDataMap){
        return parsePushData(null, pushDataMap);
    }

    public static AbxRemotePushModel parsePushData(Context context, Map<String, String> pushDataMap){
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel();
        if (CommonUtils.isNullOrEmpty(pushDataMap)) {
            AbxLog.e("pushDataMap is null or empty!", false);
            return abxRemotePushModel;
        }

        try {
            String abxGfFcm = pushDataMap.get(ABXConstants.PUSH_REMOTE_FCM_KEY);
            if (abxGfFcm == null){
                return abxRemotePushModel;
            }
            JSONObject pushJson = new JSONObject();
            pushJson.put(ABXConstants.PUSH_REMOTE_FCM_KEY, new JSONObject(abxGfFcm));
            abxRemotePushModel = new AbxRemotePushModel(context, pushJson);
            return abxRemotePushModel;
        }catch(Exception e){
            AbxLog.e(e, true);
            return abxRemotePushModel;
        }
    }
    public static AbxRemotePushModel parsePushData(RemoteMessage remoteMessage){
        return parsePushData(null, remoteMessage);
    }

    public static AbxRemotePushModel parsePushData(Context context, RemoteMessage remoteMessage){
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel();
        if(remoteMessage == null){
            AbxLog.e("remoteMessage is null!", false);
            return abxRemotePushModel;
        }
        abxRemotePushModel = new AbxRemotePushModel(context, remoteMessage);
        return abxRemotePushModel;
    }

    public static AbxRemotePushModel parsePushData(Bundle bundle){
        return parsePushData(null, bundle);
    }

    public static AbxRemotePushModel parsePushData(Context context, Bundle bundle){
        AbxRemotePushModel abxRemotePushModel = new AbxRemotePushModel();
        if(CommonUtils.isNullOrEmpty(bundle)){
            AbxLog.e("bundle is null or empty!", false);
            return abxRemotePushModel;
        }
        abxRemotePushModel = new AbxRemotePushModel(context, bundle);
        return abxRemotePushModel;
    }

    public static void openPush(AbxRemotePushModel abxRemotePushModel){
        try {
            if (isAdbrixDisabled()) {
                AbxLog.e("openPush :: Adbrix is disabled because of (GdprForgetMe || Pause || Stop || Delete)", false);
                return;
            }
            if (abxRemotePushModel == null) {
                AbxLog.e("abxRemotePushModel is null", false);
                return;
            }
            if(!abxRemotePushModel.isOpenPushEventParamAvailable()){
                AbxLog.e("Adbrix push tracking parameters don't exist!", false);
                return;
            }
            AbxLog.d("openPush event called! param : " + abxRemotePushModel.toOpenPushEventParamJson(), true);
            abxFacade.customPushEventTracking(abxRemotePushModel.toOpenPushEventParamJson());
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void deleteUserDataAndStopSDK(String userId, Runnable onSuccess, Runnable onFail) {
        try {
            abxFacade.deleteUserDataAndStopSDK(userId, onSuccess, onFail);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void deleteUserDataAndStopSDK(Runnable onSuccess, Runnable onFail){
        deleteUserDataAndStopSDK(getUserId(), onSuccess, onFail);
    }

    @Deprecated
    public static void restartSDK(String userId, Runnable onSuccess, Runnable onFail) {
        try {
            abxFacade.restartSDK(userId, onSuccess, onFail);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    @Deprecated
    public static void restartSDK(Runnable onSuccess, Runnable onFail) {
        restartSDK(getUserId(), onSuccess, onFail);
    }

    public static String SDKVersion() {
        String result = "";
        try {
            result = abxFacade.getSDKVersion();
        } catch (Exception e){
            AbxLog.e(e, false);
        }
        return result;

    }

    public static void getUserId(Completion<Result<String>> completion){
        try {
            abxFacade.getUserId(completion);
        }catch (Exception e){
            AbxLog.e(e, false);
            if(CommonUtils.notNull(completion)){
                completion.handle(Error.of(e));
            }
        }
    }
    public static String getUserId(){
        String userId = "";
        try {
            userId = abxFacade.getUserId();
        }catch (Exception e){
            AbxLog.e(e, false);
        }
        return userId;
    }

    public static void setLogListener(LogListener logListener) {
        try {
            AdBrixRm.logListener = logListener;
            AbxLog.setLogObserver(null);
            AbxLog.setLogObserver(new LogObserver());
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void fetchActionHistoryByUserId(String token, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.fetchActionHistoryFromServer(token, ActionHistoryIdType.USER_ID, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void fetchActionHistoryByAdid(String token, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.fetchActionHistoryFromServer(token, ActionHistoryIdType.ADID, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void insertPushData(Map<String, String> data) {
        try {
            if (isAdbrixDisabled()) {
                AbxLog.d(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getErrorMessage(), false);
                return;
            }

            String pushDataString = data.get(ABXConstants.PUSH_REMOTE_FCM_KEY);

            if (pushDataString != null) {
                abxFacade.insertPushData(pushDataString);
            }
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void getActionHistory(int skip, int limit, List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.getActionHistory(skip, limit, actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void getAllActionHistory(List<String> actionType, Completion<Result<List<ActionHistory>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.getAllActionHistory(actionType, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteActionHistory(
            String token,
            String historyId,
            long timestamp,
            Completion<Result<Empty>> completion
    ) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.deleteActionHistory(token, historyId, timestamp, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteAllActionHistoryByUserId(String token, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.deleteAllActionHistory(token, ActionHistoryIdType.USER_ID, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void deleteAllActionHistoryByAdid(String token, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.deleteAllActionHistory(token, ActionHistoryIdType.ADID, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void clearSyncedActionHistoryInLocalDB(Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.clearSyncedActionHistoryInLocalDB(completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    /*@Deprecated
    public static void setInAppMessageFetchMode(DfnInAppMessageFetchMode mode) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            abxFacade.setInAppMessageFetchMode(mode);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }*/

    public static void setInAppMessageToken(String token) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            abxFacade.setInAppMessageToken(token);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void fetchInAppMessage(Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.fetchInAppMessage(false, completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    @Deprecated
    public static void getAllInAppMessage(Completion<Result<List<DfnInAppMessage>>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.getAllInAppMessage(completion);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void getSelfServeInAppMessages(GetSelfServeInAppMessagesCallback callback) {
        try {
            if (isAdbrixDisabled()) {
                return;
            }

            abxFacade.getSelfServeInAppMessages(callback);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void openInAppMessage(String campaignId, Completion<Result<Empty>> completion) {
        try {
            if (isAdbrixDisabled()) {
                completion.handle(ActionHistoryError.SDK_DISABLED_STATE_ERROR.getError());
                return;
            }

            abxFacade.openInAppMessage(campaignId, completion);

        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }


    public static void printSdkState(){
        try {
            abxFacade.printSdkState();
          }catch (Exception e){
          AbxLog.e(e, false);
        }
    }

    public static void pauseInAppMessage(){
        try {
            InAppMessageManager.getInstance().setPause();
            } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void resumeInAppMessage(){
        try {
            InAppMessageManager.getInstance().setResume();
            } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
   
    public static void requestGetAttributionData(GetAttributionDataCallback callback){
        requestGetAttributionData(null, callback);
    }

    public static void requestGetAttributionData(String logId, GetAttributionDataCallback callback){
        try {
            abxFacade.requestGetAttributionData(logId, callback);
            } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void getSubscriptionStatus(GetSubscriptionStatusCallback callback){
        try {
            abxFacade.getSubscriptionStatus(callback);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }
    public static void setSubscriptionStatus(SubscriptionStatus status, SetSubscriptionStatusCallback callback){
        try {
            abxFacade.setSubscriptionStatus(status, callback);
        } catch (Exception e){
            AbxLog.e(e, false);
        }
    }

    public static void setEnableAdIdTracking(boolean enable){
        AdBrixRm.enableAdIdTracking = enable;
    }

    public static void setEventListener(EventListener eventListener){
        AdBrixRm.eventListener = eventListener;
    }

    public static EventListener getEventListener(){
        return AdBrixRm.eventListener;
    }

    public enum AbxGender {
        MALE(2),
        FEMALE(1),
        UNKNOWN(0);

        private final int value;

        AbxGender(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
        public static AbxGender getValueByCode(int value){
            switch (value){
                case 0: return UNKNOWN;
                case 1: return FEMALE;
                case 2: return MALE;
                default: return UNKNOWN;
            }
        }
    }

    public enum AdBrixEventUploadCountInterval {
        MIN(10),
        NORMAL(30),
        MAX(60);

        private final int value;

        AdBrixEventUploadCountInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
        public static AdBrixEventUploadCountInterval getValueByInt(int value){
            switch (value){
                case 10:
                    return MIN;
                case 30:
                    return NORMAL;
                case 60:
                    return MAX;
                default:
                    return NORMAL;
            }
        }
    }

    public enum AdBrixEventUploadTimeInterval {
        MIN(30_000),
        NORMAL(60_000),
        MAX(120_000);

        private final int value;

        AdBrixEventUploadTimeInterval(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return value;
        }
        public static AdBrixEventUploadTimeInterval getValueByInt(int value){
            switch (value){
                case 30:
                    return MIN;
                case 60:
                    return NORMAL;
                case 120:
                    return MAX;
                default:
                    return NORMAL;
            }
        }
    }

    /*
    Push notification, Pop-Up
     */
    public enum PushColor {
        WHITE, BLACK, BLUE, YELLOW, RED, GREEN
    }

    public interface DeferredDeeplinkListener {
        void onReceiveDeferredDeeplink(String uriStr);
    }
    public interface onDeferredDeeplinkListener {
        void onReceive(OnDeferredDeeplinkResult result);
    }

    public interface DeeplinkListener {
        void onReceiveDeeplink(String uriStr);
    }
    public interface onDeeplinkListener {
        void onReceive(OnDeeplinkResult result);
    }

    public interface InAppMessageClickListener {
        void onReceiveInAppMessageClick(
                String actionId,
                String actionType,
                String actionArg,
                boolean isClosed
        );
    }

    public interface onTouchLocalPushListener {
        void onTouchLocalPush(String callbackJsonString);
    }
    public interface onLocalPushClickListener {
        void onClick(OnLocalPushClickResult result);
    }

    public interface onTouchRemotePushListener {
        void onTouchRemotePush(String callbackJsonString);
    }
    public interface onRemotePushClickListener {
        void onClick(OnRemotePushClickResult result);
    }

    public interface LogListener {
        void onPrintLog(int level, String message);
    }

    public interface DfnInAppMessageAutoFetchListener {
        void onFetchInAppMessage(Result<Empty> result);
    }

    public interface EventListener{
        void onEvent(EventData eventData);
    }

    public interface GetAttributionDataCallback {
        void onCallback(GetAttributionDataResult result);
    }
    public interface SetSubscriptionStatusCallback {
        void onCallback(SetSubscriptionStatusResult result);
    }
    public interface GetSubscriptionStatusCallback {
        void onCallback(GetSubscriptionStatusResult result);
    }
    public interface SetCiProfileCallback {
        void onCallback(SetCiProfileResult result);
    }
    public interface GetSelfServeInAppMessagesCallback {
        void onCallback(List<SelfServeInAppMessage> result);
    }

    private static class DeferredDeeplinkObserver implements IObserver<DeferredDeeplinkObserverModel> {

        @Override
        public void update(DeferredDeeplinkObserverModel model) {
            if (model.getDeferredDeeplink() == null) {
                AbxLog.d("deferredDeeplink is null", true);
                return;
            }
            if(CommonUtils.notNull(deferredDeeplinkListener)){
                deferredDeeplinkListener.onReceiveDeferredDeeplink(model.getDeferredDeeplink());
            }
            if(CommonUtils.notNull(onDeferredDeeplinkListener)){
                if(CommonUtils.isNull(abxFacade)){
                    AbxLog.d("abxFacade is null", true);
                    return;
                }
                onDeferredDeeplinkListener.onReceive(new OnDeferredDeeplinkResult(abxFacade.getContext(), model.getDeferredDeeplink(), model.getResultCode()));
            }
        }
    }

    private static class DeeplinkObserver implements IObserver<String> {
        @Override
        public void update(String deeplink) {
            if(CommonUtils.isNullOrEmpty(deeplink)){
                AbxLog.d("deeplink is null or empty", true);
                return;
            }
            if("null".equals(deeplink)){
                return;
            }
            if(CommonUtils.notNull(deeplinkListener)){
                String decodedDeeplink = deeplink;
                Uri uri = null;
                try {
                    uri = Uri.parse(Uri.decode(deeplink));
                    decodedDeeplink = uri.toString();
                }catch (Exception e){
                }
                deeplinkListener.onReceiveDeeplink(decodedDeeplink);
            }
            if(CommonUtils.notNull(onDeeplinkListener)){
                if(CommonUtils.isNull(abxFacade)){
                    AbxLog.d("abxFacade is null", true);
                    return;
                }
                onDeeplinkListener.onReceive(new OnDeeplinkResult(abxFacade.getContext(), deeplink));
            }
        }
    }

    private static class InAppMessageClickObserver implements IObserver<HashMap<String, Object>> {
        private final String actionId = "actionId";
        private final String actionType = "actionType";
        private final String actionArg = "actionArg";
        private final String isClosed = "isClosed";

        @Override
        public void update(HashMap<String, Object> clickInformation) {
            if (inAppMessageClickListener == null) {
                AbxLog.w("inAppMessageClickListener is null", true);
                return;
            }

            if (clickInformation == null) {
                AbxLog.w("InAppMessage click information is null", true);
                return;
            }

            inAppMessageClickListener.onReceiveInAppMessageClick(
                    (String) clickInformation.get(actionId),
                    (String) clickInformation.get(actionType),
                    (String) clickInformation.get(actionArg),
                    (boolean) clickInformation.get(isClosed)
            );
        }
    }

    private static class OsPushEnableObserver implements IObserver<Boolean> {

        @Override
        public void update(Boolean object) {
            abxFacade.updateOsPushEnable(object);
        }
    }

    private static class InAppMessageFetchObserver implements IObserver<Result<Empty>> {

        @Override
        public void update(Result<Empty> result) {
            if(dfnInAppMessageAutoFetchListener == null){
                AbxLog.w("dfnInAppMessageAutoFetchListener is null", true);
                return;
            }
            dfnInAppMessageAutoFetchListener.onFetchInAppMessage(result);
        }
    }

    public static class UserProperties {
        public JSONObject propertiesJson = new JSONObject();

        public UserProperties setAttrs(String property, Object value) {
            addToUserProperties(property, value);
            return this;
        }

        private void addToUserProperties(String property, Object value) {
            if (isAdbrixDisabled()) return;

            if (CommonUtils.isNullOrEmpty(property)) {
                AbxLog.w("Ignore addToUserProperties function :: property is null or empty string", true);
                return;
            }

            if (value == null) {
                AbxLog.w(String.format("Ignore addToUserProperties function :: null value for property %s", property), true);
                return;
            }
            /*if(property.equals("user_id")){
                if(value instanceof String){
                    //pass
                } else{
                    AbxLog.w(String.format("'user_id' is not string value! skip %s", property), true);
                    return;
                }
            }
            if(property.equals("age")){
                if(value instanceof Integer){
                    //pass
                } else{
                    AbxLog.w(String.format("'age' is not int value! skip %s", property), true);
                    return;
                }
            }
            if(property.equals("gender")){
                if(value instanceof Integer){
                    int intValue = ((Integer) value);
                    if(intValue >= 0 && intValue <= 2){
                        //pass
                    }else{
                        AbxLog.w(String.format("'gender' is out of range [0,2]. skip %s", property), true);
                        return;
                    }
                } else{
                    AbxLog.w(String.format("'gender' is not int value. skip %s", property), true);
                    return;
                }
            }*/

            try {
                String convertKey = ExtraUtils.convertPermittedStr(property);
                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return;
                }
                if (convertKey.length() > CompatConstants.MAX_KEY_LENGTH) {
                    return;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    // 20230620, mick, custom user_id, gender, age는 prefix를 미리 붙여줘야 기존과 구분됨
                    if(convertKey.equals("user_id")){
                        convertKey = "c:" + convertKey;
                    }
                    if(convertKey.equals("age")){
                        convertKey = "c:" + convertKey;
                    }
                    if(convertKey.equals("gender")){
                        convertKey = "c:" + convertKey;
                    }
                    propertiesJson.put(convertKey, value);
                }
            } catch (JSONException e) {
                AbxLog.e(e, true);
            }
        }
    }

    public static class CiProperties extends UserProperties {
        @Override
        public CiProperties setAttrs(String property, Object value) {
            super.setAttrs(property, value);
            return this;
        }
    }

    public static class AttrModel {
        protected JSONObject properties = new JSONObject();

        public AttrModel setAttrs(String property, Object value) {
            try {

                String convertKey = ExtraUtils.convertPermittedStr(property);

                if (CommonUtils.isNullOrEmpty(convertKey)) {
                    return this;
                }
                if (convertKey.length() > CompatConstants.MAX_KEY_LENGTH) {
                    return this;
                }
                if (ExtraUtils.isMatchedPermittedStr(convertKey)) {
                    properties.put(convertKey, value);
                }

            } catch (JSONException e) {
                AbxLog.e(e, true);
            }
            return this;
        }

        public static AttrModel fromJSONObject(JSONObject jsonObject){
            AdBrixRm.AttrModel result = new AdBrixRm.AttrModel();
            if(jsonObject == null){
                return result;
            }
            Iterator<String> keys = jsonObject.keys();
            while(keys.hasNext()) {
                String key = keys.next();
                try {
                    result.setAttrs(key, jsonObject.get(key));
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
            }
            return result;
        }

        public JSONObject toJSONObject(String tag) {
            JSONObject obj = new JSONObject();
            try {
                if(properties != null){
                    obj = properties;
                }
                obj = CommonUtils.truncate(ExtraUtils.limitCustomKeyNumber(ExtraUtils.cloneJSONObject(obj), tag, abxFacade.getPropertyMaxSize()), abxFacade.getPropertyMaxSize());
            } catch (Exception e) {
                AbxLog.e(e, false);
            }

            return obj;
        }
    }

//    public static void showBarPopUp(Activity activity, InAppBar resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.BAR, resource);
//    }
//
//    public static void showModalPopUp(Activity activity, InAppModal resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.MODAL, resource);
//    }
//
//    public static void showWebViewPopUp(Activity activity, InAppFullWebView resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_WEB_VIEW, resource);
//    }
//
//    public static void showCarouselPopUp(Activity activity, InAppCarousel resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.CAROUSEL, resource);
//    }
//
//    public static void showFullImagePopUp(Activity activity, InAppFullImage resource) {
//        PopUpHandler.showPopup(activity, PopUpUtils.POPUP_STYLE.FULL_IMAGE, resource);
//    }

    public static class GameProperties {

        public static class TutorialComplete {
            public static final String KEY_BOOLEAN_IS_SKIP = "is_skip";
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected Boolean isSkip = null;
            protected JSONObject gameProperties;

            public TutorialComplete() {
                gameProperties = new JSONObject();
            }

            public TutorialComplete setIsSkip(boolean isSkip) {
                this.isSkip = isSkip;
                return this;
            }

            public TutorialComplete setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                gameProperties = attrModel.toJSONObject("TutorialComplete");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.isSkip != null) {
                        obj.put(CompatConstants.ABX_GAME_IS_SKIP, isSkip);
                    }
                } catch (Exception e) {
                    AbxLog.e(e, false);
                }
                return obj;
            }
            public static TutorialComplete fromJSONString(String json){
                TutorialComplete result = new TutorialComplete();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_BOOLEAN_IS_SKIP)){
                        boolean isSkip = jsonObject.optBoolean(KEY_BOOLEAN_IS_SKIP);
                        result.setIsSkip(isSkip);
                    }
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class LevelAchieved {
            public static final String KEY_INT_LEVEL = "level";
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected Integer level = null;
            protected JSONObject gameProperties;

            public LevelAchieved() {
                this.gameProperties = new JSONObject();
            }

            public LevelAchieved setLevel(int level) {
                this.level = level;
                return this;
            }

            public LevelAchieved setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("LevelAchieved");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.level != null) {
                        obj.put(CompatConstants.ABX_GAME_LEVEL, level);
                    }
                }catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
            public static LevelAchieved fromJSONString(String json){
                LevelAchieved result = new LevelAchieved();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_INT_LEVEL)){
                        int level = jsonObject.optInt(KEY_INT_LEVEL);
                        result.setLevel(level);
                    }
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class CharacterCreated {
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected JSONObject gameProperties;

            public CharacterCreated() {
                this.gameProperties = new JSONObject();
            }

            public CharacterCreated setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("CharacterCreated");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                }catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }

            public static CharacterCreated fromJSONString(String json){
                CharacterCreated result = new CharacterCreated();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class StageCleared {
            public static final String KEY_STRING_STAGE_NAME = "stage_name";
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected String stageName = null;
            protected JSONObject gameProperties;

            public StageCleared() {
                this.gameProperties = new JSONObject();
            }

            public StageCleared setStageName(String stageName) {
                this.stageName = stageName;
                return this;
            }

            public StageCleared setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.gameProperties = attrModel.toJSONObject("StageCleared");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(gameProperties != null){
                        obj = gameProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.stageName != null){
                        obj.put(CompatConstants.ABX_GAME_STAGE_NAME, stageName);
                    }
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }

            public static StageCleared fromJSONString(String json){
                StageCleared result = new StageCleared();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_STAGE_NAME)){
                        String stageName = jsonObject.optString(KEY_STRING_STAGE_NAME);
                        result.setStageName(stageName);
                    }
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }
    }

    public static class CommonProperties {

        public static class Purchase {
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected JSONObject commonProperties;

            public Purchase() {
                this.commonProperties = new JSONObject();
            }

            public Purchase setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Purchase");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "Purchase", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }

            public static Purchase fromJSONString(String json){
                Purchase result = new Purchase();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class SignUp {
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected JSONObject commonProperties;

            public SignUp() {
                this.commonProperties = new JSONObject();
            }

            public SignUp setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("SignUp");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "SignUp", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }

                return obj;
            }
            public static SignUp fromJSONString(String json){
                SignUp result = new SignUp();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class UseCredit {
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";
            protected JSONObject commonProperties;

            public UseCredit() {
                this.commonProperties = new JSONObject();
            }

            public UseCredit setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("UseCredit");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "UseCredit", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }

                return obj;
            }
            public static UseCredit fromJSONString(String json){
                UseCredit result = new UseCredit();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class AppUpdate {
            public static final String KEY_STRING_PREV_VER = "prev_ver";
            public static final String KEY_STRING_CURR_VER = "curr_ver";
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected JSONObject commonProperties;

            protected String prevVer;
            protected String currVer;

            public AppUpdate() {
                this.commonProperties = new JSONObject();
                this.prevVer = null;
                this.currVer = null;
            }

            public AppUpdate setPrevVersion(String prevVer) {
                this.prevVer = prevVer;
                return this;
            }

            public AppUpdate setCurrVersion(String currVer) {
                this.currVer = currVer;
                return this;
            }

            public String getPrevVer() {
                return this.prevVer;
            }

            public String getCurrVer() {
                return this.currVer;
            }

            public AppUpdate setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("AppUpdate");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    if (this.prevVer != null) obj.put(CompatConstants.ABX_APP_PREV_VER, prevVer);
                    if (this.currVer != null) obj.put(CompatConstants.ABX_APP_CURR_VER, currVer);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "AppUpdate", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }

                return obj;
            }

            public static AppUpdate fromJSONString(String json){
                AppUpdate result = new AppUpdate();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_PREV_VER)){
                        String prevVer = jsonObject.optString(KEY_STRING_PREV_VER);
                        result.setPrevVersion(prevVer);
                    }
                    if(jsonObject.has(KEY_STRING_CURR_VER)){
                        String currVer = jsonObject.optString(KEY_STRING_CURR_VER);
                        result.setCurrVersion(currVer);
                    }
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }

        public static class Invite {
            public static final String KEY_STRING_EXTRA_ATTR = "extra_attr";

            protected JSONObject commonProperties;

            public Invite() {
                this.commonProperties = new JSONObject();
            }

            public Invite setAttrModel(AttrModel attrModel) {
                if (attrModel == null) return this;

                this.commonProperties = attrModel.toJSONObject("Invite");
                return this;
            }

            public JSONObject toJSONObject() {
                JSONObject obj = new JSONObject();
                try {
                    if(commonProperties != null){
                        obj = commonProperties;
                    }
                    obj = ExtraUtils.cloneJSONObject(obj);
                    obj = ExtraUtils.limitCustomKeyNumber(obj, "Invite", abxFacade.getPropertyMaxSize());
                } catch (Exception e){
                    AbxLog.e(e, false);
                }
                return obj;
            }
            public static Invite fromJSONString(String json){
                Invite result = new Invite();
                try {
                    JSONObject jsonObject = new JSONObject(json);
                    if(jsonObject.has(KEY_STRING_EXTRA_ATTR)){
                        JSONObject extraAttr = jsonObject.optJSONObject(KEY_STRING_EXTRA_ATTR);
                        result.setAttrModel(AttrModel.fromJSONObject(extraAttr));
                    }
                } catch (JSONException e) {
                    AbxLog.e(e, false);
                }
                return result;
            }
        }
    }

    public static class CommonSignUpChannel {
        public static final CommonSignUpChannel Kakao = new CommonSignUpChannel("Kakao");
        public static final CommonSignUpChannel Naver = new CommonSignUpChannel("Naver");
        public static final CommonSignUpChannel Line = new CommonSignUpChannel("Line");
        public static final CommonSignUpChannel Google = new CommonSignUpChannel("Google");
        public static final CommonSignUpChannel Facebook = new CommonSignUpChannel("Facebook");
        public static final CommonSignUpChannel Twitter = new CommonSignUpChannel("Twitter");
        public static final CommonSignUpChannel whatsApp = new CommonSignUpChannel("whatsApp");
        public static final CommonSignUpChannel QQ = new CommonSignUpChannel("QQ");
        public static final CommonSignUpChannel WeChat = new CommonSignUpChannel("WeChat");
        public static final CommonSignUpChannel UserId = new CommonSignUpChannel("UserId");
        public static final CommonSignUpChannel ETC = new CommonSignUpChannel("ETC");
        public static final CommonSignUpChannel SkTid = new CommonSignUpChannel("SkTid");
        public static final CommonSignUpChannel AppleId = new CommonSignUpChannel("AppleId");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int UserIdIdx = 10;
        public static final int ETCIdx = 11;
        public static final int SkTidIdx = 12;
        public static final int AppleIdIdx = 13;

        public String channel;

        public CommonSignUpChannel(String channel) {
            this.channel = channel;
        }

        public static CommonSignUpChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(UserId.getChannel())) {
                return UserId;
            } else if (channel.equalsIgnoreCase(SkTid.getChannel())) {
                return SkTid;
            } else if (channel.equalsIgnoreCase(AppleId.getChannel())) {
                return AppleId;
            } else {
                return ETC;
            }

        }

        public static CommonSignUpChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else if (channel == UserIdIdx) {
                return UserId;
            } else if (channel == SkTidIdx) {
                return SkTid;
            } else if (channel == AppleIdIdx) {
                return AppleId;
            } else {
                return ETC;
            }
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommonInviteChannel {
        public static final CommonInviteChannel Kakao = new CommonInviteChannel("Kakao");
        public static final CommonInviteChannel Naver = new CommonInviteChannel("Naver");
        public static final CommonInviteChannel Line = new CommonInviteChannel("Line");
        public static final CommonInviteChannel Google = new CommonInviteChannel("Google");
        public static final CommonInviteChannel Facebook = new CommonInviteChannel("Facebook");
        public static final CommonInviteChannel Twitter = new CommonInviteChannel("Twitter");
        public static final CommonInviteChannel whatsApp = new CommonInviteChannel("whatsApp");
        public static final CommonInviteChannel QQ = new CommonInviteChannel("QQ");
        public static final CommonInviteChannel WeChat = new CommonInviteChannel("WeChat");
        public static final CommonInviteChannel ETC = new CommonInviteChannel("ETC");

        public static final int KakaoIdx = 1;
        public static final int NaverIdx = 2;
        public static final int LineIdx = 3;
        public static final int GoogleIdx = 4;
        public static final int FacebookIdx = 5;
        public static final int TwitterIdx = 6;
        public static final int whatsAppIdx = 7;
        public static final int QQIdx = 8;
        public static final int WeChatIdx = 9;
        public static final int ETCIdx = 10;

        public String channel;

        public CommonInviteChannel(String channel) {
            this.channel = channel;
        }

        public static CommonInviteChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Kakao.getChannel())) {
                return Kakao;
            } else if (channel.equalsIgnoreCase(Naver.getChannel())) {
                return Naver;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(Google.getChannel())) {
                return Google;
            } else if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(Twitter.getChannel())) {
                return Twitter;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public static CommonInviteChannel getChannelByChannelCode(int channel) {
            if (channel == KakaoIdx) {
                return Kakao;
            } else if (channel == NaverIdx) {
                return Naver;
            } else if (channel == LineIdx) {
                return Line;
            } else if (channel == GoogleIdx) {
                return Google;
            } else if (channel == FacebookIdx) {
                return Facebook;
            } else if (channel == TwitterIdx) {
                return Twitter;
            } else if (channel == whatsAppIdx) {
                return whatsApp;
            } else if (channel == QQIdx) {
                return QQ;
            } else if (channel == WeChatIdx) {
                return WeChat;
            } else {
                return ETC;
            }

        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class CommerceProductModel {
        public static final String KEY_STRING_PRODUCT_ID = "product_id";
        public static final String KEY_STRING_PRODUCT_NAME = "product_name";
        public static final String KEY_DOUBLE_PRICE = "price";
        public static final String KEY_INT_QUANTITY = "quantity";
        public static final String KEY_DOUBLE_DISCOUNT = "discount";
        public static final String KEY_DOUBLE_SALES = "sales";
        public static final String KEY_INT_CURRENCY = "currency";
        public static final String KEY_STRING_CATEGORIES = "categories";

        protected String productID = "";
        protected String productName = "";
        protected double price = 0.0;
        protected int quantity = 1;
        protected double discount = 0.0;
        protected double sales = 0.0;
        protected Currency currency;
        protected CommerceCategoriesModel category;
        protected JSONObject extraAttrs;

        public CommerceProductModel() {
            this.extraAttrs = new JSONObject();
        }

        public String getProductID() {
            return productID;
        }

        public CommerceProductModel setProductID(String productID) {
            this.productID = productID;
            return this;
        }

        public String getProductName() {
            return productName;
        }

        public CommerceProductModel setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public double getPrice() {
            return price;
        }

        public CommerceProductModel setPrice(double price) {
            this.price = price;
            return this;
        }

        public int getQuantity() {
            return quantity;
        }

        public CommerceProductModel setQuantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public double getDiscount() {
            return discount;
        }

        public CommerceProductModel setDiscount(double discount) {
            this.discount = discount;
            return this;
        }

        public double getSales() {
            return sales;
        }

        public void setSales(double sales) {
            this.sales = sales;
        }

        public Currency getCurrency() {
            return currency;
        }

        public CommerceProductModel setCurrency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public CommerceCategoriesModel getCategory() {
            return category;
        }

        public CommerceProductModel setCategory(CommerceCategoriesModel category) {
            this.category = category;
            return this;
        }

        public CommerceProductModel setAttrModel(AttrModel attrModel) {
            if (attrModel == null) return this;

            this.extraAttrs = attrModel.toJSONObject("CommerceProductModel");
            return this;
        }

        public JSONObject getAttrs() {
            return extraAttrs;
        }

        public static CommerceProductModel fromJSONString(String json){
            AdBrixRm.CommerceProductModel result = new AdBrixRm.CommerceProductModel();
            try {
                JSONObject jsonObject = new JSONObject(json);
                return CommerceProductModel.fromJSONObject(jsonObject);
            } catch (JSONException e) {
                AbxLog.e(e, false);
                return result;
            }
        }

        public static CommerceProductModel fromJSONObject(JSONObject jsonObject){
            AdBrixRm.CommerceProductModel result = new AdBrixRm.CommerceProductModel();
            if(jsonObject == null){
                return result;
            }
            String productId = jsonObject.optString(KEY_STRING_PRODUCT_ID);
            String productName = jsonObject.optString(KEY_STRING_PRODUCT_NAME);
            double price = jsonObject.optDouble(KEY_DOUBLE_PRICE);
            int quantity = jsonObject.optInt(KEY_INT_QUANTITY);
            double discount = jsonObject.optDouble(KEY_DOUBLE_DISCOUNT);
            double sales = jsonObject.optDouble(KEY_DOUBLE_SALES);
            int currencyCode = jsonObject.optInt(KEY_INT_CURRENCY);
            String categories = jsonObject.optString(KEY_STRING_CATEGORIES);

            result.setProductID(productId);
            result.setProductName(productName);
            result.setPrice(price);
            result.setQuantity(quantity);
            result.setDiscount(discount);
            result.setSales(sales);
            result.setCurrency(Currency.getCurrencyByCurrencyCode(currencyCode));
            result.setCategory(CommerceCategoriesModel.fromJSONString(categories));
            return result;
        }

        public static List<AdBrixRm.CommerceProductModel> getListFromJSONString(String json){
            ArrayList<AdBrixRm.CommerceProductModel> result = new ArrayList<AdBrixRm.CommerceProductModel>();
            try {
                JSONArray root = new JSONArray(json);
                for(int i=0; i<root.length(); i++){
                    JSONObject productJson = root.optJSONObject(i);
                    AdBrixRm.CommerceProductModel productModel = CommerceProductModel.fromJSONObject(productJson);
                    result.add(productModel);
                }
            } catch (JSONException e) {
                AbxLog.e(e, false);
            }
            return result;
        }
    }

    public static class CommerceCategoriesModel {
        public static final String KEY_STRING_CATEGORY_1 = "category1";
        public static final String KEY_STRING_CATEGORY_2 = "category2";
        public static final String KEY_STRING_CATEGORY_3 = "category3";
        public static final String KEY_STRING_CATEGORY_4 = "category4";
        public static final String KEY_STRING_CATEGORY_5 = "category5";
        static final int MAX_COMMERCE_CATEGORY_NUMBER = 5;
        public LinkedList<String> categoriesLinkedList = new LinkedList<String>();

        public CommerceCategoriesModel() {
        }

        public CommerceCategoriesModel setCategory(String category) {
            if (categoriesLinkedList.size() < MAX_COMMERCE_CATEGORY_NUMBER) {
                if (!CommonUtils.isNullOrEmpty(category)) this.categoriesLinkedList.add(category);
            } else
                AbxLog.d("Skip adding more categories, MAX_COMMERCE_CATEGORY_NUMBER is " + MAX_COMMERCE_CATEGORY_NUMBER, true);
            return this;
        }
        public static CommerceCategoriesModel fromJSONString(String json){
            AdBrixRm.CommerceCategoriesModel result = new AdBrixRm.CommerceCategoriesModel();
            try {
                JSONObject jsonObject = new JSONObject(json);
                if(jsonObject.length() == 0){
                    return result;
                }
                for(int i=1; i<=jsonObject.length(); i++){
                    String category = jsonObject.optString("category"+i);
                    if(CommonUtils.isNullOrEmpty(category)){
                        continue;
                    }
                    result.setCategory(category);
                }
            } catch (JSONException e) {
                AbxLog.e(e, false);
            }
            return result;
        }
    }

    public static class Currency {
        public static final Currency KR_KRW = new Currency("KR", "KRW");
        public static final Currency US_USD = new Currency("US", "USD");
        public static final Currency JP_JPY = new Currency("JP", "JPY");
        public static final Currency EU_EUR = new Currency("EU", "EUR");
        public static final Currency UK_GBP = new Currency("UK", "GBP");
        public static final Currency CN_CNY = new Currency("CH", "CNY");
        public static final Currency TW_TWD = new Currency("TW", "TWD");
        public static final Currency HK_HKD = new Currency("HK", "HKD");
        //added new currency 2017-09-08 by john
        public static final Currency ID_IDR = new Currency("ID", "IDR"); //Indonesia
        public static final Currency IN_INR = new Currency("IN", "INR"); //India
        public static final Currency RU_RUB = new Currency("RU", "RUB"); //Russia
        public static final Currency TH_THB = new Currency("TH", "THB"); //Thailand
        public static final Currency VN_VND = new Currency("VN", "VND"); //Vietnam
        public static final Currency MY_MYR = new Currency("MY", "MYR"); //Malaysia

        public String country;
        public String code;

        public Currency(String country, String code) {
            this.country = country;
            this.code = code;
        }

        public static Currency getCurrencyByCurrencyCode(String currencyCode) {

            if (currencyCode.equalsIgnoreCase(KR_KRW.toString())) {
                return KR_KRW;
            } else if (currencyCode.equalsIgnoreCase(US_USD.toString())) {
                return US_USD;
            } else if (currencyCode.equalsIgnoreCase(JP_JPY.toString())) {
                return JP_JPY;
            } else if (currencyCode.equalsIgnoreCase(EU_EUR.toString())) {
                return EU_EUR;
            } else if (currencyCode.equalsIgnoreCase(UK_GBP.toString())) {
                return UK_GBP;
            } else if (currencyCode.equalsIgnoreCase(CN_CNY.toString())) {
                return CN_CNY;
            } else if (currencyCode.equalsIgnoreCase(TW_TWD.toString())) {
                return TW_TWD;
            } else if (currencyCode.equalsIgnoreCase(HK_HKD.toString())) {
                return HK_HKD;
            } else if (currencyCode.equalsIgnoreCase(ID_IDR.toString())) {
                return ID_IDR;
            } else if (currencyCode.equalsIgnoreCase(IN_INR.toString())) {
                return IN_INR;
            } else if (currencyCode.equalsIgnoreCase(RU_RUB.toString())) {
                return RU_RUB;
            } else if (currencyCode.equalsIgnoreCase(TH_THB.toString())) {
                return TH_THB;
            } else if (currencyCode.equalsIgnoreCase(VN_VND.toString())) {
                return VN_VND;
            } else if (currencyCode.equalsIgnoreCase(MY_MYR.toString())) {
                return MY_MYR;
            } else {
                return new Currency(currencyCode, currencyCode);
            }
        }

        public static Currency getCurrencyByCountryCode(String countryCode) {
            if (countryCode.equalsIgnoreCase(KR_KRW.getCountry())) {
                return KR_KRW;
            } else if (countryCode.equalsIgnoreCase(US_USD.getCountry())) {
                return US_USD;
            } else if (countryCode.equalsIgnoreCase(JP_JPY.getCountry())) {
                return JP_JPY;
            } else if (countryCode.equalsIgnoreCase(EU_EUR.getCountry())) {
                return EU_EUR;
            } else if (countryCode.equalsIgnoreCase(UK_GBP.getCountry())) {
                return UK_GBP;
            } else if (countryCode.equalsIgnoreCase(CN_CNY.getCountry())) {
                return CN_CNY;
            } else if (countryCode.equalsIgnoreCase(TW_TWD.getCountry())) {
                return TW_TWD;
            } else if (countryCode.equalsIgnoreCase(HK_HKD.getCountry())) {
                return HK_HKD;
            } else if (countryCode.equalsIgnoreCase(ID_IDR.getCountry())) {
                return ID_IDR;
            } else if (countryCode.equalsIgnoreCase(IN_INR.getCountry())) {
                return IN_INR;
            } else if (countryCode.equalsIgnoreCase(RU_RUB.getCountry())) {
                return RU_RUB;
            } else if (countryCode.equalsIgnoreCase(TH_THB.getCountry())) {
                return TH_THB;
            } else if (countryCode.equalsIgnoreCase(VN_VND.getCountry())) {
                return VN_VND;
            } else if (countryCode.equalsIgnoreCase(MY_MYR.getCountry())) {
                return MY_MYR;
            } else {
                return new Currency(countryCode, countryCode);
            }
        }
        public static Currency getCurrencyByCurrencyCode(int code) {
            switch (code){
                case 1:
                    return AdBrixRm.Currency.KR_KRW;
                case 2:
                    return AdBrixRm.Currency.US_USD;
                case 3:
                    return AdBrixRm.Currency.JP_JPY;
                case 4:
                    return AdBrixRm.Currency.EU_EUR;
                case 5:
                    return AdBrixRm.Currency.UK_GBP;
                case 6:
                    return AdBrixRm.Currency.CN_CNY;
                case 7:
                    return AdBrixRm.Currency.TW_TWD;
                case 8:
                    return AdBrixRm.Currency.HK_HKD;
                case 9:
                    return AdBrixRm.Currency.ID_IDR;
                case 10:
                    return AdBrixRm.Currency.IN_INR;
                case 11:
                    return AdBrixRm.Currency.RU_RUB;
                case 12:
                    return AdBrixRm.Currency.TH_THB;
                case 13:
                    return AdBrixRm.Currency.VN_VND;
                case 14:
                    return AdBrixRm.Currency.MY_MYR;
                default:
                    return AdBrixRm.Currency.KR_KRW;
            }
        }

        public String getCountry() {
            return country;
        }

        @Override
        public String toString() {
            return code;
        }
    }

    public static class CommercePaymentMethod {
        public static final CommercePaymentMethod CreditCard = new CommercePaymentMethod("CreditCard");
        public static final CommercePaymentMethod BankTransfer = new CommercePaymentMethod("BankTransfer");
        public static final CommercePaymentMethod MobilePayment = new CommercePaymentMethod("MobilePayment");
        public static final CommercePaymentMethod ETC = new CommercePaymentMethod("ETC");

        public static final int CreditCardIdx = 1;
        public static final int BankTransferIdx = 2;
        public static final int MobilePaymentIdx = 3;
        public static final int ETCIdx = 4;


        public String method;

        public CommercePaymentMethod(String method) {
            this.method = method;
        }

        public static CommercePaymentMethod getMethodByMethodCode(String method) {
            if (method.equalsIgnoreCase(CreditCard.getMethod())) {
                return CreditCard;
            } else if (method.equalsIgnoreCase(BankTransfer.getMethod())) {
                return BankTransfer;
            } else if (method.equalsIgnoreCase(MobilePayment.getMethod())) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public static CommercePaymentMethod getMethodByMethodCode(int method) {
            if (method == CreditCardIdx) {
                return CreditCard;
            } else if (method == BankTransferIdx) {
                return BankTransfer;
            } else if (method == MobilePaymentIdx) {
                return MobilePayment;
            } else {
                return ETC;
            }

        }

        public String getMethod() {
            return method;
        }

        @Override
        public String toString() {
            return method;
        }
    }

    public static class CommerceSharingChannel {
        public static final CommerceSharingChannel Facebook = new CommerceSharingChannel("Facebook");
        public static final CommerceSharingChannel KakaoTalk = new CommerceSharingChannel("KakaoTalk");
        public static final CommerceSharingChannel KakaoStory = new CommerceSharingChannel("KakaoStory");
        public static final CommerceSharingChannel Line = new CommerceSharingChannel("Line");
        public static final CommerceSharingChannel whatsApp = new CommerceSharingChannel("whatsApp");
        public static final CommerceSharingChannel QQ = new CommerceSharingChannel("QQ");
        public static final CommerceSharingChannel WeChat = new CommerceSharingChannel("WeChat");
        public static final CommerceSharingChannel SMS = new CommerceSharingChannel("SMS");
        public static final CommerceSharingChannel Email = new CommerceSharingChannel("Email");
        public static final CommerceSharingChannel copyUrl = new CommerceSharingChannel("copyUrl");
        public static final CommerceSharingChannel ETC = new CommerceSharingChannel("ETC");

        public String channel;

        public CommerceSharingChannel(String channel) {
            this.channel = channel;
        }

        public static CommerceSharingChannel getChannelByChannelCode(String channel) {
            if (channel.equalsIgnoreCase(Facebook.getChannel())) {
                return Facebook;
            } else if (channel.equalsIgnoreCase(KakaoTalk.getChannel())) {
                return KakaoTalk;
            } else if (channel.equalsIgnoreCase(KakaoStory.getChannel())) {
                return KakaoStory;
            } else if (channel.equalsIgnoreCase(Line.getChannel())) {
                return Line;
            } else if (channel.equalsIgnoreCase(whatsApp.getChannel())) {
                return whatsApp;
            } else if (channel.equalsIgnoreCase(QQ.getChannel())) {
                return QQ;
            } else if (channel.equalsIgnoreCase(WeChat.getChannel())) {
                return WeChat;
            } else if (channel.equalsIgnoreCase(SMS.getChannel())) {
                return SMS;
            } else if (channel.equalsIgnoreCase(Email.getChannel())) {
                return Email;
            } else if (channel.equalsIgnoreCase(copyUrl.getChannel())) {
                return copyUrl;
            } else if (channel.equalsIgnoreCase(ETC.getChannel())) {
                return ETC;
            } else {
                return new CommerceSharingChannel(channel);
            }
        }
        public static CommerceSharingChannel getChannelByChannelCode(int code) {
            switch (code){
                case 1:
                    return AdBrixRm.CommerceSharingChannel.Facebook;
                case 2:
                    return AdBrixRm.CommerceSharingChannel.KakaoTalk;
                case 3:
                    return AdBrixRm.CommerceSharingChannel.KakaoStory;
                case 4:
                    return AdBrixRm.CommerceSharingChannel.Line;
                case 5:
                    return AdBrixRm.CommerceSharingChannel.whatsApp;
                case 6:
                    return AdBrixRm.CommerceSharingChannel.QQ;
                case 7:
                    return AdBrixRm.CommerceSharingChannel.WeChat;
                case 8:
                    return AdBrixRm.CommerceSharingChannel.SMS;
                case 9:
                    return AdBrixRm.CommerceSharingChannel.Email;
                case 10:
                    return AdBrixRm.CommerceSharingChannel.copyUrl;
                case 11:
                    return AdBrixRm.CommerceSharingChannel.ETC;
                default:
                    return AdBrixRm.CommerceSharingChannel.ETC;
            }
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public String toString() {
            return channel;
        }
    }

    public static class PushProperties extends io.adbrix.sdk.ui.push.models.PushProperties {}
    public static class BigTextPushProperties extends io.adbrix.sdk.ui.push.models.BigTextPushProperties {
        public static BigTextPushProperties fromJSONObject(JSONObject jsonObject) {
            BigTextPushProperties properties = new BigTextPushProperties();
            properties.setFromJSONObject(jsonObject);
            return properties;
        }
        public BigTextPushProperties setBigText(String bigText) {
            super.bigText = bigText;
            return this;
        }

        public BigTextPushProperties setTitle(String title) {
            super.title = title;
            return this;
        }

        public BigTextPushProperties setSecond(long second) {
            super.second = second;
            return this;
        }

        public BigTextPushProperties setContentText(String contentText) {
            super.contentText = contentText;
            return this;
        }

        public BigTextPushProperties setSummaryText(String summaryText) {
            super.summaryText = summaryText;
            return this;
        }

        public BigTextPushProperties setBigContentTitle(String bigContentTitle) {
            super.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigTextPushProperties setEventId(int eventId) {
            super.eventId = eventId;
            return this;
        }

        public BigTextPushProperties setDeepLinkUri(String deepLinkUri) {
            super.deepLinkUri = deepLinkUri;
            return this;
        }
    }
    public static class BigPicturePushProperties extends io.adbrix.sdk.ui.push.models.BigPicturePushProperties {
        public static BigPicturePushProperties fromJSONObject(JSONObject jsonObject) {
            BigPicturePushProperties properties = new BigPicturePushProperties();
            properties.setFromJSONObject(jsonObject);
            return properties;
        }

        public BigPicturePushProperties setResourceId(int resourceId) {
            super.resourceId = resourceId;
            return this;
        }

        public BigPicturePushProperties setBigPictureUrl(String bigPictureUrl) {
            super.bigPictureUrl = bigPictureUrl;
            return this;
        }

        public BigPicturePushProperties setTitle(String title) {
            super.title = title;
            return this;
        }

        public BigPicturePushProperties setSecond(long second) {
            super.second = second;
            return this;
        }

        public BigPicturePushProperties setContentText(String contentText) {
            super.contentText = contentText;
            return this;
        }

        public BigPicturePushProperties setSummaryText(String summaryText) {
            super.summaryText = summaryText;
            return this;
        }

        public BigPicturePushProperties setBigContentTitle(String bigContentTitle) {
            super.bigContentTitle = bigContentTitle;
            return this;
        }

        public BigPicturePushProperties setEventId(int eventId) {
            super.eventId = eventId;
            return this;
        }

        public BigPicturePushProperties setDeepLinkUri(String deepLinkUri) {
            super.deepLinkUri = deepLinkUri;
            return this;
        }
    }

    public static class AbxRemotePushModel extends io.adbrix.sdk.ui.push.models.AbxRemotePushModel {
        public AbxRemotePushModel(){
            super();
        }
        public AbxRemotePushModel(Context context, RemoteMessage remoteMessage){
            super(context, remoteMessage);
        }
        public AbxRemotePushModel(Context context, JSONObject pushJson){
            super(context, pushJson);
        }
        public AbxRemotePushModel(Context context, Bundle bundle){
            super(context, bundle);
        }
        public AbxRemotePushModel(String campaignId, int campaignRevisionNo, String stepId, String cycleTime){
            super(campaignId, campaignRevisionNo, stepId, cycleTime);
        }
    }

    public static class LogObserver implements IPairObserver<Integer, String> {

        @Override
        public void update(Integer level, String message) {

            if (AdBrixRm.logListener == null) {
                Log.w("abxrm", "LogListener is null!");
                return;
            }

            AdBrixRm.logListener.onPrintLog(level, message);
        }
    }
}
