package io.adbrix.sdk.ui.inappmessage.webview;

import android.app.Activity;

import java.util.HashMap;
import java.util.Map;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.domain.ABXConstants;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.domain.model.LogEventParameter;
import io.adbrix.sdk.ui.inappmessage.InAppMessageDAO;
import io.adbrix.sdk.ui.inappmessage.InAppMessageManager;
import io.adbrix.sdk.ui.inappmessage.InAppMessageViewFactory;
import io.adbrix.sdk.ui.inappmessage.InAppMessageViewListener;
import io.adbrix.sdk.ui.inappmessage.InAppMessageViewWrapper;
import io.adbrix.sdk.utils.CommonUtils;

public class WebViewViewFactory extends InAppMessageViewFactory {
    private InAppMessageWebView inAppMessageWebView;
    private InAppMessageViewWrapper inAppMessageViewWrapper;
    private InAppMessageDAO inAppMessageDAO;

    private boolean isCarried;
    private String type;
    private String position;

    public WebViewViewFactory(InAppMessageDAO inAppMessageDAO, IABXContextController abxContextController) {
        super(inAppMessageDAO, abxContextController);
        this.inAppMessageDAO = inAppMessageDAO;
        this.abxContextController = abxContextController;
    }

    @Override
    public void createInAppMessage(Activity activity, DfnInAppMessage inAppMessage, boolean isCarried) {
        super.createInAppMessage(activity, inAppMessage, isCarried);
        AbxLog.i("createInAppMessage", true);
        this.isCarried = isCarried;
        type = inAppMessage.getType();
        position = inAppMessage.getPosition();
        activity.runOnUiThread(() -> {
            try {
                inAppMessageWebView = new InAppMessageWebView(activity, null);
                InAppMessageWebViewInterface inAppMessageWebViewInterface = new InAppMessageWebViewInterface(activity.getApplicationContext(), inAppMessageDAO,
                        this, inAppMessage);
                inAppMessageWebView.setWebViewSetting(inAppMessage, inAppMessageWebViewInterface);

                inAppMessageViewWrapper = new InAppMessageViewWrapper(
                        inAppMessage,
                        new InAppMessageViewListener() {
                            @Override
                            public void onClose(Activity attachedActivity, IAMEnums.CloseType action) {
                                AbxLog.i("inAppMessage onClose: "+action, true);
                                inAppMessageViewWrapper.close(attachedActivity);
                            }
                        });
                inAppMessageViewWrapper.setContentView(inAppMessageWebView);
                inAppMessageViewWrapper.open(activity, inAppMessage, false, inAppMessageDAO.getCommonJS());
                open(inAppMessage, isCarried);
            } catch (Exception e) {
                AbxLog.e("createInAppMessage: ", e, true);
                InAppMessageManager.getInstance().close(IAMEnums.CloseType.ERROR);
            }
        });
    }

    private void open(DfnInAppMessage inAppMessage, boolean isCarried) {
        if(isCarried){
            AbxLog.w("send impression is blocked because it is carried.", true);
            return;
        }

        Map<String, Object> eventParam = new HashMap<>();
        try {
            eventParam = CommonUtils.getMapFromJSONObject(inAppMessage.growthEventParam.getJson());
        } catch (Exception e) {
//            AbxLog.w(e, true);
        }

        if (!eventParam.containsKey(ABXConstants.GROWTH_EVENT_KEY_CAMPAIGN_ID)) {
            eventParam.put(CoreConstants.IN_APP_MESSAGE_CAMPAIGN_ID_KEY, inAppMessage.getCampaignId());
        }
        eventParam.put(CoreConstants.IN_APP_MESSAGE_EVENT_TYPE_ABX_KEY, IAMEnums.EventType.IMPRESSION.getValue());

        abxContextController.logEvent(new LogEventParameter(
                CoreConstants.GROUP_ABX,
                CoreConstants.EVENT_IN_APP_MESSAGE,
                CommonUtils.parseValueWithDataType(eventParam, CommonUtils.FixType.PREFIX),
                0,
                0
        ));
    }

    public void loadComplete(){
        AbxLog.d("webViewFactory loadComplete", true);
        if(inAppMessageViewWrapper != null)
            inAppMessageViewWrapper.loadComplete();
        if(type != null && type.equals(InAppMessageManager.STICKY_BANNER)){
            inAppMessageWebView.setStickyAnimation(isCarried, position);
        }
    }

    @Override
    public void dismissInAppMessage(Activity activity, IAMEnums.CloseType closeType) {
        super.dismissInAppMessage(activity, closeType);
        AbxLog.d("webViewFactory dismissInAppMessage", true);
        if(inAppMessageViewWrapper != null)
            inAppMessageViewWrapper.close(activity);
    }
}
