package io.adbrix.sdk.ui.inappmessage;

import static io.adbrix.sdk.domain.IAMConstants.RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Pair;

import com.igaworks.v2.core.AdBrixRm;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.entity.DataUnit;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.CoreConstants;
import io.adbrix.sdk.domain.IAMConstants;
import io.adbrix.sdk.domain.model.DfnIAMTrigger;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.Error;
import io.adbrix.sdk.domain.model.SelfServeInAppMessage;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.Success;
import io.adbrix.sdk.domain.model.Triggers;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;
import io.adbrix.sdk.utils.IoUtils;

public class InAppMessageDAO {
    InAppMessageSqliteStore dbHelper;
    DataRegistry dataRegistry;
    Context context;

    public InAppMessageDAO(Context context, DataRegistry dataRegistry) {
        dbHelper = new InAppMessageSqliteStore(context, dataRegistry);
        this.dataRegistry = dataRegistry;
        this.context = context;
    }

    public InAppMessageDAO(Context context, DataRegistry dataRegistry, InAppMessageSqliteStore dbHelper) {
        this.dbHelper = dbHelper;
        this.dataRegistry = dataRegistry;
        this.context = context;
    }

    public void insertApiResponse2Table(String response, String userId) throws Exception {
        ArrayList<String> responseCampaignIdArrayList = new ArrayList<>();

        JSONObject responseJsonObject = new JSONObject(response);

        JSONObject data = CoreUtils.optJSONObject(responseJsonObject, IAMConstants.RESPONSE_DATA);

        String status = data.optString(IAMConstants.RESPONSE_STATUS);
        String checksum = data.optString(IAMConstants.RESPONSE_CHECKSUM);
        int minutesToExpiry = data.optInt(IAMConstants.RESPONSE_MINUTES_TO_EXPIRY);
        String commonJSUrl = data.optString(IAMConstants.RESPONSE_COMMON_JS_URL);

        if (IAMConstants.CHECKSUM_UNCHANGED.equals(status) || IAMConstants.CHECKSUM_NO_ACTIVE_CAMPAIGN.equals(checksum)) {
            if (IAMConstants.CHECKSUM_UNCHANGED.equals(status))
                AbxLog.d("insertApiResponse2Table: inAppMessage Campaign unchanged", true);
            else
                AbxLog.d("insertApiResponse2Table: No Active Campaign", true);

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_IN_APP_MESSAGE_CHECKSUM,
                    checksum,
                    5,
                    this.getClass().getName(),
                    true
            ));

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.INT_IN_APP_MESSAGE_MINUTES_TO_EXPIRY,
                    minutesToExpiry,
                    5,
                    this.getClass().getName(),
                    true
            ));

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.LONG_IN_APP_MESSAGE_LAST_RESPONSE_TIME,
                    System.currentTimeMillis(),
                    5,
                    this.getClass().getName(),
                    true
            ));

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_IN_APP_MESSAGE_COMMON_JS_URL,
                    commonJSUrl,
                    5,
                    this.getClass().getName(),
                    true
            ));

            return;
        }
        JSONArray inAppMessages = data.optJSONArray(IAMConstants.RESPONSE_IAM);
        deleteBeforeInsertApiResponse();
        for (int inAppMessagesIdx = 0; inAppMessagesIdx < inAppMessages.length(); inAppMessagesIdx++) {
            JSONObject inAppMessage = CoreUtils.optJSONObject(inAppMessages, inAppMessagesIdx);
            JSONObject contents = CoreUtils.optJSONObject(inAppMessage, IAMConstants.RESPONSE_IAM_CONTENTS);
            JSONObject frequencyCap = CoreUtils.optJSONObject(inAppMessage, IAMConstants.RESPONSE_IAM_FREQUENCY_CAP);
            JSONArray triggers = CoreUtils.optJSONArray(inAppMessage, IAMConstants.RESPONSE_IAM_TRIGGERS);
            JSONArray availableTimes = CoreUtils.optJSONArray(inAppMessage, IAMConstants.RESPONSE_IAM_AVAILABLE_TIME);
            JSONObject extConfig = CoreUtils.optJSONObject(inAppMessage, IAMConstants.RESPONSE_IAM_EXT_CONFIG);

            long startDateTime = CoreUtils.getStartDateTimeLong(inAppMessage.optString(IAMConstants.RESPONSE_IAM_START_DATETIME));
            long endDateTime = CoreUtils.getEndDateTimeLong(inAppMessage.optString(IAMConstants.RESPONSE_IAM_END_DATETIME));
            long lastUpdatedDateTime = getLastUpdatedDateTimeLong(inAppMessage.optString(IAMConstants.RESPONSE_IAM_LAST_UPDATED_DATETIME));
            String identifierType = inAppMessage.optString(IAMConstants.RESPONSE_IAM_IDENFITIER_TYPE);

            responseCampaignIdArrayList.add(inAppMessage.optString(IAMConstants.RESPONSE_IAM_CAMPAIGN_ID));

            if (startDateTime == 0 || endDateTime == -1 || lastUpdatedDateTime == 0) {
                AbxLog.d("insertApiResponse2Table: DateTime Parse Error", true);
                return;
            }

            String campaignId = inAppMessage.optString(IAMConstants.RESPONSE_IAM_CAMPAIGN_ID);

            if (campaignId.equals(""))
                continue;
            insertInAppMessageTable(
                    campaignId,
                    identifierType,
                    inAppMessage.optJSONObject(IAMConstants.RESPONSE_IAM_EXT_ATTR) == null ? null : inAppMessage.getJSONObject(IAMConstants.RESPONSE_IAM_EXT_ATTR).toString(),
                    inAppMessage.optInt(IAMConstants.RESPONSE_IAM_TIMEZONE_OFFSET),
                    inAppMessage.optString(IAMConstants.RESPONSE_IAM_TIMEZONE_TYPE),
                    inAppMessage.optString(IAMConstants.RESPONSE_IAM_TYPE),
                    inAppMessage.optJSONObject(IAMConstants.RESPONSE_IAM_POSITION) == null ? null :
                            inAppMessage.getJSONObject(IAMConstants.RESPONSE_IAM_POSITION).getString(IAMConstants.RESPONSE_IAM_POSITION_MOBILE),
                    getHtmlFromContents(contents),
                    contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE) == null ? null : contents.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE).getString(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE_BG_COLOR),
                    contents.optJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE) == null ? null : contents.getJSONObject(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE).getString(IAMConstants.RESPONSE_IAM_CONTENTS_BG_STYLE_OVERLAY_COLOR),
                    frequencyCap.optInt(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_SESSION),
                    frequencyCap.optInt(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_USER),
                    frequencyCap.optJSONObject(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_PERIOD) == null ? 0 : frequencyCap.getJSONObject(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_PERIOD).getInt(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_PERIOD_PERIOD_IN_MINUTES),
                    frequencyCap.optJSONObject(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_PERIOD) == null ? 0 : frequencyCap.getJSONObject(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_PERIOD).getInt(IAMConstants.RESPONSE_IAM_FREQUENCY_CAP_PER_PERIOD_PER_PERIOD),
                    startDateTime,
                    endDateTime,
                    lastUpdatedDateTime,
                    extConfig == null ? null : extConfig.toString()
            );

            for (int triggersIdx = 0; triggersIdx < triggers.length(); triggersIdx++) {
                JSONObject trigger = triggers.getJSONObject(triggersIdx);
                String eventName = trigger.optString(IAMConstants.RESPONSE_IAM_TRIGGERS_EVT);

                insertTriggersTable(
                        campaignId,
                        trigger.optString(IAMConstants.RESPONSE_IAM_TRIGGERS_TYPE),
                        eventName,
                        trigger.optInt(IAMConstants.RESPONSE_IAM_TRIGGERS_PRIORITY),
                        trigger.optString(IAMConstants.RESPONSE_IAM_TRIGGERS_EVT_PROPERTIES),
                        identifierType
                );
            }

            if (availableTimes.length() == 0) {
                insertAvailableTimeTable(
                        campaignId,
                        IAMConstants.AVAILABLE_TIME_ALL,
                        0,
                        0,
                        identifierType
                );
            } else {
                for (int availableTimeIdx = 0; availableTimeIdx < availableTimes.length(); availableTimeIdx++) {
                    JSONObject availableTime = availableTimes.getJSONObject(availableTimeIdx);
                    JSONArray days = availableTime.getJSONArray(IAMConstants.RESPONSE_IAM_AVAILABLE_TIME_DAYS);

                    for (int dayIdx = 0; dayIdx < days.length(); dayIdx++) {
                        insertAvailableTimeTable(
                                campaignId,
                                days.getString(dayIdx),
                                availableTime.getInt(IAMConstants.RESPONSE_IAM_AVAILABLE_TIME_START_MIN),
                                availableTime.getInt(IAMConstants.RESPONSE_IAM_AVAILABLE_TIME_END_MIN),
                                identifierType
                        );
                    }
                }
            }

            if (!isCurrentFrequencyExist(campaignId, identifierType, userId)) {
                insertCurrentFrequencyCapTable(
                        campaignId,
                        0,
                        0,
                        0,
                        0,
                        identifierType,
                        userId,
                        endDateTime
                );
            }
            else{
                // 이미 존재하는 campaignId의 endDateTime만 업데이트.
                updateFrequencyEndTime(campaignId, endDateTime);
            }

            if (!isUnavailableInfoExist(campaignId, identifierType, userId)) {
                insertUnavailableTable(campaignId, identifierType, userId, endDateTime);
            }
            else{
                // 이미 존재하는 campaignId의 endDateTime만 업데이트.
                updateUnavailableEndTime(campaignId, endDateTime);
            }
        }

        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_IN_APP_MESSAGE_CHECKSUM,
                checksum,
                5,
                this.getClass().getName(),
                true
        ));

        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.INT_IN_APP_MESSAGE_MINUTES_TO_EXPIRY,
                minutesToExpiry,
                5,
                this.getClass().getName(),
                true
        ));

        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.LONG_IN_APP_MESSAGE_LAST_RESPONSE_TIME,
                System.currentTimeMillis(),
                5,
                this.getClass().getName(),
                true
        ));

        dataRegistry.putDataRegistry(new DataUnit(
                DataRegistryKey.STRING_IN_APP_MESSAGE_COMMON_JS_URL,
                commonJSUrl,
                5,
                this.getClass().getName(),
                true
        ));

        //deleteStoppedOrDeletedInAppMessage(responseCampaignIdArrayList);
        deleteEndTimeExpiredCampaignFrequency();
    }

    public long getLastUpdatedDateTimeLong(String lastUpdatedDateString) {
        SimpleDateFormat lastUpdatedDateFormat = new SimpleDateFormat(CoreConstants.IAM_LAST_UPDATE_DATE_FORMAT, Locale.US);
        Date lastUpdatedDate;
        try {
            lastUpdatedDate = lastUpdatedDateFormat.parse(lastUpdatedDateString);
        } catch (ParseException e) {
            AbxLog.w("getLastUpdatedDateTimeLong: parse Error", true);
            return 0;
        }

        if (lastUpdatedDate != null) {
            return lastUpdatedDate.getTime();
        }

        return 0;
    }


    public void insertInAppMessageTable(
            String campaignId,
            String identifierType,
            String externalAttr,
            Integer timezoneOffset,
            String timezoneType,
            String type,
            String position,
            String html,
            String bgColor,
            String overlayColor,
            int frequencyCapPerSession,
            int frequencyCapPerUser,
            int frequencyCapForPeriodInMinutes,
            int frequencyCapForPeriodPerPeriod,
            long startDateTime,
            long endDateTime,
            long lastUpdatedDateTime,
            String extConfig
    ) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE, identifierType);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID, campaignId);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR, externalAttr);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_OFFSET, timezoneOffset);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_TYPE, timezoneType);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_POSTION, position);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TYPE, type);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_HTML, html);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_BG_COLOR, bgColor);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_OVERLAY_COLOR, overlayColor);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_SESSION, frequencyCapPerSession);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_USER, frequencyCapPerUser);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES, frequencyCapForPeriodInMinutes);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD, frequencyCapForPeriodPerPeriod);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME, startDateTime);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME, endDateTime);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_LAST_UPDATED_DATETIME, lastUpdatedDateTime);
        contentValues.put(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXT_CONFIG, extConfig);

        long newRowId = db.insertWithOnConflict(InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME, null, contentValues, SQLiteDatabase.CONFLICT_REPLACE);

        if (newRowId == -1)
            AbxLog.d("Insert to InAppMessageTable fail", true);
        else
            AbxLog.d("Insert Success, newRowId in InAppMessageTable : " + newRowId, true);
    }

    public void insertUnavailableTable(
            String campaignId,
            String identifierType,
            String userId,
            long endDateTime
    ) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID, campaignId);
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_DAY, "");
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_TIME, 0);
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_END_DATETIME, endDateTime);
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_IDENTIFIER_TYPE, identifierType);
        if(CommonUtils.isNullOrEmpty(userId)){
            contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_USER_ID, "");
        }
        else {
            contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_USER_ID, userId);
        }

        long newRowId = db.insertWithOnConflict(InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME, null, contentValues, SQLiteDatabase.CONFLICT_REPLACE);

        if (newRowId == -1)
            AbxLog.d("Insert to UnAvailableTimeTable fail", true);
        else
            AbxLog.d("Insert Success, newRowId in UnAvailableTimeTable : " + newRowId, true);
    }

    public void updateOneDayCloseInAppMessageTable(
            String campaignId,
            String unavailableDay,
            long unavailableTime
    ) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_DAY, unavailableDay);
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_TIME, unavailableTime);

        db.update(InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME, contentValues,
                InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + "= ? ", new String[]{campaignId});
    }

    public void insertTriggersTable(
            String campaignId,
            String type,
            String eventName,
            int priority,
            String evtProperties,
            String identifierType
    ) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID, campaignId);
        contentValues.put(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE, type);
        contentValues.put(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME, eventName);
        contentValues.put(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY, priority);
        contentValues.put(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVT_PROPERTIES, evtProperties);
        contentValues.put(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_IDENTIFIER_TYPE, identifierType);

        long newRowId = db.insertWithOnConflict(InAppMessageSqliteStore.TriggersTable.TABLE_NAME, null, contentValues, SQLiteDatabase.CONFLICT_REPLACE);

        if (newRowId == -1)
            AbxLog.d("Insert to TriggersTable fail", true);
        else
            AbxLog.d("Insert Success, newRowId in TriggersTable : " + newRowId, true);
    }

    public void insertAvailableTimeTable(
            String campaignId,
            String day,
            int startMin,
            int endMin,
            String identifierType
    ) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID, campaignId);
        contentValues.put(InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_DAY, day);
        contentValues.put(InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_START_MIN, startMin);
        contentValues.put(InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_END_MIN, endMin);
        contentValues.put(InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_IDENTIFIER_TYPE, identifierType);
        long newRowId = db.insertWithOnConflict(InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME, null, contentValues, SQLiteDatabase.CONFLICT_REPLACE);

        if (newRowId == -1)
            AbxLog.d("insert to AvailableTimeTable fail", true);
        else
            AbxLog.d("Insert Success, newRowId in AvailableTimeTable : " + newRowId, true);
    }

    public void insertCurrentFrequencyCapTable(
            String campaignId,
            int capPerSession,
            int capPerUser,
            long lastGroupStartTime,
            int lastGroupCount,
            String identifierType,
            String userId,
            long endDateTime
    ) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID, campaignId);
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION, capPerSession);
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER, capPerUser);
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME, lastGroupStartTime);
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT, lastGroupCount);
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_IDENTIFIER_TYPE, identifierType);
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_END_DATETIME, endDateTime);
        if(CommonUtils.isNullOrEmpty(userId)){
            contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID, "");
        }
        else {
            contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID, userId);
        }

        long newRowId = db.insertWithOnConflict(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME, null, contentValues, SQLiteDatabase.CONFLICT_REPLACE);

        if (newRowId == -1)
            AbxLog.d("insert to CurrentFrequencyCapTable fail", true);
        else
            AbxLog.d("Insert Success, newRowId in CurrentFrequencyCapTable : " + newRowId, true);
    }

    public void updateFrequencyEndTime(String campaignId, long endDateTime) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_END_DATETIME, endDateTime);
        int updateResult = db.update(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME, contentValues, InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);

        if (updateResult == -1) {
            AbxLog.d("updateFrequencyEndTime Fail!", true);
        } else {
            AbxLog.d("updateFrequencyEndTime SUCCESS", true);
        }
    }

    public void deleteInAppMessageTable(String campaignId) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME, InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);

        AbxLog.d("deleteInAppMessageTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllInAppMessageTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME, null, null);

        AbxLog.d("deleteAllInAppMessageTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllUserInAppMessageTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME, InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE + "=?", new String[] {RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE});

        AbxLog.d("deleteAllUserInAppMessageTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAvailableTimeTable(String campaignId) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME, InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);


        AbxLog.d("deleteAvailableTimeTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllAvailableTimeTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME, null, null);


        AbxLog.d("deleteAllAvailableTimeTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllUserAvailableTimeTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME, InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_IDENTIFIER_TYPE + "=?", new String[] {RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE});


        AbxLog.d("deleteAllUserAvailableTimeTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteTriggersTable(String campaignId) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.TriggersTable.TABLE_NAME, InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);


        AbxLog.d("deleteTriggersTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllTriggersTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.TriggersTable.TABLE_NAME, null, null);


        AbxLog.d("deleteAllTriggersTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllUserTriggersTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.TriggersTable.TABLE_NAME, InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_IDENTIFIER_TYPE + "=?", new String[] {RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE});


        AbxLog.d("deleteAllUserTriggersTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteCurrentFrequencyCapTable(String campaignId) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME, InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);


        AbxLog.d("deleteCurrentFrequencyCapTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteAllCurrentFrequencyCapTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME, null, null);

        AbxLog.d("deleteAllCurrentFrequencyCapTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteEndTimeExpiredCampaignFrequency(){
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        long expiredCheckTimeMillis = System.currentTimeMillis() - (24 * 3600 * 1000 * 10); // 10일
        AbxLog.d("deleteAllCurrentFrequencyCapTable: expiredCheckTimeMillis = " + expiredCheckTimeMillis, true);

        // Delete unavailable
        int deletedRowCount = db.delete(InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME,
                InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_END_DATETIME + "<= " + expiredCheckTimeMillis + "",
                null);

        AbxLog.d("deleteEndTimeExpiredCampaignFrequency: Deleted unavailable row count = " + deletedRowCount, true);

        // Delete frequency
        deletedRowCount = db.delete(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME,
                InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_END_DATETIME + "<= " + expiredCheckTimeMillis + "",
                null);
        AbxLog.d("deleteEndTimeExpiredCampaignFrequency: Deleted frequency row count = " + deletedRowCount, true);

    }

    public void deleteUnavailableTable(String campaignId) {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME, InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);


        AbxLog.d("deleteUnavailableTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteUserUnavailableTable() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        int deletedRowCount = db.delete(InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME, InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_IDENTIFIER_TYPE + "=?", new String[] {RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE});


        AbxLog.d("deleteUserUnavailableTable: Deleted row count = " + deletedRowCount, true);
    }

    public void deleteCampaign(String campaignId) {
        deleteInAppMessageTable(campaignId);
        deleteAvailableTimeTable(campaignId);
        deleteTriggersTable(campaignId);
        deleteCurrentFrequencyCapTable(campaignId);
        deleteUnavailableTable(campaignId);
    }

    public void deleteBeforeInsertApiResponse() {
        deleteAllInAppMessageTable();
        deleteAllTriggersTable();
        deleteAllAvailableTimeTable();
    }

    public void deleteAllInAppMessageDBContents() {
        try {
            deleteAllInAppMessageTable();
            deleteAllTriggersTable();
            deleteAllAvailableTimeTable();
            deleteAllCurrentFrequencyCapTable();

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.INT_IN_APP_MESSAGE_MINUTES_TO_EXPIRY,
                    0,
                    5,
                    this.getClass().getName(),
                    true
            ));

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_IN_APP_MESSAGE_CHECKSUM,
                    null,
                    5,
                    this.getClass().getName(),
                    true
            ));
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    public void deleteAllUserInAppMessageDBContents() {
        try {
            AbxLog.w("deleteAllUserInAppMessageDBContents", false);
            deleteAllUserInAppMessageTable();
            deleteAllUserTriggersTable();
            deleteAllUserAvailableTimeTable();

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.INT_IN_APP_MESSAGE_MINUTES_TO_EXPIRY,
                    0,
                    5,
                    this.getClass().getName(),
                    true
            ));

            dataRegistry.putDataRegistry(new DataUnit(
                    DataRegistryKey.STRING_IN_APP_MESSAGE_CHECKSUM,
                    null,
                    5,
                    this.getClass().getName(),
                    true
            ));
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
    }

    public void deleteStoppedOrDeletedInAppMessage(List<String> responseCampaignIdArrayList) {
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String getCampaignIdFromCurrentFrequencyCapTableQuery = "SELECT " + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID
                + " FROM " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME;

        Cursor cursor = db.rawQuery(getCampaignIdFromCurrentFrequencyCapTableQuery, null);

        while (cursor.moveToNext()) {
            String campaignId = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID));

            if (!responseCampaignIdArrayList.contains(campaignId)) {
                deleteCampaign(campaignId);
            }
        }
        IoUtils.close(cursor);
    }

    public void restartInAppMessage() {
        dbHelper.restartDB();
    }

    public boolean isCampaignIdTimeAvailable(String campaignId) {
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String userId = AdBrixRm.getUserId();

        String getTimeInfoQuery = "SELECT " + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_OFFSET + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_TYPE + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME
                + " FROM " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME
                + " WHERE " + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'";

        long startDateTime;
        long endDateTime;
        String timezoneType;
        int timezoneOffset;
        String currentDay = null;
        String currentMin = "";
        long currentTimeMillis = System.currentTimeMillis();
        String unavailableDay = null;
        long unavailableTime = 0;

        Cursor getTimeCursor = db.rawQuery(getTimeInfoQuery, null);

        String getUnavailableQuery = "SELECT " + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_DAY + ", "
                + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_TIME  + ", "
                + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_IDENTIFIER_TYPE  + ", "
                + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_USER_ID
                + " FROM " + InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME
                + " WHERE " + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'";

        Cursor unavailableCursor = db.rawQuery(getUnavailableQuery, null);

        while(unavailableCursor.moveToNext()){
            String identifierType = unavailableCursor.getString(unavailableCursor.getColumnIndex(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_IDENTIFIER_TYPE));
            String unavailableUserId = unavailableCursor.getString(unavailableCursor.getColumnIndex(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_USER_ID));
            if(identifierType.equals(RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE)){
                if (userId != null && userId.equals(unavailableUserId)) {
                    unavailableDay = unavailableCursor.getString(unavailableCursor.getColumnIndex(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_DAY));
                    unavailableTime = unavailableCursor.getLong(unavailableCursor.getColumnIndex(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_TIME));
                }
            }
            else{
                unavailableDay = unavailableCursor.getString(unavailableCursor.getColumnIndex(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_DAY));
                unavailableTime = unavailableCursor.getLong(unavailableCursor.getColumnIndex(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_UNAVAILABLE_TIME));
            }
        }

        boolean isAvailable = false;
        try {
            if (getTimeCursor.moveToNext()) {
                startDateTime = getTimeCursor.getLong(getTimeCursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME));
                endDateTime = getTimeCursor.getLong(getTimeCursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME));
                timezoneType = getTimeCursor.getString(getTimeCursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_TYPE));
                timezoneOffset = getTimeCursor.getInt(getTimeCursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_OFFSET));


                if (timezoneType.equals(IAMConstants.TIMEZONE_GLOBAL)) {
                    Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    SimpleDateFormat utcSimpleDateFormat = new SimpleDateFormat("EE", Locale.ENGLISH);
                    utcSimpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));

                    currentDay = utcSimpleDateFormat.format(System.currentTimeMillis() + timezoneOffset * 3600 * 1000);
                    currentMin = Integer.toString((utcCalendar.get(Calendar.MINUTE) + (utcCalendar.get(Calendar.HOUR_OF_DAY) + timezoneOffset) * 60) % 1440);
                } else if (timezoneType.equals(IAMConstants.TIMEZONE_LOCAL)) {
                    Calendar localCalendar = Calendar.getInstance();
                    SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("EE", Locale.ENGLISH);

                    currentDay = localSimpleDateFormat.format(System.currentTimeMillis());
                    currentMin = Integer.toString(localCalendar.get(Calendar.MINUTE) + localCalendar.get(Calendar.HOUR_OF_DAY) * 60);
                } else {
                    throw new Exception("isCampaignIdTimeAvailable: invalid timezoneOffset: " + timezoneOffset);
                }
                //one day close check
                if (currentDay.equals(unavailableDay)) {
                    throw new Exception("isCampaignIdTimeAvailable: one day close ");
                } else {
                    updateOneDayCloseInAppMessageTable(campaignId, "", 0);
                }

                //start, end time available check
                if (currentTimeMillis < startDateTime) {
                    throw new Exception("isCampaignIdTimeAvailable: currentTimeMillis is earlier than startDateTime");
                } else if (endDateTime < currentTimeMillis && endDateTime != 0) {
                    //deleteCampaign(campaignId);
                    throw new Exception("isCampaignIdTimeAvailable: currentTimeMillis over endDateTime");
                }
            } else {
                throw new Exception("isCampaignIdTimeAvailable: campaignId dateTime inAvailable");
            }
            if (currentDay.equals("Thu")) {
                currentDay = "Thur";
            }

            AbxLog.d("currentDay: " + currentDay + ", currentMin: " + currentMin, true);

            String isCampaignIdValidQuery = "SELECT * FROM "
                    + InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME
                    + " WHERE " + InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME + "." + InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "' "
                    + " AND (" + InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME + "." + InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_DAY + " = '" + currentDay + "'"
                    + " AND " + InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME + "." + InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_START_MIN + " <= " + currentMin
                    + " AND " + InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME + "." + InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_END_MIN + " >= " + currentMin
                    + " OR " + InAppMessageSqliteStore.AvailableTimeTable.TABLE_NAME + "." + InAppMessageSqliteStore.AvailableTimeTable.COLUMN_NAME_DAY + " = '" + IAMConstants.AVAILABLE_TIME_ALL + "')";

            Cursor cursor = db.rawQuery(isCampaignIdValidQuery, null);
            isAvailable = cursor.moveToNext();
            IoUtils.close(cursor);
        }catch (Exception e){
            AbxLog.w(e.toString(), true);
        }finally {
            IoUtils.close(getTimeCursor);
            IoUtils.close(unavailableCursor);
        }
        return isAvailable;
    }

    public boolean isCampaignIdFrequencyAvailable(String campaignId) {
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String userId = AdBrixRm.getUserId();
        String isCampaignIdFrequencyAvailableQuery = "SELECT " + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_SESSION + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_USER
                + " FROM " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME
                + " JOIN " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME
                + " ON " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME + "." + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID
                + " = " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID
                + " WHERE " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME + "." + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "' "
                + " AND (" + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME + "." + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION + " "
                + " < " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_SESSION
                + " OR " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_SESSION + " = 0" //0일 경우 무제한 노출
                + " )";

        AbxLog.d("isCampaignIdFrequencyAvailableQuery: " + isCampaignIdFrequencyAvailableQuery, true);
        Cursor cursor = db.rawQuery(isCampaignIdFrequencyAvailableQuery, null);

        boolean isAvailable = false;
        try {
            while (cursor.moveToNext()) {
                long lastGroupStartTime = cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME));
                int lastGroupCount = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT));
                int currentPerUser = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER));

                int periodInMinutes = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES));
                int periodPerPeriod = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD));
                int perUser = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_USER));
                long currentTimeInMillis = System.currentTimeMillis();

                String identifierType = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE));
                String frequencyUserId = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID));

                if (identifierType != null && identifierType.equals(RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE)) {
                    if (userId != null && userId.equals(frequencyUserId)) {
                        //perUser valid check
                        if (perUser != 0 && currentPerUser >= perUser) {
                            throw new Exception("isCampaignIdFrequencyAvailable: frequency perUser is invalid");
                        }

                        //perPeriod valid check
                        if (periodPerPeriod == 0) { //0일 경우 무제한 노출
                            isAvailable = true;
                            throw new Exception("isCampaignIdFrequencyAvailable: frequency is valid");
                        } else if (lastGroupStartTime + periodInMinutes * 60 * 1000 < currentTimeInMillis) {
                            isAvailable = true;
                            throw new Exception("isCampaignIdFrequencyAvailable: frequency is valid");
                        } else if (lastGroupCount < periodPerPeriod) {
                            isAvailable = true;
                            throw new Exception("isCampaignIdFrequencyAvailable: frequency is valid");
                        } else {
                            throw new Exception("isCampaignIdFrequencyAvailable: frequency period is invalid");
                        }
                    }
                }
                else{
                    //perUser valid check
                    if (perUser != 0 && currentPerUser >= perUser) {
                        throw new Exception("isCampaignIdFrequencyAvailable: frequency perUser is invalid");
                    }

                    //perPeriod valid check
                    if (periodPerPeriod == 0) { //0일 경우 무제한 노출
                        isAvailable = true;
                        throw new Exception("isCampaignIdFrequencyAvailable: frequency is valid");
                    } else if (lastGroupStartTime + periodInMinutes * 60 * 1000 < currentTimeInMillis) {
                        isAvailable = true;
                        throw new Exception("isCampaignIdFrequencyAvailable: frequency is valid");
                    } else if (lastGroupCount < periodPerPeriod) {
                        isAvailable = true;
                        throw new Exception("isCampaignIdFrequencyAvailable: frequency is valid");
                    } else {
                        throw new Exception("isCampaignIdFrequencyAvailable: frequency period is invalid");
                    }
                }
            }
        }catch (Exception e){
            AbxLog.w(e.toString(), true);
        }finally {
            IoUtils.close(cursor);
        }
        if(isAvailable){
            return true;
        } else{
            return false;
        }
    }

    public void increaseFrequencyByCampaignId(String campaignId){
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String userId = AdBrixRm.getUserId();

        String isCampaignIdFrequencyAvailableQuery = "SELECT " + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER + ", "
                + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_USER + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME + ", "
                + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE
                + " FROM " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME
                + " JOIN " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME
                + " ON " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME + "." + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID
                + " = " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID
                + " WHERE " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME + "." + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "' "
                + " AND (" + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME + "." + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION + " "
                + " < " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_SESSION
                + " OR " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_PER_SESSION + " = 0" //0일 경우 무제한 노출
                + " )";

        AbxLog.d("increaseFrequencyByCampaignId: " + isCampaignIdFrequencyAvailableQuery, true);
        Cursor cursor = db.rawQuery(isCampaignIdFrequencyAvailableQuery, null);
        while (cursor.moveToNext()) {
            long lastGroupStartTime = cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_START_TIME));
            int lastGroupCount = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_FREQUENCY_LAST_GROUP_COUNT));
            int currentSessionCount = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION));
            int currentUserCount = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER));
            int periodInMinutes = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_IN_MINUTES));
            int periodPerPeriod = cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_FREQUENCY_CAP_FOR_PERIOD_PER_PERIOD));
            String identifierType = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE));
            long endDateTime = cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME));
            long currentTimeInMillis = System.currentTimeMillis();
            String frequencyUserId = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID));

            if (identifierType != null && identifierType.equals(RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE)) {
                if (userId != null && userId.equals(frequencyUserId)) {
                    //perperiod valid check
                    if (periodPerPeriod == 0) { //0일 경우 무제한 노출
                        insertCurrentFrequencyCapTable(campaignId, currentSessionCount + 1, currentUserCount + 1, currentTimeInMillis, lastGroupCount + 1, identifierType, userId, endDateTime);
                    } else if (lastGroupStartTime + periodInMinutes * 60 * 1000 < currentTimeInMillis) {
                        insertCurrentFrequencyCapTable(campaignId, currentSessionCount + 1, currentUserCount + 1, currentTimeInMillis, 1, identifierType, userId, endDateTime);
                    } else if (lastGroupCount < periodPerPeriod) {
                        insertCurrentFrequencyCapTable(campaignId, currentSessionCount + 1, currentUserCount + 1, lastGroupStartTime, lastGroupCount + 1, identifierType, userId, endDateTime);
                    }
                }
            } else {
                //perperiod valid check
                if (periodPerPeriod == 0) { //0일 경우 무제한 노출
                    insertCurrentFrequencyCapTable(campaignId, currentSessionCount + 1, currentUserCount + 1, currentTimeInMillis, lastGroupCount + 1, identifierType, null, endDateTime);
                } else if (lastGroupStartTime + periodInMinutes * 60 * 1000 < currentTimeInMillis) {
                    insertCurrentFrequencyCapTable(campaignId, currentSessionCount + 1, currentUserCount + 1, currentTimeInMillis, 1, identifierType, null, endDateTime);
                } else if (lastGroupCount < periodPerPeriod) {
                    insertCurrentFrequencyCapTable(campaignId, currentSessionCount + 1, currentUserCount + 1, lastGroupStartTime, lastGroupCount + 1, identifierType, null, endDateTime);
                }
            }

        }
        IoUtils.close(cursor);
    }

    public boolean isCurrentFrequencyExist(String campaignId, String identifierType, String userId) {
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String isCurrentFrequencyExistQuery = "SELECT * FROM " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME
                + " WHERE " + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'";
        if(identifierType.equals(RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE)){
            isCurrentFrequencyExistQuery = "SELECT * FROM " + InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME
                    + " WHERE " + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'"
                    + " AND " + InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_USER_ID + " = '" + userId + "'";
        }
        AbxLog.d("isCurrentFrequencyExistQuery: " + isCurrentFrequencyExistQuery, true);
        Cursor cursor = db.rawQuery(isCurrentFrequencyExistQuery, null);
        boolean isExist = cursor.moveToNext();
        IoUtils.close(cursor);
        return isExist;
    }

    public boolean isUnavailableInfoExist(String campaignId, String identifierType, String userId) {
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String isUnavailableInfoExistQuery = "SELECT * FROM " + InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME
                + " WHERE " + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'";

        if(identifierType.equals(RESPONSE_IAM_IDENTIFIER_USER_ID_TYPE)){
            isUnavailableInfoExistQuery = "SELECT * FROM " + InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME
                    + " WHERE " + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'"
                    + " AND " + InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_USER_ID + " = '" + userId + "'";
        }
        AbxLog.d("isUnavailableInfoExist: " + isUnavailableInfoExistQuery, true);
        Cursor cursor = db.rawQuery(isUnavailableInfoExistQuery, null);
        boolean isExist = cursor.moveToNext();
        IoUtils.close(cursor);
        return isExist;
    }

    public void updateUnavailableEndTime(String campaignId, long endDateTime){
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_END_DATETIME, endDateTime);
        int updateResult = db.update(InAppMessageSqliteStore.UnAvailableTimeTable.TABLE_NAME, contentValues, InAppMessageSqliteStore.UnAvailableTimeTable.COLUMN_NAME_CAMPAIGN_ID + "= '" + campaignId + "'", null);

        if (updateResult == -1) {
            AbxLog.d("updateUnavailableEndTime Fail!", true);
        } else {
            AbxLog.d("updateUnavailableEndTime SUCCESS", true);
        }
    }

    public void resetFrequencyCapPerSession() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_SESSION, 0);
        int updateResult = db.update(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME, contentValues, null, null);

        if (updateResult == -1) {
            AbxLog.d("resetFrequencyCapPerSessionQuery: resetFrequencyCapPerSession Fail!", true);
        } else {
            AbxLog.d("resetFrequencyCapPerSessionQuery: resetFrequencyCapPerSession SUCCESS", true);
        }
    }

    public void resetFrequencyCapPerUser() {
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        ContentValues contentValues = new ContentValues();
        contentValues.put(InAppMessageSqliteStore.CurrentFrequencyCapTable.COLUMN_NAME_CURRENT_FREQUENCY_CAP_PER_USER, 0);
        int updateResult = db.update(InAppMessageSqliteStore.CurrentFrequencyCapTable.TABLE_NAME, contentValues, null, null);

        if (updateResult == -1) {
            AbxLog.d("resetFrequencyCapPerSessionQuery: resetFrequencyCapPerSession Fail!", true);
        } else {
            AbxLog.d("resetFrequencyCapPerSessionQuery: resetFrequencyCapPerSession SUCCESS", true);
        }
    }

    public DfnInAppMessage getInAppMessageByEventName(String triggeredEventName) {
        HashMap<String, Pair<Long, Long>> triggeredCampaignIdMap = getCampaignIdFromTriggerEventName(triggeredEventName);

        for (String campaignId : sortMapByValue(triggeredCampaignIdMap)) {
            if (!isCampaignIdTimeAvailable(campaignId))
                continue;

            DfnInAppMessage inAppMessage = getInAppMessageByCampaignId(campaignId);

            if (inAppMessage == null) {
                AbxLog.d("getInAppMessageByCampaignId Fail, campaignId = " + campaignId, true);
            } else {

                if (!isCampaignIdFrequencyAvailable(campaignId))
                    continue;

                AbxLog.d("getInAppMessageByCampaignId Success, campaignId = " + campaignId, true);

                return inAppMessage;
            }
        }

        AbxLog.d("getInAppMessageByCampaignId Fail, No Valid InAppMessage", true);

        return null;
    }

    public DfnInAppMessage getInAppMessageByEventNameWithParam(String triggeredEventName, JSONObject eventParam) {
        HashMap<Triggers, Pair<Long, Long>> triggersHashMap = getTriggersByEventName(triggeredEventName);
        ArrayList<Triggers> triggersList = sortTriggersMapByValue(triggersHashMap);
        if(CommonUtils.isNullOrEmpty(triggersList)){
            return null;
        }
        List<Triggers> validTriggerList = new ArrayList<>();
        for(Triggers triggers : triggersList){
            if(triggers.isValidByEventProperties(eventParam)){
                validTriggerList.add(triggers);
            }
        }
        if(CommonUtils.isNullOrEmpty(validTriggerList)){
            return null;
        }
        for(Triggers triggers : validTriggerList){
            String campaignId = triggers.getCampaignId();
            if (!isCampaignIdTimeAvailable(campaignId)) {
                continue;
            }
            if (!isCampaignIdFrequencyAvailable(campaignId)){
                continue;
            }
            DfnInAppMessage inAppMessage = getInAppMessageByCampaignId(campaignId);
            return inAppMessage;
        }

        return null;
    }

    public HashMap<Triggers, Pair<Long, Long>> getTriggersByEventName(String triggeredEventName) {
        HashMap<Triggers, Pair<Long, Long>> triggersHashMap = new HashMap<>();
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        String getCampaignIdQuery = "SELECT "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVT_PROPERTIES + ", "
                + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_LAST_UPDATED_DATETIME
                + " FROM " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME
                + " JOIN " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME
                + " ON " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID
                + " = " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID
                + " WHERE " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME + " = '" + triggeredEventName + "'"
                + " AND " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE + " = 'inappevent'";
        AbxLog.d("getTriggersByEventName query:" + getCampaignIdQuery, true);
        Cursor cursor = db.rawQuery(getCampaignIdQuery, null);
        while (cursor.moveToNext()) {
            triggersHashMap.put(new Triggers(cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME)),
                    cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVT_PROPERTIES)),
                    cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_LAST_UPDATED_DATETIME))),
                    new Pair<>(
                            cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY)),
                            cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_LAST_UPDATED_DATETIME)))
                    );
        }
        IoUtils.close(cursor);
        return triggersHashMap;
    }

    public HashMap<String, Pair<Long, Long>> getCampaignIdFromTriggerEventName(String triggeredEventName) {
        HashMap<String, Pair<Long, Long>> campaignIdHashMap = new HashMap<>();

        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String getCampaignIdWithPriority = "SELECT "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY + ", "
                + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_LAST_UPDATED_DATETIME
                + " FROM " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME
                + " JOIN " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME
                + " ON " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID
                + " = " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID
                + " WHERE " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME + " = '" + triggeredEventName + "'"
                + " AND " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE + " = 'inappevent'";

        AbxLog.d("getCampaignIdFromTriggerEventName query:" + getCampaignIdWithPriority, true);

        Cursor cursor = db.rawQuery(getCampaignIdWithPriority, null);

        while (cursor.moveToNext()) {
            campaignIdHashMap.put(
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID)),
                    new Pair<>(
                            cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY)),
                            cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_LAST_UPDATED_DATETIME))
                    )
            );
        }

        IoUtils.close(cursor);
        return campaignIdHashMap;
    }

    public Result<List<DfnInAppMessage>> getAllInAppMessage() {

        List<DfnInAppMessage> inAppMessages = new ArrayList<>();
        try {
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            String[] projection = {
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_OFFSET,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_TYPE,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TYPE,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_POSTION,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_HTML,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_BG_COLOR,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_OVERLAY_COLOR,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXT_CONFIG,
                    InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE
            };

            Cursor cursor = db.query(
                    InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME,
                    projection,
                    null,
                    null,
                    null,
                    null,
                    null
            );

            while (cursor.moveToNext()) {
                String campaignId = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID));

                DfnInAppMessage inAppMessage = new DfnInAppMessage(
                        campaignId,
                        cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TYPE)),
                        cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_POSTION)),
                        cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE)),
                        cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_HTML)),
                        cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_BG_COLOR)),
                        cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_OVERLAY_COLOR)),
                        cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME)),
                        cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME)),
                        CommonUtils.convertNullStringToNull(cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR))),
                        CommonUtils.convertNullStringToNull(cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXT_CONFIG))),
                        getTriggers(campaignId)
                );

                inAppMessages.add(inAppMessage);
            }

            IoUtils.close(cursor);

            return Success.of(inAppMessages);
        } catch (Exception e) {
            return Error.of(e);
        }
    }

    public List<SelfServeInAppMessage> getSelfServeInAppMessages() {
        List<SelfServeInAppMessage> inAppMessages = new ArrayList<>();
        try {
            SQLiteDatabase db = dbHelper.getReadableDatabase();
            String isCampaignIdFrequencyAvailableQuery = "SELECT "
                    + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME+"."+InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID + ", "
                    + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME+"."+InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR
                    + " FROM " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME
                    + " JOIN " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME
                    + " ON " + InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME + "." + InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID
                    + " = " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID
                    + " WHERE " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE + " = '" + InAppMessageSqliteStore.TriggersTable.TYPE_SELF_TRIGGER + "' ";
            AbxLog.d("getAllSelfServeInAppMessages: " + isCampaignIdFrequencyAvailableQuery, true);
            Cursor cursor = db.rawQuery(isCampaignIdFrequencyAvailableQuery, null);

            while (cursor.moveToNext()) {
                String campaignId = cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID));
                SelfServeInAppMessage inAppMessage = new SelfServeInAppMessage(campaignId, CommonUtils.convertNullStringToNull(cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR))));
                inAppMessages.add(inAppMessage);
            }

            IoUtils.close(cursor);
        } catch (Exception e) {
            AbxLog.e(e, true);
        }
        return inAppMessages;
    }

    public DfnInAppMessage getInAppMessageByCampaignId(String campaignId) {
        DfnInAppMessage inAppMessage = null;

        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String[] projection = {
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_OFFSET,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TIMEZONE_TYPE,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TYPE,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_POSTION,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_HTML,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_BG_COLOR,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_OVERLAY_COLOR,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXT_CONFIG,
                InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE,
        };

        String selection = InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_CAMPAIGN_ID + " = ? ";
        String[] selectionArgs = {campaignId};

        Cursor cursor = db.query(
                InAppMessageSqliteStore.InAppMessageTable.TABLE_NAME,
                projection,
                selection,
                selectionArgs,
                null,
                null,
                null
        );

        if (cursor.moveToNext()) {
            inAppMessage = new DfnInAppMessage(
                    campaignId,
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_TYPE)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_POSTION)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_IDENTIFIER_TYPE)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_HTML)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_BG_COLOR)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_BG_STYLE_OVERLAY_COLOR)),
                    cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_START_DATETIME)),
                    cursor.getLong(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_END_DATETIME)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXTERNAL_ATTR)),
                    cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.InAppMessageTable.COLUMN_NAME_EXT_CONFIG)),
                    new ArrayList<>()
            );
        }

        IoUtils.close(cursor);

        return inAppMessage;
    }

    public void closeDataBase() {
        dbHelper.getWritableDatabase().close();
    }

    public ArrayList<String> sortMapByValue(final HashMap<String, Pair<Long, Long>> map) {
        ArrayList<String> list = new ArrayList<>(map.keySet());
        Collections.sort(list, (key1, key2) -> {
            Pair<Long, Long> value1 = map.get(key1);
            Pair<Long, Long> value2 = map.get(key2);

            if (value1 == null || value2 == null) {
                AbxLog.e("sorMapByValue null value error", true);
                return 1;
            }

            if (value1.first.equals(value2.first)) {
                if (value1.second < value2.second)
                    return 1;
                else
                    return -1;
            } else {
                if (value1.first < value2.first)
                    return 1;
                else
                    return -1;
            }
        });
        return list;
    }

    public ArrayList<Triggers> sortTriggersMapByValue(final HashMap<Triggers, Pair<Long, Long>> map) {
        ArrayList<Triggers> list = new ArrayList<>(map.keySet());
        Collections.sort(list, (key1, key2) -> {
            Pair<Long, Long> value1 = map.get(key1);
            Pair<Long, Long> value2 = map.get(key2);

            if (value1 == null || value2 == null) {
                AbxLog.e("sorMapByValue null value error", true);
                return 1;
            }

            if (value1.first.equals(value2.first)) {
                if (value1.second < value2.second)
                    return 1;
                else
                    return -1;
            } else {
                if (value1.first < value2.first)
                    return 1;
                else
                    return -1;
            }
        });
        return list;
    }

    public List<DfnIAMTrigger> getTriggers(String campaignId) {
        List<DfnIAMTrigger> triggers = new ArrayList<>();

        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String getTriggersQuery = "SELECT "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME + ", "
                + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY
                + " FROM " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME
                + " WHERE " + InAppMessageSqliteStore.TriggersTable.TABLE_NAME + "." + InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_CAMPAIGN_ID + " = '" + campaignId + "'";

        AbxLog.d("getTriggers query:" + getTriggersQuery, true);

        try (Cursor cursor = db.rawQuery(getTriggersQuery, null)) {
            while (cursor.moveToNext()) {
                triggers.add(
                        new DfnIAMTrigger(
                                cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_TYPE)),
                                CommonUtils.convertNullStringToNull(cursor.getString(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_EVENT_NAME))),
                                cursor.getInt(cursor.getColumnIndex(InAppMessageSqliteStore.TriggersTable.COLUMN_NAME_PRIORITY))
                        )
                );
            }

            return triggers;
        } catch (Exception e) {
            return triggers;
        }
    }
    public String getCommonJS(){
        String commonJS = dataRegistry.safeGetString(DataRegistryKey.STRING_IN_APP_MESSAGE_COMMON_JS_URL, "");
        return commonJS;
    }
    private String getHtmlFromContents(JSONObject contents) throws JSONException {
        String result = "";
        if(CommonUtils.isNullOrEmpty(contents)){
            return result;
        }
        if(!contents.has(IAMConstants.RESPONSE_IAM_HTML)){
            return result;
        }
        result = (String)contents.get(IAMConstants.RESPONSE_IAM_HTML);
        result = result.replace("\n", "<br>");
        return result;
    }
}
