package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.function.Completion;
import io.adbrix.sdk.domain.model.Response;
import io.adbrix.sdk.domain.model.Result;

public class LogoutUseCase  implements UseCase<Void>{
    private Repository repository;
    private Completion<Result<Response>> completion;

    public LogoutUseCase(Repository repository, Completion<Result<Response>> completion) {
        this.repository = repository;
        this.completion = completion;
    }

    @Override
    public Void execute() {
        repository.logout(completion);
        return null;
    }
}
