package io.adbrix.sdk.domain.interactor;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.Repository;

public class SetCiPropertyUseCase implements UseCase<Void>{
    private final String key;
    private final String value;
    private final AdBrixRm.SetCiProfileCallback callback;
    private final DataRegistry dataRegistry;
    private final Repository repository;

    public SetCiPropertyUseCase(String key, String value, AdBrixRm.SetCiProfileCallback callback, DataRegistry dataRegistry, Repository repository) {
        this.key = key;
        this.value = value;
        this.callback = callback;
        this.dataRegistry = dataRegistry;
        this.repository = repository;
    }

    @Override
    public Void execute() {
        repository.setCiProperty(key, value, callback, dataRegistry);
        return null;
    }
}
