package io.adbrix.sdk.component;

import android.os.Handler;
import android.os.Looper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InAppMessageClickPostingObservable implements IObservable<HashMap<String, Object>> {
    public static final String ACTION_ID = "actionId";
    public static final String ACTION_TYPE = "actionType";
    public static final String ACTION_ARG = "actionArg";
    public static final String IS_CLOSED = "isClosed";
    private List<IObserver<HashMap<String, Object>>> observers = new ArrayList<>();
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    private InAppMessageClickPostingObservable() {
    }

    public static InAppMessageClickPostingObservable getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void add(IObserver<HashMap<String, Object>> observer) {
        observers.add(observer);
    }

    @Override
    public void delete(IObserver<HashMap<String, Object>> observer) {
        observers.remove(observer);
    }

    @Override
    public void notifyObserver(HashMap<String, Object> clickInformation) {
        for (IObserver<HashMap<String, Object>> observer : observers) {
            observer.update(clickInformation);
        }
    }

    @Override
    public void clear() {
        observers.clear();
    }

    public void postInAppMessageClickToMainThread(
            String actionId,
            String actionType,
            String actionArg,
            boolean isClosed
    ) {
        HashMap<String, Object> clickInformation = new HashMap<>();
        clickInformation.put(ACTION_ID, actionId);
        clickInformation.put(ACTION_TYPE, actionType);
        clickInformation.put(ACTION_ARG, actionArg);
        clickInformation.put(IS_CLOSED, isClosed);

        mainThreadHandler.post(() -> notifyObserver(clickInformation));
    }

    private static class Singleton {
        private static final InAppMessageClickPostingObservable INSTANCE = new InAppMessageClickPostingObservable();
    }
}
