package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.CoreConstants;

public class InAppMessageApiModel implements IApiModel {
    private final IDataModel commonModel;
    private final String checksum;
    private final String userId;

    public InAppMessageApiModel(
            IDataModel commonModel,
            String checksum,
            String userId
    ) {
        this.commonModel = commonModel;
        this.checksum = checksum;
        this.userId = userId;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject root = new NullableJSONObject();

        NullableJSONObject inAppMessageJSONObject = new NullableJSONObject();
        inAppMessageJSONObject.put("checksum", checksum);
        inAppMessageJSONObject.put("user_id", userId == null ? JSONObject.NULL : userId);
        inAppMessageJSONObject.put("max_touch_points", 0);

        root.put("common", commonModel.getJson());
        root.put("in_app_message", inAppMessageJSONObject);
        return root;
    }

    @Override
    public String getUrlString() {
        return CoreConstants.inAppMessageUrlTemplate;
    }
}
