package com.igaworks.v2.core.result;

import org.json.JSONException;
import org.json.JSONObject;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.domain.model.SubscriptionStatus;
import io.adbrix.sdk.utils.CommonUtils;

public class GetSubscriptionStatusResult extends SubscriptionStatusResult{
    private SubscriptionStatus.Type informativeNotificationFlag;
    private SubscriptionStatus.Type marketingNotificationFlag;
    private SubscriptionStatus.Type marketingNotificationFlagForPushChannel;
    private SubscriptionStatus.Type marketingNotificationFlagForSmsChannel;
    private SubscriptionStatus.Type marketingNotificationFlagForKakaoChannel;
    private SubscriptionStatus.Type marketingNotificationAtNightFlag;
    private SubscriptionStatus.Type marketingNotificationAtNightFlagForPushChannel;
    private SubscriptionStatus.Type marketingNotificationAtNightFlagForSmsChannel;
    private SubscriptionStatus.Type marketingNotificationAtNightFlagForKakaoChannel;

    public GetSubscriptionStatusResult(int statusCode, int result) {
        super.statusCode = statusCode;
        super.result_code = result;
        this.informativeNotificationFlag = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationFlag = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationFlagForPushChannel = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationFlagForSmsChannel = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationFlagForKakaoChannel = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationFlag = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationAtNightFlag = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationAtNightFlagForPushChannel = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationAtNightFlagForSmsChannel = SubscriptionStatus.Type.UNDEFINED;
        this.marketingNotificationAtNightFlagForKakaoChannel = SubscriptionStatus.Type.UNDEFINED;
    }

    public GetSubscriptionStatusResult(int statusCode, String responseBody) {
        super.statusCode = statusCode;
        if(CommonUtils.isNullOrEmpty(responseBody)){
            return;
        }
        try {
            NullableJSONObject jsonObject = new NullableJSONObject(responseBody);
            super.result_code = jsonObject.optInt(SubscriptionStatus.RESPONSE_RESULT_CODE);
            super.result_msg = jsonObject.optString(SubscriptionStatus.RESPONSE_RESULT_MSG);
            JSONObject resultData = jsonObject.getJSONObject(SubscriptionStatus.RESPONSE_RESULT_DATA);
            JSONObject properties = resultData.getJSONObject(SubscriptionStatus.RESPONSE_PROPERTIES);
            this.informativeNotificationFlag = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.INFORMATIVE_NOTIFICATION_FLAG));
            this.marketingNotificationFlag = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG));
            this.marketingNotificationFlagForPushChannel = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_PUSH_CHANNEL));
            this.marketingNotificationFlagForSmsChannel = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_SMS_CHANNEL));
            this.marketingNotificationFlagForKakaoChannel = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG_FOR_KAKAO_CHANNEL));
            this.marketingNotificationFlag = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_FLAG));
            this.marketingNotificationAtNightFlag = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG));
            this.marketingNotificationAtNightFlagForPushChannel = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_PUSH_CHANNEL));
            this.marketingNotificationAtNightFlagForSmsChannel = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_SMS_CHANNEL));
            this.marketingNotificationAtNightFlagForKakaoChannel = getSubscriptionTypeByValue(properties.optString(SubscriptionStatus.MARKETING_NOTIFICATION_AT_NIGHT_FLAG_FOR_KAKAO_CHANNEL));
        } catch (JSONException e) {
            AbxLog.w(e, false);
        }
    }

    public SubscriptionStatus.Type getInformativeNotificationFlag() {
        return informativeNotificationFlag;
    }

    public SubscriptionStatus.Type getMarketingNotificationFlag() {
        return marketingNotificationFlag;
    }

    public SubscriptionStatus.Type getMarketingNotificationFlagForPushChannel() {
        return marketingNotificationFlagForPushChannel;
    }

    public SubscriptionStatus.Type getMarketingNotificationFlagForSmsChannel() {
        return marketingNotificationFlagForSmsChannel;
    }

    public SubscriptionStatus.Type getMarketingNotificationFlagForKakaoChannel() {
        return marketingNotificationFlagForKakaoChannel;
    }

    public SubscriptionStatus.Type getMarketingNotificationAtNightFlag() {
        return marketingNotificationAtNightFlag;
    }

    public SubscriptionStatus.Type getMarketingNotificationAtNightFlagForPushChannel() {
        return marketingNotificationAtNightFlagForPushChannel;
    }

    public SubscriptionStatus.Type getMarketingNotificationAtNightFlagForSmsChannel() {
        return marketingNotificationAtNightFlagForSmsChannel;
    }

    public SubscriptionStatus.Type getMarketingNotificationAtNightFlagForKakaoChannel() {
        return marketingNotificationAtNightFlagForKakaoChannel;
    }

    @Override
    public String toString() {
        return "GetSubscriptionStatusResult{" +
                "statusCode=" + statusCode +
                ", informativeNotificationFlag=" + informativeNotificationFlag +
                ", marketingNotificationFlag=" + marketingNotificationFlag +
                ", marketingNotificationFlagForPushChannel=" + marketingNotificationFlagForPushChannel +
                ", marketingNotificationFlagForSmsChannel=" + marketingNotificationFlagForSmsChannel +
                ", marketingNotificationFlagForKakaoChannel=" + marketingNotificationFlagForKakaoChannel +
                ", marketingNotificationAtNightFlag=" + marketingNotificationAtNightFlag +
                ", marketingNotificationAtNightFlagForPushChannel=" + marketingNotificationAtNightFlagForPushChannel +
                ", marketingNotificationAtNightFlagForSmsChannel=" + marketingNotificationAtNightFlagForSmsChannel +
                ", marketingNotificationAtNightFlagForKakaoChannel=" + marketingNotificationAtNightFlagForKakaoChannel +
                ", result_code=" + result_code +
                ", result_msg='" + result_msg + '\'' +
                '}';
    }
}
