package io.adbrix.sdk.domain.model;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import javax.annotation.Nullable;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.data.NullableJSONObject;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.CoreUtils;

public class ActionContent implements IDataModel {
    public final long notificationId;
    @Nullable public final String title;
    @Nullable public final String subtitle;
    @Nullable public final String body;
    @Nullable public final String bigTextTitle;
    @Nullable public final String bigTextBody;
    @Nullable public final String summaryText;
    @Nullable public final String largeIconUrl;
    @Nullable public final String imgUrl;
    @Nullable public final JSONObject deeplinkJson;
    @Nullable public final String deeplinkUrl;
    public final boolean isWideImage;
    @Nullable public final String imageClickLink;
    public final List<KakaoButton> kakaoButtons;

    public static ActionContent fromJSONString(String jsonString) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = new JSONObject(jsonString);
        } catch (JSONException e) {
            AbxLog.w(e, false);
        }

        return new ActionContent(
                jsonObject.optLong("notification_id"),
                CommonUtils.convertNullStringToNull(jsonObject.optString("title")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("subtitle")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("body")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("big_text_title")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("big_text_body")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("summary_text")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("large_icon")),
                CommonUtils.convertNullStringToNull(jsonObject.optString("img")),
                jsonObject.optJSONObject("deep_link_json"),
                CommonUtils.convertNullStringToNull(jsonObject.optString("deep_link_url")),
                jsonObject.optBoolean("is_wide_img"),
                CommonUtils.convertNullStringToNull(jsonObject.optString("img_link")),
                KakaoButton.fromJSONString(jsonObject.optString("buttons"))
        );
    }

    public ActionContent(
            long notificationId,
            @Nullable String title,
            @Nullable String subtitle,
            @Nullable String body,
            @Nullable String bigTextTitle,
            @Nullable String bigTextBody,
            @Nullable String summaryText,
            @Nullable String largeIconUrl,
            @Nullable String imgUrl,
            @Nullable JSONObject deeplinkJson,
            @Nullable String deeplinkUrl,
            boolean isWideImage,
            @Nullable String imageClickLink,
            List<KakaoButton> kakaoButtons
    ) {
        this.notificationId = notificationId;
        this.title = title;
        this.subtitle = subtitle;
        this.body = body;
        this.bigTextTitle = bigTextTitle;
        this.bigTextBody = bigTextBody;
        this.summaryText = summaryText;
        this.largeIconUrl = largeIconUrl;
        this.imgUrl = imgUrl;
        this.deeplinkJson = deeplinkJson;
        this.deeplinkUrl = deeplinkUrl;
        this.isWideImage = isWideImage;
        this.imageClickLink = imageClickLink;
        this.kakaoButtons = kakaoButtons;
    }

    @Override
    public JSONObject getJson() throws JSONException {
        NullableJSONObject result = new NullableJSONObject();
        JSONArray kakaoButtonJson = new JSONArray(CoreUtils.mapCatching(kakaoButtons, KakaoButton::getJson));

        result.put("notification_id", notificationId);
        result.put("title", title);
        result.put("subtitle", subtitle);
        result.put("body", body);
        result.put("big_text_title", bigTextTitle);
        result.put("big_text_body", bigTextBody);
        result.put("summary_text", summaryText);
        result.put("large_icon", largeIconUrl);
        result.put("img", imgUrl);
        result.put("deep_link_json", deeplinkJson);
        result.put("deep_link_url", deeplinkUrl);
        result.put("is_wide_img", isWideImage);
        result.put("img_link", imageClickLink);
        result.put("buttons", kakaoButtonJson);

        return result;
    }

    @Override
    public String toString() {
        return "ActionContent{" +
                "notificationId=" + notificationId +
                ", title='" + title + '\'' +
                ", subtitle='" + subtitle + '\'' +
                ", body='" + body + '\'' +
                ", bigTextTitle='" + bigTextTitle + '\'' +
                ", bigTextBody='" + bigTextBody + '\'' +
                ", summaryText='" + summaryText + '\'' +
                ", largeIconUrl='" + largeIconUrl + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", deeplinkJson=" + deeplinkJson +
                ", deeplinkUrl='" + deeplinkUrl + '\'' +
                ", isWideImage=" + isWideImage +
                ", imageClickLink='" + imageClickLink + '\'' +
                ", kakaoButtons=" + kakaoButtons +
                '}';
    }
}
