package io.adbrix.sdk.domain.interactor;

import io.adbrix.sdk.domain.Repository;
import io.adbrix.sdk.domain.model.Empty;
import io.adbrix.sdk.domain.model.Result;
import io.adbrix.sdk.domain.model.ResultCallback;

public class DeleteUserDataUseCase implements UseCase<Void> {
    private final Repository repository;
    private final String userId;
    private final ResultCallback<String> callback;

    public DeleteUserDataUseCase(Repository repository, String userId, ResultCallback<String> callback) {
        this.repository = repository;
        this.userId = userId;
        this.callback = callback;
    }

    @Override
    public Void execute() {
        repository.deleteUserData(userId, callback);
        return null;
    }
}
