package io.adbrix.sdk.component.executer;


import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

import io.adbrix.sdk.component.AbxLog;

public class DFNCommandExecuter {

    private class DFNCommandRunner implements Runnable
    {
        @Override
        public void run() {
            try {
                AbxLog.d("DFNCommandRunner를 시작합니다.",true);
                //활성상태일 경우에만 로직을 실행한다.
                if (isActive.get() == false){
                    AbxLog.d("DFNCommandRunner 상태가 inactive라서 Skip합니다.",true);
                    return;
                }else {
                    loopCommandRun();
                }
                AbxLog.d("DFNCommandRunner를 종료합니다.",true);
            }catch (Exception e){
                AbxLog.e("DFNCommandRunner Error:",e,true);
            }
        }

        /***
         * 큐를 모두 실행시킨다.
         */
        private void loopCommandRun(){
            List<DFNCommandPriority> sortedPriorityValues = DFNCommandPriority.SortedEnumValues();
            for(DFNCommandPriority priority : sortedPriorityValues){
                if(commandPriorityQueue.containsKey(priority))
                {
                    ConcurrentLinkedQueue<Runnable> queue = commandPriorityQueue.get(priority);
                    while(true) {
                        Runnable command = queue.poll();
                        if (command == null){
                            break;
                        }
                        command.run();
                    }
                }
            }
        }
    }
    private AtomicBoolean isActive = new AtomicBoolean(false);
    private ConcurrentHashMap<DFNCommandPriority,ConcurrentLinkedQueue<Runnable>> commandPriorityQueue = new ConcurrentHashMap<>();
    private ExecutorService executorService;
    private Timer executorTimer;
    private Runnable endListener;

    public DFNCommandExecuter(){
        AbxLog.i("DFNCommandExecuter를 시작합니다. 1초에 한번씩 실행됩니다.",true);
        executorService = Executors.newSingleThreadExecutor();
        executorTimer = new Timer(true);
        executorTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                executorService.submit(new DFNCommandRunner());
            }
        }, 0, 1_000);
    }

    public void setEndListener(Runnable endListener){this.endListener = endListener;}

    public void endExecuter(){
        AbxLog.i("DFNCommandExecuter를 종료합니다.",true);
        executorTimer.cancel();
        if(endListener != null){
            endListener.run();
        }
    }

    public synchronized void SetActive(boolean isActive){
        this.isActive.set(isActive);
    }

    public synchronized void submit(Runnable runnable, DFNCommandPriority priority){
        ConcurrentLinkedQueue<Runnable> queue;
        if(commandPriorityQueue.containsKey(priority))
            queue = commandPriorityQueue.get(priority);
        else
        {
            queue = new ConcurrentLinkedQueue<>();
            commandPriorityQueue.put(priority, queue);
        }
        queue.add(runnable);
    }
}
