package io.adbrix.sdk.ui.inappmessage;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Bitmap;

import io.adbrix.sdk.component.AbxLog;
import io.adbrix.sdk.component.IObserver;
import io.adbrix.sdk.configuration.AbxFacade;
import io.adbrix.sdk.configuration.IABXContextController;
import io.adbrix.sdk.domain.model.DfnInAppMessage;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.utils.CommonUtils;
import io.adbrix.sdk.utils.HttpConnectionUtils;

public class InAppMessageViewFactory implements IInAppMessageViewFactory{
    public InAppMessageDAO inAppMessageDAO;
    public IABXContextController abxContextController;
    public DfnInAppMessage inAppMessage;

    public InAppMessageViewFactory(InAppMessageDAO inAppMessageDAO, IABXContextController abxContextController) {
        this.inAppMessageDAO = inAppMessageDAO;
        this.abxContextController = abxContextController;
    }

    @Override
    public void createInAppMessage(Activity activity, DfnInAppMessage inAppMessage, boolean isCarried) {
        this.inAppMessage = inAppMessage;
    }

    @Override
    public void dismissInAppMessage(Activity activity, IAMEnums.CloseType closeType) {

    }

    @Override
    public DfnInAppMessage getInAppMessage() {
        return this.inAppMessage;
    }
}
