package io.adbrix.sdk.domain.model;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

import io.adbrix.sdk.component.AbxLog;

/**
 * 2023.01.10 bobos
 * client postback시 사용할 데이터를 정리 @see("https://igaw-ad-dev.slack.com/archives/C04G3MCDA3Y/p1673329335586009?thread_ts=1673327279.990939&cid=C04G3MCDA3Y")
 */
public class EventData{
    private EventModel eventModel;
    private CommonModel commonModel;

    //event
    private String eventDatetime;
    private String eventName;
    private Map<String, Object> param;
    private String logId;

    //common
    private String packageName;
    private String appkey;
    private String apiVersion;
    private String sdkVersion;
    private String installer;
    private String appVersion;
    private String buildId;

    //identity
    private String adid;
    private String gaid;
    private String idfa;
    private String idfv;
    private boolean adIdOptOut;

    //device
    private String os;
    private String model;
    private String vendor;
    private String resolution;
    private String platform;
    private String carrier;
    private boolean isPortrait;
    private String network;
    private String language;
    private String country;

    public EventData(EventModel eventModel, CommonModel commonModel) {
        this.eventModel = eventModel;
        this.commonModel = commonModel;
    }

    public String getEventDatetime() {
        return eventModel.eventDatetime;
    }

    public String getEventName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(eventModel.group);
        stringBuilder.append(":");
        stringBuilder.append(eventModel.eventName);
        return stringBuilder.toString();
    }

    public Map<String, Object> getParam(){
        return this.eventModel.param;
    }

    public String getParamJson() {
        JSONObject paramJson = new JSONObject();
        if (this.eventModel.param != null) {
            for (String key : this.eventModel.param.keySet()) {
                try {
                    paramJson.put(key, this.eventModel.param.get(key));
                } catch (JSONException e) {
                    AbxLog.w(e, true);
                }
            }
        }
        return paramJson.toString();
    }

    public String getLogId() {
        return eventModel.logId;
    }

    public String getPackageName() {
        return commonModel.packageName;
    }

    public String getAppkey() {
        return commonModel.appkey;
    }

    public String getApiVersion() {
        return commonModel.apiVersion;
    }

    public String getSdkVersion() {
        return commonModel.sdkVersion;
    }

    public String getInstaller() {
        return commonModel.installer;
    }

    public String getAppVersion() {
        return commonModel.appVersion;
    }

    public String getBuildId() {
        return commonModel.buildId;
    }

    public String getAdid() {
        return commonModel.identityModel.adid;
    }

    public String getGaid() {
        return commonModel.identityModel.gaid;
    }

    public String getIdfa() {
        return commonModel.identityModel.idfa;
    }

    public String getIdfv() {
        return commonModel.identityModel.idfv;
    }

    public boolean isAdIdOptOut() {
        return commonModel.identityModel.adIdOptOut;
    }

    public String getOs() {
        return commonModel.deviceInfo.os;
    }

    public String getModel() {
        return commonModel.deviceInfo.model;
    }

    public String getVendor() {
        return commonModel.deviceInfo.vendor;
    }

    public String getResolution() {
        return commonModel.deviceInfo.resolution;
    }

    public String getPlatform() {
        return commonModel.deviceInfo.platform;
    }

    public String getCarrier() {
        return commonModel.deviceInfo.carrier;
    }

    public boolean isPortrait() {
        return commonModel.deviceInfo.isPortrait;
    }

    public String getNetwork() {
        return commonModel.deviceInfo.network;
    }

    public String getLanguage() {
        return commonModel.deviceInfo.language;
    }

    public String getCountry() {
        return commonModel.deviceInfo.country;
    }

    @Override
    public String toString() {
        return "EventData{" +
                "eventName='" + getEventName() + '\'' +
                ", eventDatetime='" + getEventDatetime() + '\'' +
                '}';
    }
}
