package io.adbrix.sdk.data.modelprovider;

import android.content.Context;

import com.igaworks.v2.core.AdBrixRm;

import org.json.JSONArray;

import io.adbrix.sdk.component.IABXComponentsFactory;
import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.DfnInAppMessageFetchMode;
import io.adbrix.sdk.domain.model.IAMEnums;
import io.adbrix.sdk.domain.model.InAppMessageApiModel;
import io.adbrix.sdk.utils.CommonUtils;

public class InAppMessageApiModelProvider implements IApiModelProvider<InAppMessageApiModel> {
    private final DataRegistry dataRegistry;
    private final Context context;
    private final DeviceRealtimeDataProvider deviceRealtimeDataProvider;
    private final IABXComponentsFactory componentsFactory;
    private final JSONArray requiredCampaignIds;


    public InAppMessageApiModelProvider(
            DataRegistry dataRegistry,
            Context context,
            DeviceRealtimeDataProvider deviceRealtimeDataProvider,
            IABXComponentsFactory componentsFactory,
            JSONArray requiredCampaignIds
    ) {
        this.dataRegistry = dataRegistry;
        this.context = context;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
        this.componentsFactory = componentsFactory;
        this.requiredCampaignIds = requiredCampaignIds;
    }

    @Override
    public InAppMessageApiModel provide() {
        int inAppMessageFetchModeValue = dataRegistry.safeGetInt(DataRegistryKey.INT_IN_APP_MESSAGE_FETCH_MODE_VALUE, -1);
        DfnInAppMessageFetchMode inAppMessageFetchMode = DfnInAppMessageFetchMode.fromInteger(inAppMessageFetchModeValue);

        String userId = null;
        if (inAppMessageFetchMode == DfnInAppMessageFetchMode.USER_ID) {
            userId = AdBrixRm.getUserId();
            if(CommonUtils.isNullOrEmpty(userId)){
                userId = null;
            }
        }

        return new InAppMessageApiModel(
                new CommonModelProvider(dataRegistry, context, deviceRealtimeDataProvider).provide(),
                dataRegistry.safeGetString(DataRegistryKey.STRING_IN_APP_MESSAGE_CHECKSUM, ""),
                userId,
                requiredCampaignIds,
                IAMEnums.LayoutType.getSupportedLayout()
        );
    }
}
