package io.adbrix.sdk.data.modelprovider;

import android.content.Context;

import io.adbrix.sdk.data.dataprovider.DeviceRealtimeDataProvider;
import io.adbrix.sdk.data.entity.DataRegistryKey;
import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.model.CommonModel;
import io.adbrix.sdk.domain.model.DFNIDModel;
import io.adbrix.sdk.utils.CommonUtils;

public class DFNIDModelProvider implements IApiModelProvider<DFNIDModel> {
    private final DataRegistry dataRegistry;
    private final Context androidContext;
    private final DeviceRealtimeDataProvider deviceRealtimeDataProvider;

    public DFNIDModelProvider(DataRegistry dataRegistry, Context androidContext, DeviceRealtimeDataProvider deviceRealtimeDataProvider) {
        this.dataRegistry = dataRegistry;
        this.androidContext = androidContext;
        this.deviceRealtimeDataProvider = deviceRealtimeDataProvider;
    }

    @Override
    public DFNIDModel provide() {
        CommonModelProvider commonModelProvider = new CommonModelProvider(dataRegistry, androidContext, deviceRealtimeDataProvider);
        CommonModel commonModel = (CommonModel) commonModelProvider.provide();

        return new DFNIDModel(commonModel.identityModel, commonModel.deviceInfo, CommonUtils.getCurrentUTCInDBFormat());
    }
}
