package io.adbrix.sdk.component;

import io.adbrix.sdk.domain.function.Supplier;
import io.adbrix.sdk.domain.function.ThrowingSupplier;

public class Lazy<T> implements Supplier<T> {

    private Supplier<? extends T> supplier;
    private volatile T value;

    private Lazy(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
        return new Lazy<>(supplier);
    }

    @Override
    public T get(){
        T localReference = value;
        if (localReference == null) {
            synchronized (this) {
                localReference = value;
                if (localReference == null) {
                    localReference = this.supplier.get();
                    this.value = localReference;
                    this.supplier = null;
                }
            }
        }
        return localReference;
    }
}
