package io.adbrix.sdk.domain.interactor;

import com.igaworks.v2.core.AdBrixRm;

import io.adbrix.sdk.data.repository.DataRegistry;
import io.adbrix.sdk.domain.Repository;

public class GetSubscriptionStatusUseCase implements UseCase<Void>{
    private final AdBrixRm.GetSubscriptionStatusCallback callback;
    private final DataRegistry dataRegistry;
    private final Repository repository;

    public GetSubscriptionStatusUseCase(AdBrixRm.GetSubscriptionStatusCallback callback, DataRegistry dataRegistry, Repository repository) {
        this.callback = callback;
        this.dataRegistry = dataRegistry;
        this.repository = repository;
    }

    @Override
    public Void execute() {
        repository.getSubscriptionStatus(callback, dataRegistry);
        return null;
    }
}
